---
name: Bug Report
about: Open a new bug report
title: ''
labels: ''
assignees: ''
---

**Introduction**
_This section is provided for information only. Please delete if no longer required._

Before raising a bug/issue please check that it has not already been reported
by searching https://github.com/darktable-org/darktable/issues.

Please be aware that most developers work on this project in their free time.
The more information you can provide in the initial report the quicker we can help.
Therefore please help by being as accurate and concise as possible!

For further information, please see https://github.com/darktable-org/darktable/wiki#reporting-bugs.
---------------------------------------------------------------


**Describe the bug/issue**


**To Reproduce**
_Please provide detailed steps to reproduce the behaviour, for example:_
1. Go to '...'
2. Click on '...'
3. Scroll down to '...'
4. See error

**Expected behavior**


**Screenshots**
_(if applicable)_

**Screencast**
_(if applicable)_

**Which commit introduced the error**
_If possible, please try using `git bisect` to determine which commit introduced the issue and place the result here._

_A bisect is much appreciated and can significantly simplify the developer's job._
_HowTo: https://github.com/darktable-org/darktable/wiki#finding-bug-causes and https://www.youtube.com/watch?v=D7JJnLFOn4A_




**Platform**
_Please fill as much information as possible in the list given below. Please state "unknown" where you do not know the answer and remove any sections that are not applicable _

* darktable version : e.g. 3.5.0+250~gee17c5dcc
* OS                : e.g. Linux - kernel 5.10.2 / Win10 (Patchlevel) / OSx
* Linux - Distro    : e.g. Ubuntu 18.4
* Memory            : 
* Graphics card     : 
* Graphics driver   : 
* OpenCL installed  : 
* OpenCL activated  : 
* Xorg              : 
* Desktop           : 
* GTK+              : 
* gcc               : 
* cflags            : 
* CMAKE_BUILD_TYPE  : 

**Additional context**
_Please provide any additional information you think may be useful, for example:_

 - Can you reproduce with another darktable version(s)? **yes with version x-y-z / no**
 - Can you reproduce with a RAW or Jpeg or both? **RAW-file-format/Jpeg/both**
 - Are the steps above reproducible with a fresh edit (i.e. after discarding history)? **yes/no**
 - If the issue is with the output image, attach an XMP file if (you'll have to change the extension to `.txt`)
 - Is the issue still present using an empty/new config-dir (e.g. start darktable with --configdir "/tmp")? **yes/no**
 - Do you use lua scripts?
   - What lua scripts start automatically?
   - What lua scripts were running when the bug occurred?
