#!/usr/bin/env python

# Copyright (C) 2004 Scott W. Dunlop <sdunlop at users.sourceforge.net>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

from distutils.core import setup

setup(
    name='cloud_wiki',
    version='1.0',
    author='Scott Dunlop',
    author_email='sdunlop@users.sourceforge.net',
    url='http://kabuki.merseine.nu:1080/cloud',
    download_url='http://sourceforge.net/project/showfiles.php?group_id=128670',
    description=(
        'A wiki engine backed by sqlite that provides its own http server,'
        ' user authentication and is easy to administer from the command line.'
    ),
    long_description=(
        'Cloud Wiki was implemented as a response to the lack of Python wiki'
        ' servers that are intended to run as an individual server process'
        ' and provide functionality to meet its designer\'s needs.'
        '\n\n'
        'Cloud Wiki\'s nodes are stored in a sqlite database, and served using'
        ' python\'s BaseHTTPServer, running as a long lived application'
        ' service.  Wiki markup is a simple unobtrusive dialect, providing'
        ' free linking, images, tables, unordered lists and preformatted'
        ' text blocks. Rendered content data is stored in the database, along'
        ' with content change information, to improve server response times.'
        '\n\n'
        'Cloud Wiki supports user authentication, but does not currently'
        ' provide an registration interface of its own -- the authentication'
        ' system is designed to be modular and easily extended by adding'
        ' functionality to check passwords from other existing databases or to'
        ' periodically import them using a cron script.'
        '\n'
    ),
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Environment :: Web Environment',
        'Intended Audience :: System Administrators',
        'Intended Audience :: Information Technology',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Natural Language :: English',
        'Operating System :: POSIX',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Topic :: Internet :: WWW/HTTP :: HTTP Servers',
        'Topic :: Text Processing :: Markup',
        'Topic :: Text Processing :: Markup :: HTML'
    ],
    packages = [ 'cloud_wiki' ],
    package_data = { 'cloud_wiki' : [ 'fragments/*' ] },
    scripts=[ 'scripts/cloud-wiki' ]
)