/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.border.EmptyBorder;

public class CDFSpecPanel
extends JLabeledPanel
implements CDFConstants {
    static final long serialVersionUID = 1L;
    private JLabeledTF version = new JLabeledTF("Version", 7);
    private JLabeledTF format;
    private JLabeledTF encoding;
    private JLabeledTF majority;
    private JLabeledTF numzVars;
    private JLabeledTF numAttrs;
    private JLabeledTF maxRecN;
    private JLabeledTF compression;
    private JLabeledTF checksum;
    private JLabeledTF lastUpdated;
    private Font numAttrCurrFont;

    public void reset() {
        this.version.set("");
        this.format.set("");
        this.encoding.set("");
        this.majority.set("");
        this.numzVars.set("");
        this.numAttrs.set("");
        this.maxRecN.set("");
        this.compression.set("");
        this.checksum.set("");
        this.lastUpdated.set("");
    }

    public void set(CDF cDF) {
        try {
            String string = cDF.getVersion();
            this.version.set(string);
            this.format.set(CDFUtils.getStringFormat((CDF)cDF));
            this.encoding.set(CDFUtils.getStringEncoding((CDF)cDF));
            this.majority.set(CDFUtils.getStringMajority((CDF)cDF));
            this.numzVars.set("" + cDF.getNumZvars());
            this.numAttrs.set("" + cDF.getNumAttrs() + '(' + cDF.getNumGattrs() + "g/" + cDF.getNumVattrs() + "v)");
            if (((String)this.numAttrs.get()).length() >= 11) {
                this.numAttrs.textField.setFont(new Font(this.numAttrCurrFont.getName(), this.numAttrCurrFont.getStyle(), this.numAttrCurrFont.getSize() - 1));
            } else {
                this.numAttrs.textField.setFont(this.numAttrCurrFont);
            }
            int n = CDFToolUtils.getMaxRecNum(cDF);
            this.maxRecN.set("" + (n + 1));
            this.compression.set(cDF.getCompression());
            this.checksum.set(CDFUtils.getStringChecksum((CDF)cDF));
            long l = cDF.getLeapSecondLastUpdated();
            if (string.compareTo("3.6.0") < 0 || l < 0L) {
                this.lastUpdated.set("Not Set");
            } else {
                this.lastUpdated.set("" + l);
            }
        }
        catch (CDFException cDFException) {
            System.err.println("Error: " + cDFException.toString());
        }
    }

    public void setRec(int n) {
        this.maxRecN.set("" + n);
    }

    public CDFSpecPanel() {
        super("CDF Specifications", 0);
        this.version.textField.setEditable(false);
        this.version.textField.setOpaque(false);
        this.version.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.format = new JLabeledTF("Format", 7);
        this.format.textField.setEditable(false);
        this.format.textField.setOpaque(false);
        this.format.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.encoding = new JLabeledTF("Encoding", 7);
        this.encoding.textField.setEditable(false);
        this.encoding.textField.setOpaque(false);
        this.encoding.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.majority = new JLabeledTF("Majority", 7);
        this.majority.textField.setEditable(false);
        this.majority.textField.setOpaque(false);
        this.majority.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.numzVars = new JLabeledTF("NumzVars", 5);
        this.numzVars.textField.setEditable(false);
        this.numzVars.textField.setOpaque(false);
        this.numzVars.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.numAttrs = new JLabeledTF("NumAttrs", 5);
        this.numAttrs.textField.setEditable(false);
        this.numAttrs.textField.setOpaque(false);
        this.numAttrs.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.numAttrCurrFont = this.numAttrs.getFont();
        this.maxRecN = new JLabeledTF("Max Rec #", 7);
        this.maxRecN.textField.setEditable(false);
        this.maxRecN.textField.setOpaque(false);
        this.maxRecN.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.compression = new JLabeledTF("Compression", 10);
        this.compression.textField.setEditable(false);
        this.compression.textField.setOpaque(false);
        this.compression.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.checksum = new JLabeledTF("Checksum", 5);
        this.checksum.textField.setEditable(false);
        this.checksum.textField.setOpaque(false);
        this.checksum.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.lastUpdated = new JLabeledTF("LeapTableUpdated", 8);
        this.lastUpdated.textField.setEditable(false);
        this.lastUpdated.textField.setOpaque(false);
        this.lastUpdated.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add(this.version);
        this.add(Box.createRigidArea(new Dimension(3, 1)));
        this.add(this.format);
        this.add(Box.createRigidArea(new Dimension(3, 1)));
        this.add(this.encoding);
        this.add(Box.createRigidArea(new Dimension(3, 1)));
        this.add(this.majority);
        this.add(Box.createRigidArea(new Dimension(3, 1)));
        this.add(this.numzVars);
        this.add(Box.createRigidArea(new Dimension(3, 1)));
        this.add(this.numAttrs);
        this.add(Box.createRigidArea(new Dimension(3, 1)));
        this.add(this.maxRecN);
        this.add(Box.createRigidArea(new Dimension(3, 1)));
        this.add(this.compression);
        this.add(Box.createRigidArea(new Dimension(3, 1)));
        this.add(this.checksum);
        this.add(Box.createRigidArea(new Dimension(3, 1)));
        this.add(this.lastUpdated);
    }
}

