/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.UIManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CDFExport
extends JFrame
implements ActionListener,
ItemListener,
MouseListener,
FocusListener,
CDFConstants,
Runnable {
    static final long serialVersionUID = 1L;
    static int INITIAL_WIDTH = 400;
    static int INITIAL_HEIGHT = 200;
    static boolean defaultModal = false;
    static String osName = System.getProperty("os.name");
    public CDFExport cdfexport;
    private JFrame parentDriver;
    private JDialog dialog;
    protected CDF sourceCDF;
    private String channelFile;
    private ExportGeneralOptions aGeneral;
    private ExportToCDFOptions aToCDF;
    private ExportFilterOptions aFilter;
    private ExportCDFTable aCDFTable;
    private boolean filterChanged;
    protected boolean MacOS;
    private boolean WindowsOS;
    private ButtonGroup outputgp;
    private JRadioButton output1;
    private JRadioButton output2;
    private JRadioButton output3;
    private JRadioButton output4;
    private JButton entrb;
    private JButton helpb;
    private JButton quitb;
    private JButton slt1;
    private JButton slt2;
    private JButton slt3;
    private JButton slt4;
    private JCheckBox abc;
    protected JTextArea info;
    private JTextField cdf1;
    private JTextField cdf2;
    private JTextField cdf3;
    private JTextField cdf4;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JScrollPane scroller;
    protected Vector vars;
    protected String cdfspec1;
    protected String cdfspec2;
    protected String cdfspec3;
    protected String cdfspec4;
    private String oldspec1;
    private int oldSel;
    private String currentdir;
    private String[] cdfs;
    private SimpleFileFilter cdffilter;
    private JTextField focused;
    private JTextField prevfocused;
    private int filtering;
    private int validMin;
    private int validMax;
    private int fillVal;
    private int backwardEnvVar;
    protected long backwardFlag;
    protected int ROWS;
    protected int COLUMNS;
    protected long majority;
    protected long encoding;
    protected int epoch;
    protected long format;
    protected int compressionType;
    protected int compressionLevel;
    protected long checksum;
    protected int overwrite;
    protected int trans0;
    protected int recordNum;
    protected int indiceNum;
    protected int headings;
    protected int orientation;
    protected int outSelection;
    protected boolean changedCDF;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuEdit;
    private JMenu menuOptions;
    private JMenu menuHelp;
    private JMenuItem menuEditCopy;
    private JMenuItem menuEditCut;
    private JMenuItem menuEditPaste;
    private JMenuItem menuFileOpen;
    private JMenuItem menuOptionsGeneral;
    private JMenuItem menuOptionsToCDFv3;
    private JMenuItem menuOptionsToCDFv2;
    private JMenuItem menuOptionsFilter;
    private JMenuItem menuFileExit;
    private JMenuItem menuHelpHelp;
    private int istart;
    private int iend;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    Dimension hpad5;
    Dimension hpad10;
    Dimension hpad20;
    Dimension hpad25;
    Dimension hpad30;
    Dimension hpad40;
    Dimension hpad80;
    Dimension vpad5;
    Dimension vpad10;
    Dimension vpad20;
    Dimension vpad25;
    Dimension vpad30;
    Dimension vpad40;
    Dimension vpad80;
    Font defaultFont;
    Font boldFont;
    Font bigFont;
    Font bigboldFont;
    boolean modal;
    int frommain;

    public void run() {
        this.buildUIs();
        this.cdfexport.pack();
        Dimension dimension = this.cdfexport.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.cdfexport.setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
        this.cdfexport.setVisible(true);
        if (this.parentDriver != null) {
            this.parentDriver.setVisible(false);
        }
    }

    public void reEnter() {
        this.cdfexport.setVisible(true);
        if (this.parentDriver != null) {
            this.parentDriver.setVisible(false);
        }
    }

    private final void buildUIs() {
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
                if (CDFExport.this.frommain == 0) {
                    if (CDFExport.this.modal) {
                        CDFExport.this.cdfexport.dispose();
                    } else {
                        CDFExport.this.cdfexport.setVisible(false);
                    }
                    if (CDFExport.this.parentDriver != null) {
                        CDFExport.this.parentDriver.setVisible(true);
                    }
                } else {
                    System.exit(1);
                }
            }
        });
        this.cdfexport.setTitle("Enter   Selections  for  CDFExport");
        this.cdfexport.setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
        this.cdfexport.getContentPane().setLayout(new BorderLayout());
        this.addMenu();
        JPanel jPanel = new JPanel(new BorderLayout(), true);
        this.slt1 = new JButton("Select");
        this.cdf1 = new JTextField("", 40);
        this.label1 = new JLabel("CDF: ");
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        this.makeJButton(this.gbl, this.gbc, jPanel2, Box.createRigidArea(this.vpad10), 0, 0, 1, 1, 1.0, 1.0);
        this.makeJButton(this.gbl, this.gbc, jPanel2, this.label1, 0, 1, 1, 1, 1.0, 1.0);
        this.makeJButton(this.gbl, this.gbc, jPanel2, this.cdf1, 1, 1, 1, 1, 1.0, 1.0);
        this.makeJButton(this.gbl, this.gbc, jPanel2, Box.createRigidArea(this.hpad20), 2, 1, 1, 1, 1.0, 1.0);
        this.makeJButton(this.gbl, this.gbc, jPanel2, this.slt1, 3, 1, 1, 1, 1.0, 1.0);
        this.makeJButton(this.gbl, this.gbc, jPanel2, Box.createRigidArea(this.vpad20), 0, 2, 1, 1, 1.0, 1.0);
        this.cdf1.addActionListener(this);
        this.slt1.addActionListener(this);
        this.label1.setLabelFor(this.cdf1);
        this.label1.setFont(this.boldFont);
        this.cdf1.setFont(this.boldFont);
        this.cdf1.setToolTipText("Enter the source CDF file (without extension) for export");
        this.slt1.setToolTipText("Use the file chooser to select the source CDF");
        jPanel.add((Component)jPanel2, "North");
        this.outputgp = new ButtonGroup();
        this.output1 = new JRadioButton("Output to the Screen");
        this.output2 = new JRadioButton("Output to a Text File");
        this.output3 = new JRadioButton("Output to a V3 CDF File");
        this.output4 = new JRadioButton("Output to a V2 CDF File");
        OutputListener outputListener = new OutputListener();
        this.output1.setActionCommand("1");
        this.output2.setActionCommand("2");
        this.output3.setActionCommand("3");
        this.output4.setActionCommand("4");
        this.output1.addActionListener(outputListener);
        this.output2.addActionListener(outputListener);
        this.output3.addActionListener(outputListener);
        this.output4.addActionListener(outputListener);
        this.output1.setSelected(true);
        this.outputgp.add(this.output1);
        this.outputgp.add(this.output2);
        this.outputgp.add(this.output3);
        this.outputgp.add(this.output4);
        this.output1.setToolTipText("Output the results to the screen");
        this.output2.setToolTipText("Output the results to a text file");
        this.output3.setToolTipText("Export the results to a V3 CDF file");
        this.output4.setToolTipText("Export the results to a V2 CDF file");
        this.abc = new JCheckBox("About");
        this.abc.addItemListener(this);
        this.abc.setToolTipText("Check the CDF library version");
        JPanel jPanel3 = new JPanel(new BorderLayout(), true);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 1), true);
        JPanel jPanel5 = new JPanel(new BorderLayout(), true);
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1), true);
        JPanel jPanel7 = new JPanel(new BorderLayout(), true);
        JPanel jPanel8 = new JPanel(new BorderLayout(), true);
        JPanel jPanel9 = new JPanel(new GridLayout(2, 1), true);
        JPanel jPanel10 = new JPanel(new BorderLayout(), true);
        JPanel jPanel11 = new JPanel(new BorderLayout(), true);
        JPanel jPanel12 = new JPanel(new GridLayout(2, 1), true);
        JPanel jPanel13 = new JPanel(new BorderLayout(), true);
        JPanel jPanel14 = new JPanel(new BorderLayout(), true);
        jPanel4.add(this.output1);
        this.label2 = new JLabel("    Output Text File Name: ");
        this.cdf2 = new JTextField("", 30);
        this.cdf2.addActionListener(this);
        this.cdf2.addMouseListener(this);
        this.cdf2.addFocusListener(this);
        this.slt2 = new JButton("Select");
        jPanel6.add(this.output2);
        jPanel8.add((Component)this.label2, "West");
        jPanel8.add((Component)this.cdf2, "East");
        jPanel7.add((Component)jPanel8, "West");
        jPanel7.add((Component)this.slt2, "East");
        jPanel6.add(jPanel7);
        this.slt2.addActionListener(this);
        this.cdf2.setToolTipText("Enter the output text file name (without extension) ");
        this.slt2.setToolTipText("Use the file chooser to select the output file");
        this.label3 = new JLabel("    Output CDF File Name: ");
        this.cdf3 = new JTextField("", 30);
        this.cdf3.addActionListener(this);
        this.cdf3.addMouseListener(this);
        this.cdf3.addFocusListener(this);
        this.slt3 = new JButton("Select");
        this.label4 = new JLabel("    Output CDF File Name: ");
        this.cdf4 = new JTextField("", 30);
        this.cdf4.addActionListener(this);
        this.cdf4.addMouseListener(this);
        this.cdf4.addFocusListener(this);
        this.slt4 = new JButton("Select");
        jPanel9.add(this.output3);
        jPanel11.add((Component)this.label3, "West");
        jPanel11.add((Component)this.cdf3, "East");
        jPanel10.add((Component)jPanel11, "West");
        jPanel10.add((Component)this.slt3, "East");
        jPanel9.add(jPanel10);
        jPanel12.add(this.output4);
        jPanel14.add((Component)this.label4, "West");
        jPanel14.add((Component)this.cdf4, "East");
        jPanel13.add((Component)jPanel14, "West");
        jPanel13.add((Component)this.slt4, "East");
        jPanel12.add(jPanel13);
        this.slt3.addActionListener(this);
        this.slt4.addActionListener(this);
        this.cdf2.setToolTipText("Enter the output CDF file name (without extension) ");
        this.slt3.setToolTipText("Use the file chooser to select the output V3 CDF file");
        this.slt4.setToolTipText("Use the file chooser to select the output V2 CDF file");
        if (this.backwardEnvVar == 0) {
            jPanel3.setLayout(new GridLayout(5, 1));
        } else {
            jPanel3.setLayout(new GridLayout(4, 1));
        }
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel6);
        if (this.backwardEnvVar == 0) {
            jPanel3.add(jPanel9);
        }
        jPanel3.add(jPanel12);
        jPanel3.add(this.abc);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel15 = new JPanel(new BorderLayout(), true);
        JPanel jPanel16 = new JPanel(new GridLayout(1, 5, 50, 20), true);
        this.entrb = new JButton(" Enter ");
        this.helpb = new JButton(" Help ");
        this.quitb = new JButton(" Quit ");
        jPanel16.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel16.add(this.entrb);
        jPanel16.add(this.helpb);
        jPanel16.add(this.quitb);
        jPanel16.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel15.add((Component)jPanel16, "North");
        this.entrb.addActionListener(this);
        this.helpb.addActionListener(this);
        this.quitb.addActionListener(this);
        this.entrb.setToolTipText("Continue processing...");
        this.helpb.setToolTipText("Get the help information");
        this.quitb.setToolTipText("Exit CDFExport");
        this.info = new JTextArea(15, 20);
        this.info.setEditable(false);
        this.info.setVisible(true);
        this.scroller = new JScrollPane(){
            static final long serialVersionUID = 1L;

            public final Dimension getPreferredSize() {
                return new Dimension(80, 160);
            }

            public final float getAlignmentX() {
                return 0.0f;
            }
        };
        this.scroller.getViewport().add(this.info);
        jPanel.add((Component)jPanel15, "South");
        this.cdfexport.getContentPane().add((Component)jPanel, "North");
        this.cdfexport.getContentPane().add((Component)this.scroller, "Center");
    }

    private final void addMenu() {
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuEdit = new JMenu("Edit");
        this.menuOptions = new JMenu("Options");
        this.menuHelp = new JMenu("Help");
        this.menuEditCopy = new JMenuItem("Copy");
        this.menuEditCut = new JMenuItem("Cut");
        this.menuEditPaste = new JMenuItem("Paste");
        this.menuFileOpen = new JMenuItem("Open");
        this.menuOptionsGeneral = new JMenuItem("Output to Screen/Text File");
        this.menuOptionsToCDFv3 = new JMenuItem("Output to V3 CDF");
        this.menuOptionsToCDFv2 = new JMenuItem("Output to V2 CDF");
        this.menuOptionsFilter = new JMenuItem("Data Filtering");
        this.menuFileExit = new JMenuItem("Exit");
        this.menuHelpHelp = new JMenuItem("Help");
        this.cdfexport.setJMenuBar(this.menuBar);
        this.menuBar.add(this.menuFile);
        this.menuFile.add(this.menuFileOpen);
        this.menuFile.add(this.menuFileExit);
        this.menuFileOpen.addActionListener(this);
        this.menuFileExit.addActionListener(this);
        this.menuBar.add(this.menuEdit);
        this.menuEdit.add(this.menuEditCopy);
        this.menuEdit.add(this.menuEditCut);
        this.menuEdit.add(this.menuEditPaste);
        this.menuEditCopy.addActionListener(this);
        this.menuEditCut.addActionListener(this);
        this.menuEditPaste.addActionListener(this);
        this.menuBar.add(this.menuOptions);
        this.menuOptions.add(this.menuOptionsGeneral);
        if (this.backwardEnvVar == 0) {
            this.menuOptions.add(this.menuOptionsToCDFv3);
        }
        this.menuOptions.add(this.menuOptionsToCDFv2);
        this.menuOptions.add(this.menuOptionsFilter);
        this.menuOptionsGeneral.addActionListener(this);
        this.menuOptionsToCDFv3.addActionListener(this);
        this.menuOptionsToCDFv2.addActionListener(this);
        this.menuOptionsFilter.addActionListener(this);
        this.menuOptionsGeneral.setToolTipText("Select options for output to screen or a trext file");
        this.menuOptionsToCDFv3.setToolTipText("Select options for a V3 CDF file creation");
        this.menuOptionsToCDFv2.setToolTipText("Select options for a V2 CDF file creation");
        this.menuOptionsFilter.setToolTipText("Select options for filtering data values");
        this.menuBar.add(this.menuHelp);
        this.menuHelp.add(this.menuHelpHelp);
        this.menuHelpHelp.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.quitb || object == this.menuFileExit) {
            if (this.frommain == 0) {
                if (this.modal) {
                    this.cdfexport.dispose();
                } else {
                    this.cdfexport.setVisible(false);
                }
                if (this.parentDriver != null) {
                    this.parentDriver.setVisible(true);
                }
            } else {
                System.exit(1);
            }
        } else if (object == this.menuFileOpen || object == this.slt1 || object == this.slt2 || object == this.slt3 || object == this.slt4) {
            if (object == this.slt1 || object == this.menuFileOpen) {
                String string = CDFToolUtils.doFileChooser("Select/Enter the Source CDF File Name", 1, this.cdffilter, this.currentdir, this.cdfexport);
                if (string != null && string.trim().length() != 0) {
                    if (this.MacOS) {
                        this.currentdir = string.substring(0, string.lastIndexOf(47));
                        if (string.startsWith(":") || string.startsWith("/")) {
                            string = string.substring(1);
                        }
                        string = string.replace('/', ':');
                    } else {
                        int n = this.WindowsOS ? string.lastIndexOf(92) : string.lastIndexOf(47);
                        this.currentdir = n != -1 ? string.substring(0, n) : System.getProperty("user.dir");
                    }
                    this.cdf1.setText(string);
                    System.getProperties().put("user.dir", this.currentdir);
                    if (this.oldspec1 != null && this.aGeneral != null) {
                        this.aGeneral.reset();
                    }
                    if (this.oldspec1 != null && this.aToCDF != null) {
                        this.aToCDF.reset();
                    }
                    if (this.oldspec1 != null && this.aFilter != null) {
                        this.aFilter.reset();
                    }
                }
            } else if (object == this.slt3 || object == this.slt4) {
                if (object == this.slt3) {
                    this.output3.setSelected(true);
                } else {
                    this.output4.setSelected(true);
                }
                String string = CDFToolUtils.doFileChooser("Select/Enter the Output CDF File Name", 1, this.cdffilter, this.currentdir, this.cdfexport);
                if (string != null && string.trim().length() != 0) {
                    if (this.MacOS) {
                        this.currentdir = string.substring(0, string.lastIndexOf(47));
                        if (string.startsWith(":") || string.startsWith("/")) {
                            string = string.substring(1);
                        }
                        string = string.replace('/', ':');
                    } else {
                        int n = this.WindowsOS ? string.lastIndexOf(92) : string.lastIndexOf(47);
                        this.currentdir = n != -1 ? string.substring(0, n) : System.getProperty("user.dir");
                    }
                    this.cdf2.setText("");
                    if (object == this.slt3) {
                        this.cdf3.setText(string);
                        this.output3.setSelected(true);
                        this.cdf4.setText("");
                    } else {
                        this.cdf4.setText(string);
                        this.output3.setSelected(true);
                        this.cdf3.setText("");
                    }
                    System.getProperties().put("user.dir", this.currentdir);
                } else if (object == this.slt3) {
                    this.cdf3.requestFocus();
                    this.cdf3.setCaretPosition(0);
                } else {
                    this.cdf4.requestFocus();
                    this.cdf4.setCaretPosition(0);
                }
            } else {
                String string = CDFToolUtils.doFileChooser("Select/Enter the Output File Name", 1, null, this.currentdir, this.cdfexport);
                if (string != null && string.trim().length() != 0) {
                    if (this.MacOS) {
                        this.currentdir = string.substring(0, string.lastIndexOf(47));
                        if (string.startsWith(":") || string.startsWith("/")) {
                            string = string.substring(1);
                        }
                        string = string.replace('/', ':');
                    } else {
                        int n = this.WindowsOS ? string.lastIndexOf(92) : string.lastIndexOf(47);
                        this.currentdir = n != -1 ? string.substring(0, n) : System.getProperty("user.dir");
                    }
                    this.cdf2.setText(string);
                    this.output2.setSelected(true);
                    this.cdf3.setText("");
                    this.cdf4.setText("");
                    System.getProperties().put("user.dir", this.currentdir);
                }
            }
        } else if (object == this.helpb || object == this.menuHelpHelp) {
            this.info.setText("");
            try {
                InputStream inputStream = this.cdfexport.getClass().getResourceAsStream("cdfxp.txt");
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                this.info.read(inputStreamReader, null);
                this.info.setCaretPosition(0);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.info.setText("Help info is not available...");
            }
            catch (IOException iOException) {
                this.info.setText("Help info is not available...");
            }
            catch (Exception exception) {
                this.info.setText("Help info is not available...");
            }
        } else if (object == this.entrb) {
            Object object2;
            this.info.setText("");
            this.cdfspec1 = this.cdf1.getText();
            if (this.cdfspec1 == null || this.cdfspec1.equals("") || this.cdfspec1.trim().length() == 0) {
                this.info.setText("Please enter the source CDF file name");
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.MacOS) {
                this.cdfspec1 = this.cdfspec1.replace('/', ':');
                if (this.cdfspec1.startsWith(":")) {
                    this.cdfspec1 = this.cdfspec1.substring(1);
                }
            }
            int n = -99;
            String string = this.outputgp.getSelection().getActionCommand();
            if (string.equals("1")) {
                n = 1;
            } else if (string.equals("3") || string.equals("4")) {
                object2 = string.equals("3") ? this.cdf3.getText() : this.cdf4.getText();
                if (object2 == null || ((String)object2).equals("") || ((String)object2).trim().length() == 0) {
                    this.info.setText("Please enter the destination CDF file name");
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (this.MacOS && ((String)(object2 = ((String)object2).replace('/', ':'))).startsWith(":")) {
                    object2 = ((String)object2).substring(1);
                }
                if (string.equals("3")) {
                    n = 3;
                    this.cdfspec3 = object2;
                    this.backwardFlag = 0L;
                } else {
                    n = 4;
                    this.cdfspec4 = object2;
                    this.backwardFlag = 1L;
                }
            } else if (string.equals("2")) {
                this.cdfspec2 = this.cdf2.getText();
                if (this.cdfspec2.equals("") || this.cdfspec2.trim().length() == 0) {
                    this.info.setText("Please enter the output file name");
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (this.MacOS) {
                    this.cdfspec2 = this.cdfspec2.replace('/', ':');
                    if (this.cdfspec2.startsWith(":")) {
                        this.cdfspec2 = this.cdfspec1.substring(1);
                    }
                }
                n = 2;
            }
            if (this.getCDF()) {
                if (this.aCDFTable == null || this.changedCDF || this.outSelection != n) {
                    if (this.changedCDF) {
                        this.changedCDF = false;
                    }
                    this.filterChanged = true;
                    this.outSelection = n;
                    object2 = this.parentDriver == null ? this : this.parentDriver;
                    this.aCDFTable = ExportCDFTable.createCDFTable((JFrame)object2, this.cdfexport, this.cdfspec1);
                } else {
                    this.aCDFTable.reEnter();
                }
            }
        } else if (object == this.cdf1) {
            this.cdfspec1 = this.cdf1.getText();
            if (this.MacOS) {
                this.cdfspec1 = this.cdfspec1.replace('/', ':');
                if (this.cdfspec1.startsWith(":")) {
                    this.cdfspec1 = this.cdfspec1.substring(1);
                }
            }
        } else if (object == this.cdf2) {
            this.cdfspec2 = this.cdf2.getText();
            if (this.MacOS) {
                this.cdfspec2 = this.cdfspec2.replace('/', ':');
                if (this.cdfspec2.startsWith(":")) {
                    this.cdfspec2 = this.cdfspec2.substring(1);
                }
            }
            this.output2.setSelected(true);
        } else if (object == this.cdf3) {
            this.cdfspec3 = this.cdf3.getText();
            if (this.MacOS) {
                this.cdfspec3 = this.cdfspec3.replace('/', ':');
                if (this.cdfspec3.startsWith(":")) {
                    this.cdfspec3 = this.cdfspec3.substring(1);
                }
            }
            this.output3.setSelected(true);
        } else if (object == this.cdf4) {
            this.cdfspec4 = this.cdf4.getText();
            if (this.MacOS) {
                this.cdfspec4 = this.cdfspec4.replace('/', ':');
                if (this.cdfspec4.startsWith(":")) {
                    this.cdfspec4 = this.cdfspec4.substring(1);
                }
            }
            this.output4.setSelected(true);
        } else if (object == this.menuOptionsGeneral) {
            if (this.aGeneral == null) {
                this.aGeneral = ExportGeneralOptions.createGeneralOptions(this, this.cdfexport, true);
            }
            this.aGeneral.displayGeneralOptions();
        } else if (object == this.menuOptionsToCDFv3) {
            if (this.aToCDF == null) {
                this.aToCDF = ExportToCDFOptions.createToCDFOptions(this, this.cdfexport, true);
            }
            this.aToCDF.displayToCDFOptions();
        } else if (object == this.menuOptionsToCDFv2) {
            if (this.aToCDF == null) {
                this.aToCDF = ExportToCDFOptions.createToCDFOptions(this, this.cdfexport, true);
            }
            this.aToCDF.displayToCDFOptions();
        } else if (object == this.menuOptionsFilter) {
            if (this.aFilter == null) {
                this.aFilter = ExportFilterOptions.createFilterOptions(this, this.cdfexport, true);
            }
            this.aFilter.displayFilterOptions();
        } else if (object == this.menuEditCopy) {
            if (this.istart == -1) {
                this.info.setText("Where to copy from?");
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.focused.setSelectionStart(this.istart);
                this.focused.setSelectionEnd(this.iend);
                this.focused.copy();
            }
        } else if (object == this.menuEditCut) {
            if (this.istart == -1) {
                this.info.setText("What to cut?");
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.focused.setSelectionStart(this.istart);
                this.focused.setSelectionEnd(this.iend);
                this.focused.cut();
            }
        } else if (object == this.menuEditPaste) {
            if (this.focused == null) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                if (this.istart != -1) {
                    this.focused.setSelectionStart(this.istart);
                    this.focused.setSelectionEnd(this.iend);
                }
                try {
                    String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor);
                    if (string == null) {
                        this.info.setText("No current selection on clipboard");
                        Toolkit.getDefaultToolkit().beep();
                    } else if (string.indexOf("\n") != -1) {
                        this.info.setText("Multiple lines selection on clipboard - not allowed:");
                        this.info.append("\n\n");
                        this.info.append(string);
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        this.focused.paste();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    boolean getCDF() {
        if (this.oldspec1 == null) {
            try {
                this.sourceCDF = CDF.open((String)this.cdfspec1, (long)-1);
                this.vars = this.sourceCDF.getVariables();
                if (this.majority == 0L) {
                    this.majority = this.sourceCDF.getMajority();
                }
                if (this.checksum == (long)-1) {
                    this.checksum = this.sourceCDF.getChecksum();
                }
                this.oldspec1 = this.cdfspec1;
                this.oldSel = this.outSelection;
                return true;
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                this.info.setText(cDFException.toString());
                return false;
            }
        }
        if (!this.oldspec1.equals(this.cdfspec1)) {
            try {
                if (this.sourceCDF != null) {
                    try {
                        this.sourceCDF.close();
                    }
                    catch (CDFException cDFException) {
                        this.info.setText("Error! closing " + cDFException.toString());
                        Toolkit.getDefaultToolkit().beep();
                        return false;
                    }
                    this.sourceCDF = null;
                }
                this.sourceCDF = CDF.open((String)this.cdfspec1, (long)-1);
                this.vars = this.sourceCDF.getVariables();
                if (this.majority == 0L) {
                    this.majority = this.sourceCDF.getMajority();
                }
                if (this.checksum == (long)-1) {
                    this.checksum = this.sourceCDF.getChecksum();
                }
                this.oldspec1 = this.cdfspec1;
                this.oldSel = this.outSelection;
                this.changedCDF = true;
                return true;
            }
            catch (CDFException cDFException) {
                Toolkit.getDefaultToolkit().beep();
                this.info.setText(cDFException.toString());
                return false;
            }
        }
        this.changedCDF = false;
        return true;
    }

    void reset() {
        this.filtering = 0;
        this.validMin = 0;
        this.validMax = 0;
        this.fillVal = 0;
        this.ROWS = 26;
        this.COLUMNS = 9;
        this.majority = 0L;
        this.encoding = 0L;
        this.epoch = 0;
        this.format = 1L;
        this.compressionType = -1;
        this.compressionLevel = 0;
        this.overwrite = 0;
        this.trans0 = 0;
        this.recordNum = 1;
        this.indiceNum = 1;
        this.headings = 1;
        this.orientation = 0;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focused = (JTextField)focusEvent.getSource();
        if (this.prevfocused != null) {
            this.prevfocused.setText(this.prevfocused.getText());
            if (this.iend != -1) {
                if (this.iend < this.focused.getText().length()) {
                    this.prevfocused.setCaretPosition(this.iend);
                } else {
                    this.focused.setCaretPosition(this.focused.getText().length());
                }
            }
        }
        if (this.focused == this.cdf2) {
            this.cdf3.setText("");
            this.cdf4.setText("");
            this.output2.setSelected(true);
        } else if (this.focused == this.cdf3) {
            this.cdf2.setText("");
            this.cdf4.setText("");
            this.output3.setSelected(true);
        } else {
            this.cdf2.setText("");
            this.cdf3.setText("");
            this.output4.setSelected(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.istart != -1) {
            this.focused.setSelectionStart(this.istart);
            this.focused.setSelectionEnd(this.iend);
            this.prevfocused = this.focused;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.focused != null) {
            String string = this.focused.getSelectedText();
            if (string != null) {
                this.istart = this.focused.getSelectionStart();
                this.iend = this.focused.getSelectionEnd();
            } else {
                this.istart = -1;
                this.iend = -1;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.abc && this.abc.isSelected()) {
            try {
                this.info.setText("CDF library distribution: " + CDF.getLibraryVersion());
            }
            catch (CDFException cDFException) {
                System.err.println("error: " + (Object)((Object)cDFException));
            }
            this.abc.setSelected(false);
        }
    }

    private final void makeJButton(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Container container, Object object, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        Component component = object instanceof String ? new JButton((String)object) : (Component)object;
        container.add(component);
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    public int getFiltering() {
        return this.filtering;
    }

    public int getValidMin() {
        return this.validMin;
    }

    public int getValidMax() {
        return this.validMax;
    }

    public int getFillVal() {
        return this.fillVal;
    }

    public boolean getFilterChanged() {
        return this.filterChanged;
    }

    public void setFiltering(int n) {
        this.filtering = n;
    }

    public void setValidMin(int n) {
        this.validMin = n;
    }

    public void setValidMax(int n) {
        this.validMax = this.validMax;
    }

    public void setFillVal(int n) {
        this.fillVal = n;
    }

    public void setFilterChanged(boolean bl) {
        this.filterChanged = bl;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {}
        CDFExport cDFExport = new CDFExport();
        cDFExport.frommain = 1;
        String string = System.getProperty("os.version");
        String string2 = System.getProperty("java.version");
        if (osName.toLowerCase().indexOf("windows") != -1 && string.compareTo("5.0") >= 0 && string2.compareTo("1.4") >= 0) {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec("cmd /c assoc .cdf");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 8192);
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Error with assoc... 1 " + interruptedException);
                }
                cDFExport.channelFile = bufferedReader.readLine();
                if (cDFExport.channelFile != null && cDFExport.channelFile.toLowerCase().equals(".cdf=channelfile")) {
                    process = runtime.exec("cmd /c assoc .cdf=");
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 8192);
                    String string3 = bufferedReader.readLine();
                    try {
                        process.waitFor();
                        runtime.addShutdownHook(new RestoreChannelDefinition(cDFExport.channelFile));
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("Error with assoc... 2 " + interruptedException);
                    }
                }
            }
            catch (IOException iOException) {}
        }
        cDFExport.run();
    }

    private final /* synthetic */ void this() {
        this.sourceCDF = null;
        this.aGeneral = null;
        this.aToCDF = null;
        this.aFilter = null;
        this.aCDFTable = null;
        this.filterChanged = false;
        this.MacOS = false;
        this.WindowsOS = false;
        this.oldspec1 = null;
        this.oldSel = -1;
        this.currentdir = System.getProperty("user.dir");
        this.cdfs = new String[]{"cdf", "CDF"};
        this.cdffilter = new SimpleFileFilter(this.cdfs, " CDF files (*.cdf, *.CDF)");
        this.focused = null;
        this.prevfocused = null;
        this.filtering = 0;
        this.validMin = 0;
        this.validMax = 0;
        this.fillVal = 0;
        this.ROWS = 26;
        this.COLUMNS = 9;
        this.majority = 0L;
        this.encoding = 0L;
        this.epoch = 0;
        this.format = 1L;
        this.compressionType = -1;
        this.compressionLevel = 0;
        this.checksum = -1;
        this.overwrite = 0;
        this.trans0 = 0;
        this.recordNum = 1;
        this.indiceNum = 1;
        this.headings = 1;
        this.orientation = 0;
        this.outSelection = -1;
        this.changedCDF = false;
        this.istart = -1;
        this.iend = -1;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.hpad5 = new Dimension(5, 1);
        this.hpad10 = new Dimension(10, 1);
        this.hpad20 = new Dimension(20, 1);
        this.hpad25 = new Dimension(25, 1);
        this.hpad30 = new Dimension(30, 1);
        this.hpad40 = new Dimension(40, 1);
        this.hpad80 = new Dimension(80, 1);
        this.vpad5 = new Dimension(1, 5);
        this.vpad10 = new Dimension(1, 10);
        this.vpad20 = new Dimension(1, 20);
        this.vpad25 = new Dimension(1, 25);
        this.vpad30 = new Dimension(1, 30);
        this.vpad40 = new Dimension(1, 40);
        this.vpad80 = new Dimension(1, 80);
        this.defaultFont = new Font("Dialog", 0, 12);
        this.boldFont = new Font("Dialog", 1, 12);
        this.bigFont = new Font("Dialog", 0, 18);
        this.bigboldFont = new Font("Dialog", 1, 18);
        this.frommain = 0;
    }

    CDFExport() {
        this(null, defaultModal);
    }

    CDFExport(JFrame jFrame) {
        this(jFrame, defaultModal);
    }

    CDFExport(JFrame jFrame, boolean bl) {
        this.this();
        this.cdfexport = this;
        this.dialog = new JDialog((Frame)this, bl);
        this.parentDriver = jFrame;
        this.modal = bl;
        if (osName.indexOf("Mac OS") != -1 && osName.indexOf("Mac OS X") == -1) {
            this.MacOS = true;
        }
        if (osName.indexOf("Windows") != -1) {
            this.WindowsOS = true;
        }
        try {
            this.backwardEnvVar = CDF.getFileBackwardEnvVar();
        }
        catch (Exception exception) {
            System.out.println("Error getting Env Var..." + exception);
        }
        RepaintManager.currentManager(null).setDoubleBufferingEnabled(true);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class OutputListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = new Integer(actionEvent.getActionCommand());
            CDFExport.this.info.setText("");
            if (n == 1) {
                CDFExport.this.cdf2.setText("");
                CDFExport.this.cdf3.setText("");
                CDFExport.this.cdf4.setText("");
            } else if (n == 2) {
                CDFExport.this.cdf3.setText("");
                CDFExport.this.cdf4.setText("");
            } else if (n == 3) {
                CDFExport.this.cdf2.setText("");
                CDFExport.this.cdf4.setText("");
            } else {
                CDFExport.this.cdf2.setText("");
                CDFExport.this.cdf3.setText("");
            }
        }

        private OutputListener() {
        }
    }

    private static class RestoreChannelDefinition
    extends Thread {
        String channelDefinition;

        public void run() {
            try {
                Process process = Runtime.getRuntime().exec("cmd /c assoc " + this.channelDefinition);
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Error with assoc... 3 " + interruptedException);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error running assoc on Windows...(3): " + iOException);
            }
        }

        RestoreChannelDefinition(String string) {
            this.channelDefinition = string;
        }
    }
}

