//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.171
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;
import java.util.*;
import lti.java.jcf.RuntimeConstants;       

/** A vector of JcfMember objects.  */
public class JcfMemberCollection extends Vector implements RuntimeConstants
{
  protected JcfConstantPool constPool;
    public final JcfConstantPool getConstPool() { return constPool; }

  public JcfMemberCollection (JcfClassInput ist, JcfConstantPool p)
    throws ClassFormatError, IOException
  {
    constPool = p;
    short max = ist.readShort();
    elementData = new Object[max];
    capacityIncrement = 4;
    elementCount = 0;
    for (int i = 0; i < max; i++)
      { addElement(new JcfMember(ist, p)); }
  }
  
  public final JcfMember memberAt(int index)
    { return (JcfMember)(elementAt(index)); }

  /** Invokes each JcfMember object to write itself. */
  public void write (JcfClassOutput ost) throws IOException
  {
    ost.writeShort((short) size());
    for (int i = 0; i < capacity(); i++)
      { memberAt(i).write(ost); }
  }
}
