//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.171
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;

/** JcfClassInput extends the basic data input functionality in DataInput, 
 *  while adding methods to facilitate reading class file specific data types. 
 */
public interface JcfClassInput extends DataInput
{
  /** Read the index of a constant pool entry.
   * @returns The index of the entry. */
  short readCPRef() throws IOException;

  /** Read a short value (usually bit flags) that is not a magnitude. */
  short readShortVerbatim() throws IOException;

  /** Read a short value, where the maximum value that short can have
   * is less than or equal to maxValue. */
  short readShortMax (int maxValue) throws IOException;

  /** Read an int value (usually bit flags) that is not a magnitude. */
  int readIntVerbatim() throws IOException;
}
