/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sun.net.ftp.FtpClient;

/**
 * A wrapper of the sun.net.ftp.FtpClient class. This
 * class provides convenience methods for ftp.
 * 
 * @author  Chr. Clemens Lee
 * @version $Id: FTPUtil.java,v 1.4 2002/10/06 16:42:03 clemens Exp clemens $
 */
public class FTPUtil implements Exitable 
{
    static final private String S_RCS_HEADER = "$Header: /home/clemens/src/java/ccl/src/ccl/util/RCS/FTPUtil.java,v 1.4 2002/10/06 16:42:03 clemens Exp clemens $";

    static final private String S_INI_FILE_CONTENT = 
        "[Init]\n"
        + "Author=Chr. Clemens Lee\n"
        + "\n"
        + "[Help]\n"
        + "HelpUsage=\n"
        + "Options=get,put,host,user,password\n"
        + "get=s,o,Get file from host in bin mode.\n"
        + "put=s,o,Put file to host in bin mode.\n"
        + "host=s,m,The ftp server hostname.\n"
        + "user=s,o,The ftp user name. 'ftp' by default.\n"
        + "password=s,o,The ftp password for the user.\n";

    /**
     * This is an utility class which does not need an instance.
     */
    private FTPUtil() 
    {
        super();
    }

    private boolean _bExit = false;

    /**
     * Implementation of Exitable interface.
     */
    public void setExit() 
    {
        _bExit = true;
    }

    /**
     * This method provides a service similar to url_get or wget.
     */
    static public void main(String[] args_) 
    {
        FTPUtil ftp = new FTPUtil();
        Init init = new Init( ftp, args_, S_RCS_HEADER, S_INI_FILE_CONTENT );
        if ( ftp._bExit ) 
        {
            System.exit( 0 );
        }

        String host = (String) init.getOptions().get( "host" );

        String user = (String) init.getOptions().get( "user" );
        if ( Util.isEmpty( user ) )
        {
            user = "ftp";
        }

        String password = (String) init.getOptions().get( "password" );
        if ( password == null ) 
        {
            password = "";      
        }

        String hostfile = (String) init.getOptions().get( "get" );
        boolean bGet = true;
        if ( Util.isEmpty( hostfile ) ) 
        {
            bGet = false;
            hostfile = (String) init.getOptions().get( "put" );
        }
        if ( Util.isEmpty( hostfile ) ) 
        {
            Util.printlnErr( "Error: no file was specified neither for 'get' "
                             + "or 'put' mode." );

            System.exit( 1 );
        }

        String localfile = new File( hostfile ).getName();

        try
        {
            if ( bGet ) 
            {
                get( host, user, password, hostfile, localfile );
            }
            else
            {
                put( host, user, password, localfile, hostfile );
            }
        } 
        catch( IOException ioException ) 
        {
            Util.printlnErr( ioException );

            System.exit( 1 );
        }

        System.exit( 0 );
    }

    /**
     * Download a file in binary mode.
     *
     * @throws   IOException   if file transfer fails.
     */
    static public void get( String host
                            , String user
                            , String password
                            , String hostfile
                            , String localfile ) 
        throws IOException
    {
        if ( FileUtil.exists( localfile ) ) 
        {
            throw new IOException( "Error: there exists already a file '" 
                                   + localfile 
                                   + "'" );
        }
        FtpClient ftpClient = new FtpClient( host );
        ftpClient.login( user, password );
        ftpClient.binary();
        InputStream input = ftpClient.get( hostfile );
        int i = 0;
        FileOutputStream output = new FileOutputStream( localfile );
        while ( (i = input.read()) != -1 ) 
        {
            output.write( (byte) i );
        }
        ftpClient.closeServer();
        output.close();
    }

    /**
     * Upload a file in binary mode.
     *
     * @throws   IOException   if file transfer fails.
     */
    static public void put( String host
                            , String user
                            , String password
                            , String localfile
                            , String hostfile ) 
        throws IOException
    {
        FtpClient ftpClient = new FtpClient( host );
        ftpClient.login( user, password );
        ftpClient.binary();
        OutputStream output = ftpClient.put( hostfile );//+ ".transferring" );

        FileInputStream input = new FileInputStream( localfile );
        
        int i = 0;
        while( (i = input.read()) != -1 ) 
        {
            output.write( (byte) i );
        }
        output.close();
        input.close();

        //ftpClient.rename( hostfile + ".transferring", hostfile );

        ftpClient.closeServer();
    }
}
