/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.SwingUtil;
import ccl.util.Direction;
import ccl.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public class MessageBox extends ExitJDialog 
                        implements ActionListener
{
    private JButton _btnOK = null;
    private FocusManager _fmOriginal = null;

    private static Font _pFont = new Font( "Dialog", Font.BOLD, 12 );

    private static Font getLabelFont() 
{
        return _pFont;
    }

    public MessageBox(String sMessages_) 
{
        this(sMessages_, true);
    }

    public MessageBox(String sMessages_, boolean bModal_) 
{
        this(new Frame(), sMessages_, bModal_);
    }

    public MessageBox(Frame frmParent_, String sMessages_) 
{
        this(frmParent_, sMessages_, true, Direction.CENTER);
    }

    public MessageBox(Frame frmParent_, String sMessages_, boolean bModal_) 
{
        this(frmParent_, sMessages_, bModal_, Direction.CENTER);
    }

    public MessageBox(Frame frmParent_, String sMessages_,
                      boolean bModal_, Direction dtnAlign_) 
    {
        super(frmParent_, "Message", bModal_);

        Util.panicIf(sMessages_ == null);

        int align = SwingConstants.LEFT;
        if ( dtnAlign_ == Direction.CENTER ) 
{
            align = SwingConstants.CENTER;
        }
        if (dtnAlign_ == Direction.WEST) 
{
            align = SwingConstants.LEFT;
        }
        if (dtnAlign_ == Direction.EAST) 
{
            align = SwingConstants.RIGHT;
        }

        Vector vMessages = Util.stringToLines(sMessages_);

        AutoGridBagLayout pAutoGridBagLayout = new AutoGridBagLayout();
        pAutoGridBagLayout.setInsets( 7 );

        getContentPane().setLayout(pAutoGridBagLayout);
        ((JPanel)getContentPane()).setBorder
               ( BorderFactory.createEmptyBorder( 20, 10, 10, 10 ) );
        pAutoGridBagLayout.setExpandHorizontal();

        // Dummy Zeile
        getContentPane().add(new JLabel(" "));
        pAutoGridBagLayout.endLine();

        // Texte
        int maxLength = 0;
        for(Enumeration e = vMessages.elements(); e.hasMoreElements(); ) 
{
            // Dummy Spalte

            // Message
            String sLine = (String)e.nextElement();
            JLabel lblLine = new JLabel(sLine, align);
            lblLine.setFont( getLabelFont() );
            getContentPane().add(lblLine);
            if (lblLine.getSize().width > maxLength) 
{
                maxLength = lblLine.getSize().width;
            }
            pAutoGridBagLayout.endLine();
            
            // Dummy Spalte
        }

        // Dummy Zeile
        getContentPane().add(new JLabel(" "));
        pAutoGridBagLayout.endLine();

        pAutoGridBagLayout.setExpandNone();

        // OK Button
        _btnOK = new JButton("OK");
        _btnOK.setPreferredSize
               ( new Dimension( 75, _btnOK.getPreferredSize().height ) );
        _btnOK.addActionListener(this);
        _btnOK.setFont(new Font("Dialog", Font.BOLD,12));
        getContentPane().add(_btnOK);
        pAutoGridBagLayout.endLine();

        // Dummy Zeile
        getContentPane().add(new JLabel(" "));
        pAutoGridBagLayout.endLine();

        Dimension dimSize = getSize();
        dimSize.height = (vMessages.size() + 2 + 2) * 23 +
               getInsets().top + getInsets().bottom;
        dimSize.width = maxLength + 80;
        int buttonWidth = _btnOK.getMinimumSize().width + 40;
        if (dimSize.width < buttonWidth) 
{
            dimSize.width = buttonWidth;
        }
        Util.debug("MessageBox: <init> dimSize: " + dimSize);
        Dimension dimMax = SwingUtil.getScreenSize();
        /*Util.panicIf(dimSize.width > dimMax.width, "OKCancelDialog: Message passt nicht auf Screen.");
          setSize(dimSize);*/
        setSize( getPreferredSize().width + 20, 
                 getPreferredSize().height );
        SwingUtil.centerComponent(this);

        // default button and focus stuff
        getRootPane().setDefaultButton( _btnOK );
        _fmOriginal = FocusManager.getCurrentManager();
        FocusManager.setCurrentManager( new LocalFocusManager() );

        addWindowListener( new WindowAdapter() {
            public void windowOpened( WindowEvent pWindowEvent_ ) 
{
                _btnOK.requestFocus();
            }
        } );
    }

    public void setVisible( boolean bVisible_ ) 
{
        if ( bVisible_ == false ) 
{
            FocusManager.setCurrentManager( _fmOriginal );
        }

        super.setVisible( bVisible_ );
    }

    public void actionPerformed(ActionEvent pActionEvent_) 
{
        Object oSource = pActionEvent_.getSource();
        if (oSource instanceof JButton) 
{
            setVisible(false);
            if (!isModal()) 
{
                dispose();
            }
        }
    }

    public class LocalFocusManager extends DefaultFocusManager 
{
        public LocalFocusManager() 
{
            super();
        }
        
        public void processKeyEvent( Component cmpFocused_,
                                     KeyEvent pKeyEvent_ )
        {
            if ( pKeyEvent_.getKeyCode() == KeyEvent.VK_ESCAPE ) 
{
                exit();
                
                return;
            }
        }
    }
}









