/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.servlet;

import ccl.util.FileUtil;
import ccl.util.Util;
import http.utils.multipartrequest.MultipartRequest;
import http.utils.multipartrequest.ServletMultipartRequest;
import java.io.IOException;
import java.sql.Connection;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * This servlet reads in an xml file that has been created
 * with an XMLExporter class. 
 * To make use of this class
 * inherit from this one and implement the 'getConnection'
 * and 'getTitle()' methods.
 *
 * @author    Chr. Clemens Lee (clemens@kclee.com)
 * @version   $Id: XMLImporter.java,v 1.8 2003/11/23 09:13:49 clemens Exp clemens $
 */
abstract public class XMLImporter extends HttpServlet 
{
    public void doGet(HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException
    {
        HTML html = new HTML( response );
        html.printTitle( getTitle() );

        html.println( "<form method=\"post\" enctype=\"multipart/form-data\" action=\""
                      + this.getClass().getName()
                      + "\">" );
        html.println( "Specify name of xml file to import:" );
        html.println( "<input type=\"file\" name=\"xmlfile\"><p>" );
        html.println( "<input type=\"submit\" name=\"Submit\">" );
        html.println( "</form>" );
        
        html.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response)
        throws IOException
               , ServletException
    {
		HTML html = new HTML( response );

		String sXMLFile = getXMLFile(request);

		processXML(html, sXMLFile);

        html.close();
    }

	public void processXML(HTML html, String sXMLFile) {
		try
		{
			html.printTitle( getTitle() );
		
			Connection connection = getConnection();
		    //connection.setAutoCommit( false );
		    XMLImportHandler.parse( connection
		                            , sXMLFile );
		    //connection.commit();
			connection.close();
		}
		catch( Exception exception )
		{
		    Util.printlnErr( exception );
		    html.println( "<pre>" + exception.getMessage() + "\n" + Util.getStackTrace( exception ) + "</pre>" );
		}
		
		html.println( "XML file was received successfully." );
	}

	private String getXMLFile(HttpServletRequest request) throws IOException {
		String sTempDir = FileUtil.getTempDir();
		MultipartRequest multirequest = new ServletMultipartRequest
		       ( request
		         , sTempDir
                         , 256 * 1024 * 1024 );
		String sXMLFile = multirequest.getFile( "xmlfile" ).getPath();
		Util.debug( this, "getXMLFile(..).file: " + sXMLFile );
        
		return sXMLFile;
	}

    /**
     * Creates a connection object in the class which uses
     * this class.
     */
    abstract public Connection getConnection();

    /**
     * Returns the title used for the html page.
     */
    abstract public String     getTitle     ();
}
