/*
 * Decompiled with CFR 0.152.
 */
package ccl.util;

import ccl.util.FileUtil;
import ccl.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ReflectionClassLoader
extends ClassLoader {
    private String _sClasspath = System.getProperty("java.class.path");
    private Hashtable _htLoadedClasses = new Hashtable();
    private Hashtable _htResolvedClasses = new Hashtable();

    public String getAbsoluteClassFileName(String sFullClassName_) {
        String sRelativeClassName = sFullClassName_.replace('.', File.separatorChar) + ".class";
        Util.debug("ReflectionClassLoader.getAbsoluteClassFileName(..).sRelativeClassName: " + sRelativeClassName);
        Util.debug("ReflectionClassLoader.getAbsoluteClassFileName(..)._sClasspath: " + this._sClasspath);
        int pos = 0;
        int lastpos = 0;
        while (lastpos != -1) {
            String sCurrentDir;
            pos = this._sClasspath.indexOf(File.pathSeparatorChar, lastpos);
            if (pos == -1) {
                sCurrentDir = this._sClasspath.substring(lastpos);
                lastpos = -1;
            } else {
                sCurrentDir = this._sClasspath.substring(lastpos, pos);
                lastpos = pos + 1;
                if (lastpos >= this._sClasspath.length()) {
                    lastpos = -1;
                }
            }
            Util.debug("ReflectionClassLoader.getAbsoluteClassFileName(..).sCurrentDir: " + sCurrentDir);
            String sTestFile = FileUtil.concatPath(sCurrentDir, sRelativeClassName);
            Util.debug("ReflectionClassLoader.getAbsoluteClassFileName(..).sTestFile: " + sTestFile);
            if (!FileUtil.existsFile(sTestFile)) continue;
            return sTestFile;
        }
        return null;
    }

    public byte[] loadClassFile(String sAbsoluteClassFileName_) throws IOException {
        FileInputStream pFileInputStream = new FileInputStream(sAbsoluteClassFileName_);
        byte[] abtClass = new byte[pFileInputStream.available()];
        pFileInputStream.read(abtClass);
        return abtClass;
    }

    public byte[] loadClassFile(ZipFile zipOpen_, ZipEntry pZipEntry_) throws IOException, ZipException {
        Util.debug("ReflectionClassLoader.loadClassFile(..).zipOpen_: " + zipOpen_);
        Util.debug("ReflectionClassLoader.loadClassFile(..).pZipEntry_: " + pZipEntry_);
        Util.debug("ReflectionClassLoader.loadClassFile(..).pZipEntry_.getMethod(): " + pZipEntry_.getMethod());
        int compressedSize = (int)pZipEntry_.getCompressedSize();
        int uncompressedSize = (int)pZipEntry_.getSize();
        if (uncompressedSize == -1) {
            throw new ZipException();
        }
        byte[] abtClass = new byte[uncompressedSize];
        Util.debug("ReflectionClassLoader.loadClassFile(..).abtClass.length: " + abtClass.length);
        InputStream pInputStream = zipOpen_.getInputStream(pZipEntry_);
        Util.debug("ReflectionClassLoader.loadClassFile(..).pInputStream: " + pInputStream);
        int bytesRead = 0;
        while (bytesRead < uncompressedSize) {
            bytesRead += pInputStream.read(abtClass, bytesRead, uncompressedSize - bytesRead);
            Util.debug("ReflectionClassLoader.loadClassFile(..).bytesRead: " + bytesRead);
        }
        return abtClass;
    }

    public byte[] getClassFromJavaArchives(String sFullClassName_) throws IOException, ZipException {
        String sClassFileName = sFullClassName_.replace('.', '/') + ".class";
        Vector vClasspathElements = Util.stringToLines(this._sClasspath, File.pathSeparatorChar);
        Enumeration eElements = vClasspathElements.elements();
        while (eElements.hasMoreElements()) {
            String sNextArchiv = (String)eElements.nextElement();
            Util.debug("ReflectionClassLoader.getClassFromJavaArchives(..).sNextArchiv: " + sNextArchiv);
            if (!Util.endsWith(sNextArchiv, ".zip") && !Util.endsWith(sNextArchiv, ".jar") || !FileUtil.existsFile(sNextArchiv)) continue;
            try {
                ZipFile pZipFile = new ZipFile(sNextArchiv);
                ZipEntry pZipEntry = pZipFile.getEntry(sClassFileName);
                if (pZipEntry != null) {
                    byte[] abtClass = this.loadClassFile(pZipFile, pZipEntry);
                    pZipFile.close();
                    return abtClass;
                }
                pZipFile.close();
            }
            catch (Exception pException) {
                // empty catch block
            }
        }
        return null;
    }

    public byte[] getClassFile(String sFullClassName_) throws IOException, ClassNotFoundException, ZipException {
        String sAbsoluteClassFileName = this.getAbsoluteClassFileName(sFullClassName_);
        Util.debug("ReflectionClassLoader.getClassFile(..).sAbsoluteClassFileName: " + sAbsoluteClassFileName);
        if (sAbsoluteClassFileName != null) {
            return this.loadClassFile(sAbsoluteClassFileName);
        }
        byte[] abtClass = this.getClassFromJavaArchives(sFullClassName_);
        if (abtClass == null) {
            throw new ClassNotFoundException();
        }
        return abtClass;
    }

    protected Class loadClass(String sClassName_, boolean bResolve_) throws ClassNotFoundException {
        Util.debug("ReflectionClassLoader.loadClass(..).sClassName_: " + sClassName_);
        Util.debug("ReflectionClassLoader.loadClass(..).bResolve_: " + bResolve_);
        try {
            if (!this._htLoadedClasses.containsKey(sClassName_)) {
                Class<?> classGot = null;
                if (sClassName_.startsWith("java.") || sClassName_.startsWith("javax.") && !System.getProperty("java.version").startsWith("1.1")) {
                    classGot = this.findSystemClass(sClassName_);
                } else {
                    byte[] abtClass = this.getClassFile(sClassName_);
                    classGot = this.defineClass(sClassName_, abtClass, 0, abtClass.length);
                }
                this._htLoadedClasses.put(sClassName_, classGot);
            }
        }
        catch (ZipException pZipException) {
            Util.debug("ReflectionClassLoader.loadClass(..).pZipException: " + pZipException);
            throw new ClassNotFoundException();
        }
        catch (IOException pIOException) {
            Util.debug("ReflectionClassLoader.loadClass(..).pIOException: " + pIOException);
            throw new ClassNotFoundException();
        }
        catch (Error pError) {
            Util.debug("ReflectionClassLoader.loadClass(..).pError: " + pError);
            throw new ClassNotFoundException();
        }
        return (Class)this._htLoadedClasses.get(sClassName_);
    }

    public ReflectionClassLoader() {
    }

    public ReflectionClassLoader(String sClasspath_) {
        this.setClasspath(sClasspath_);
    }

    public void setClasspath(String sClasspath_) {
        this._sClasspath = new String(sClasspath_);
    }
}

