/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.AboutDialog;
import ccl.swing.CCLBorder;
import ccl.swing.CCLButtonBorder;
import ccl.swing.CCLButtonBorderTableCellRenderer;
import ccl.swing.DoubleListCancelSelector;
import ccl.swing.ExampleFileFilter;
import ccl.swing.InputCancelDialog;
import ccl.swing.ListCancelSelector;
import ccl.swing.MainJFrame;
import ccl.swing.MessageBox;
import ccl.swing.OKCancelDialog;
import ccl.swing.YesNoCancelDialog;
import ccl.util.FileUtil;
import ccl.util.Test;
import ccl.util.Testable;
import ccl.util.Util;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Keymap;
import javax.swing.text.Segment;
import javax.swing.tree.DefaultMutableTreeNode;

public class SwingUtil {
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    private static CCLBorder _pCCLBorder = null;
    private static CCLButtonBorder _pCCLButtonBorder = null;
    private static Frame _frmMain = null;
    private static Object _oTestValue = null;
    static /* synthetic */ Class class$ccl$swing$SwingUtil;

    private static int _yesNoOrCancel(Frame frmParent_, YesNoCancelDialog pYesNoCancelDialog_) {
        pYesNoCancelDialog_.dispose();
        frmParent_.requestFocus();
        if (pYesNoCancelDialog_.isCancel()) {
            return 2;
        }
        if (pYesNoCancelDialog_.isYes()) {
            return 0;
        }
        return 1;
    }

    public static String inputListCancel(Frame frmParent_, String sPrint_, Vector vsItems_) {
        if (Test.isTest()) {
            return (String)Test.getValue();
        }
        ListCancelSelector dlgInput = new ListCancelSelector(frmParent_, sPrint_, vsItems_);
        dlgInput.show();
        String sRetVal = dlgInput.getValue();
        dlgInput.dispose();
        return sRetVal;
    }

    public static Vector inputDoubleListCancel(Frame frmParent_, String sPrint_, Vector vsFirst_, Vector vsSecond_, boolean bMultiSelect_) {
        Vector vRetVal = null;
        try {
            DoubleListCancelSelector dlgInput = new DoubleListCancelSelector(frmParent_, sPrint_, vsFirst_, vsSecond_, bMultiSelect_);
            dlgInput.show();
            if (dlgInput.isOK()) {
                vRetVal = dlgInput.getValues();
            }
            dlgInput.dispose();
        }
        catch (Exception pException) {
            Util.println("SwingUtil.inputDoubleListCancel(..).pException: " + pException);
            pException.printStackTrace();
        }
        Util.debug("SwingUtil.inputDoubleListCancel(..).END");
        return vRetVal;
    }

    public static Vector inputDoubleListCancel(Frame frmParent_, String sPrint_, Vector vsFirst_, Vector vsSecond_, boolean bMultiSelect_, Color clrListBackground_, Color clrListForeground_) {
        Vector vRetVal = null;
        try {
            DoubleListCancelSelector dlgInput = new DoubleListCancelSelector(frmParent_, sPrint_, vsFirst_, vsSecond_, bMultiSelect_);
            dlgInput.setListBackground(clrListBackground_);
            dlgInput.setListForeground(clrListForeground_);
            dlgInput.show();
            vRetVal = dlgInput.getValues();
            dlgInput.dispose();
        }
        catch (Exception pException) {
            Util.println("SwingUtil.inputDoubleListCancel(..).pException: " + pException);
            pException.printStackTrace();
        }
        Util.debug("SwingUtil.inputDoubleListCancel(..).END");
        return vRetVal;
    }

    public static Image getResourcesImage(String sResourceImageName_) throws MissingResourceException {
        ImageIcon pImageIcon = new ImageIcon((class$ccl$swing$SwingUtil == null ? (class$ccl$swing$SwingUtil = SwingUtil.class$("ccl.swing.SwingUtil")) : class$ccl$swing$SwingUtil).getResource(sResourceImageName_));
        return pImageIcon.getImage();
    }

    public static void showMessage(Frame frmParent_, String sMessages_) {
        MessageBox dlgMessage = new MessageBox(frmParent_, sMessages_);
        _oTestValue = dlgMessage;
        dlgMessage.show();
        frmParent_.requestFocus();
    }

    public static void setInitialFocus(Window pWindow_, final Component pComponent_) {
        pWindow_.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent pWindowEvent_) {
                pComponent_.requestFocus();
            }
        });
    }

    public static String getFileName(Frame frmParent_, String sTitle_, String[] asFileSuffixes_, String sDirectory_) {
        JFileChooser pFileChooser = new JFileChooser(sDirectory_);
        pFileChooser.setDialogTitle(sTitle_);
        Util.panicIf(asFileSuffixes_ == null || asFileSuffixes_.length < 1);
        ExampleFileFilter pExampleFileFilter = new ExampleFileFilter(asFileSuffixes_, "");
        pFileChooser.addChoosableFileFilter(pExampleFileFilter);
        pFileChooser.setFileFilter(pExampleFileFilter);
        pFileChooser.setFileSelectionMode(0);
        int retVal = pFileChooser.showDialog(frmParent_, null);
        if (retVal != 0) {
            return null;
        }
        String sRetVal = pFileChooser.getSelectedFile().getAbsolutePath();
        return sRetVal;
    }

    public static String getFileName(Frame frmParent_, String sTitle_, String sFileName_, String sDirectory_) {
        JFileChooser pFileChooser = new JFileChooser(sDirectory_);
        pFileChooser.setDialogTitle(sTitle_);
        Util.panicIf(sFileName_.indexOf(46) == -1);
        String sFileExtension = sFileName_.substring(sFileName_.lastIndexOf(46) + 1);
        ExampleFileFilter pExampleFileFilter = new ExampleFileFilter(new String[]{sFileExtension}, "");
        pFileChooser.addChoosableFileFilter(pExampleFileFilter);
        pFileChooser.setFileFilter(pExampleFileFilter);
        pFileChooser.setFileSelectionMode(0);
        int retVal = pFileChooser.showDialog(frmParent_, null);
        if (retVal != 0) {
            return null;
        }
        String sRetVal = pFileChooser.getSelectedFile().getAbsolutePath();
        return sRetVal;
    }

    public static String getFileName(Frame frmParent_, String sTitle_, String sFileName_, String sDirectory_, String sOKButtonText_) {
        JFileChooser pFileChooser = new JFileChooser(sDirectory_);
        pFileChooser.setDialogTitle(sTitle_);
        pFileChooser.setApproveButtonText(sOKButtonText_);
        Util.panicIf(sFileName_.indexOf(46) == -1, "sFileName_ was empty in method ccl.swing.Util.getFileName(..).");
        String sFileExtension = sFileName_.substring(sFileName_.lastIndexOf(46) + 1);
        ExampleFileFilter pExampleFileFilter = new ExampleFileFilter(new String[]{sFileExtension}, "");
        pFileChooser.addChoosableFileFilter(pExampleFileFilter);
        pFileChooser.setFileFilter(pExampleFileFilter);
        pFileChooser.setFileSelectionMode(0);
        int retVal = pFileChooser.showDialog(frmParent_, null);
        if (retVal != 0) {
            return null;
        }
        String sRetVal = pFileChooser.getSelectedFile().getAbsolutePath();
        return sRetVal;
    }

    public static String getDirName(Frame frmParent_, String sTitle_, String sDirectory_) {
        JFileChooser pFileChooser = new JFileChooser(sDirectory_);
        pFileChooser.setDialogTitle(sTitle_);
        pFileChooser.setFileSelectionMode(1);
        int retVal = pFileChooser.showDialog(frmParent_, null);
        if (retVal != 0) {
            return null;
        }
        String sRetVal = pFileChooser.getSelectedFile().getAbsolutePath();
        return sRetVal;
    }

    public static String getFileOrDirName(Frame frmParent_, String sTitle_, String sDirectory_) {
        JFileChooser pFileChooser = new JFileChooser(sDirectory_);
        pFileChooser.setDialogTitle(sTitle_);
        pFileChooser.setFileSelectionMode(2);
        int retVal = pFileChooser.showDialog(frmParent_, null);
        if (retVal != 0) {
            return null;
        }
        String sRetVal = pFileChooser.getSelectedFile().getAbsolutePath();
        return sRetVal;
    }

    public static String getFileName(Frame frmParent_, String sTitle_, String sStartDirectory_) {
        JFileChooser pFileChooser = new JFileChooser(sStartDirectory_);
        pFileChooser.setDialogTitle(sTitle_);
        pFileChooser.setFileSelectionMode(0);
        int retVal = pFileChooser.showDialog(frmParent_, null);
        if (retVal != 0) {
            return null;
        }
        String sRetVal = pFileChooser.getSelectedFile().getAbsolutePath();
        return sRetVal;
    }

    public static boolean isOKOrCancel(Frame frmParent_, String sMessage_) {
        OKCancelDialog dlgOKCancel = new OKCancelDialog(frmParent_, sMessage_);
        dlgOKCancel.setVisible(true);
        boolean bRetVal = dlgOKCancel.isOK();
        dlgOKCancel.dispose();
        frmParent_.requestFocus();
        return bRetVal;
    }

    public static void unregisterEnterAction(JButton pButton_) {
        KeyStroke enterPressedKeyStroke = KeyStroke.getKeyStroke(10, 0, false);
        KeyStroke enterReleasedKeyStroke = KeyStroke.getKeyStroke(10, 0, true);
        pButton_.unregisterKeyboardAction(enterPressedKeyStroke);
        pButton_.unregisterKeyboardAction(enterReleasedKeyStroke);
    }

    public static void removeEnterBinding(JTextField pTextField_) {
        KeyStroke ksEnter = KeyStroke.getKeyStroke(10, 0);
        Keymap pKeymap = pTextField_.getKeymap();
        pKeymap.removeKeyStrokeBinding(ksEnter);
        KeyStroke ksAltC = KeyStroke.getKeyStroke(67, 4);
        pKeymap.removeKeyStrokeBinding(ksAltC);
    }

    public static CCLBorder createCCLBorder() {
        if (_pCCLBorder == null) {
            _pCCLBorder = new CCLBorder();
        }
        return _pCCLBorder;
    }

    public static CCLButtonBorder createCCLButtonBorder() {
        if (_pCCLButtonBorder == null) {
            _pCCLButtonBorder = new CCLButtonBorder();
        }
        return _pCCLButtonBorder;
    }

    public static void setCCLButtonBorderOnTableHeader(JTable table, Font font) {
        CCLButtonBorderTableCellRenderer renderer = new CCLButtonBorderTableCellRenderer(font);
        TableColumnModel tableModel = table.getColumnModel();
        int index = 0;
        while (index < tableModel.getColumnCount()) {
            tableModel.getColumn(index).setHeaderRenderer(renderer);
            ++index;
        }
    }

    public static void invokeLaterIfNecessary(Runnable pRunnable_) {
        Util.panicIf(pRunnable_ == null);
        if (Thread.currentThread().getName().startsWith("AWT-")) {
            pRunnable_.run();
        } else {
            SwingUtilities.invokeLater(pRunnable_);
        }
    }

    public static void invokeAndWaitIfNecessary(Runnable pRunnable_) throws InterruptedException, InvocationTargetException {
        Util.panicIf(pRunnable_ == null);
        if (EventQueue.isDispatchThread()) {
            pRunnable_.run();
        } else {
            SwingUtilities.invokeAndWait(pRunnable_);
        }
    }

    public static String inputCancel(Frame frmParent_, String sPrint_, String sInit_) {
        if (Test.isTest()) {
            return (String)Test.getValue();
        }
        String sRetVal = null;
        InputCancelDialog dlgInput = new InputCancelDialog(frmParent_, sPrint_, sInit_);
        _oTestValue = dlgInput;
        dlgInput.show();
        if (dlgInput.isOK()) {
            sRetVal = dlgInput.getValue();
        }
        dlgInput.dispose();
        return sRetVal;
    }

    public static String inputCancel(Frame frmParent_, String sPrint_) {
        return SwingUtil.inputCancel(frmParent_, sPrint_, "");
    }

    public static void insertNodeToTree(DefaultMutableTreeNode tnRoot_, DefaultMutableTreeNode tnChild_, String sPath_, char cDelimiter_) {
        Util.panicIf(Util.isEmpty(sPath_));
        Vector vChild = Util.stringToLines(sPath_, cDelimiter_);
        Util.panicIf(vChild == null || vChild.size() < 2);
        String sChild = (String)vChild.elementAt(1);
        int childrenCount = tnRoot_.getChildCount();
        int child = 0;
        while (child < childrenCount) {
            DefaultMutableTreeNode tnNextChild = (DefaultMutableTreeNode)tnRoot_.getChildAt(child);
            if (sChild.equals(tnNextChild.toString())) {
                SwingUtil.insertNodeToTree(tnNextChild, tnChild_, sPath_.substring(sPath_.indexOf(cDelimiter_) + 1), cDelimiter_);
                return;
            }
            if (sChild.compareTo(tnNextChild.toString()) < 0) {
                tnRoot_.insert(tnChild_, child);
                return;
            }
            ++child;
        }
        tnRoot_.insert(tnChild_, childrenCount);
    }

    public static Vector toVector(DefaultListModel pDefaultListModel_) {
        Vector pVector = new Vector();
        Enumeration pEnumeration = pDefaultListModel_.elements();
        while (pEnumeration.hasMoreElements()) {
            pVector.addElement(pEnumeration.nextElement());
        }
        return pVector;
    }

    public static Component getFirstComponent(Container pContainer_, String sName_) {
        return SwingUtil.getComponent(pContainer_, sName_, 0);
    }

    public static String getContainerDump(Container container) {
        return SwingUtil.getContainerDump(container, 0);
    }

    private static String getContainerDump(Container container, int indent) {
        String sRetVal = Util.getSpaces(indent) + container.toString();
        Component[] acmpChildren = container.getComponents();
        int child = 0;
        while (child < acmpChildren.length) {
            sRetVal = acmpChildren[child] instanceof Container ? sRetVal + "\n" + SwingUtil.getContainerDump((Container)acmpChildren[child], indent + 2) : sRetVal + "\n" + Util.getSpaces(indent + 2) + acmpChildren[child].toString();
            ++child;
        }
        return sRetVal;
    }

    public static Component getComponent(Container pContainer_, String sName_, int n_) {
        Util.panicIf(n_ < 0);
        int found = 0;
        Component[] acmpChildren = pContainer_.getComponents();
        if (acmpChildren.length == 0) {
            return null;
        }
        int component = 0;
        while (component < acmpChildren.length) {
            Component cmpRetVal;
            String sNextName = acmpChildren[component].getName();
            Util.debug("SwingUtil.getFirstComponent(..).sNextName: " + sNextName);
            if (sNextName != null && sNextName.equals(sName_)) {
                if (found == n_) {
                    return acmpChildren[component];
                }
                ++found;
            } else {
                sNextName = acmpChildren[component].getClass().getName();
                Util.debug("SwingUtil.getFirstComponent(..).sNextName: " + sNextName);
                if (sNextName != null && sNextName.equals(sName_)) {
                    if (found == n_) {
                        return acmpChildren[component];
                    }
                    ++found;
                } else {
                    sNextName = acmpChildren[component].toString();
                    Util.debug("SwingUtil.getFirstComponent(..).sNextName: " + sNextName);
                    if (sNextName != null && sNextName.startsWith(sName_)) {
                        if (found == n_) {
                            return acmpChildren[component];
                        }
                        ++found;
                    }
                }
            }
            if (acmpChildren[component] instanceof Container && (cmpRetVal = SwingUtil.getComponent((Container)acmpChildren[component], sName_, n_ - found)) != null) {
                return cmpRetVal;
            }
            ++component;
        }
        return null;
    }

    public static Component getComponent(Container pContainer_, Testable pTestable_, int n_) {
        Util.panicIf(pTestable_ == null);
        Util.panicIf(n_ < 0);
        int found = 0;
        Component[] acmpChildren = pContainer_.getComponents();
        if (acmpChildren.length == 0) {
            return null;
        }
        int component = 0;
        while (component < acmpChildren.length) {
            Component cmpRetVal;
            if (pTestable_.test(acmpChildren[component])) {
                if (found == n_) {
                    return acmpChildren[component];
                }
                ++found;
            }
            if (acmpChildren[component] instanceof Container && (cmpRetVal = SwingUtil.getComponent((Container)acmpChildren[component], pTestable_, n_ - found)) != null) {
                return cmpRetVal;
            }
            ++component;
        }
        return null;
    }

    public static void pressOKButton(Window pWindow_) {
        Testable pTestable = new Testable(){

            public boolean test(Object oComponent_) {
                return oComponent_ instanceof JButton && ((JButton)oComponent_).getText().equals("OK");
            }
        };
        final JButton btnOK = (JButton)SwingUtil.getComponent((Container)pWindow_, pTestable, 0);
        if (btnOK != null) {
            SwingUtil.invokeLaterIfNecessary(new Runnable(){

                public void run() {
                    btnOK.doClick();
                }
            });
        }
    }

    public static MenuElement getMenuElement(MenuElement pMenuElement_, String[] asMenuName_) {
        Util.debug("SwingUtil.getMenuElement(..).pMenuElement_: " + pMenuElement_);
        Util.panicIf(pMenuElement_ == null);
        Util.panicIf(asMenuName_ == null);
        Util.panicIf(asMenuName_.length < 1);
        MenuElement[] apMenuElement = pMenuElement_.getSubElements();
        if (apMenuElement.length == 1 && apMenuElement[0] instanceof JPopupMenu) {
            apMenuElement = apMenuElement[0].getSubElements();
        }
        int menu = 0;
        while (menu < apMenuElement.length) {
            MenuElement meChild = apMenuElement[menu];
            Util.debug("SwingUtil.getMenuElement(..).meChild: " + meChild);
            String sName = ((JComponent)((Object)meChild)).getName();
            Util.debug("SwingUtil.getMenuElement(..).name: " + sName);
            if (sName != null && sName.equals(asMenuName_[0])) {
                if (asMenuName_.length == 1) {
                    return apMenuElement[menu];
                }
                String[] asNewMenuName = new String[asMenuName_.length - 1];
                int name = 1;
                while (name < asMenuName_.length) {
                    asNewMenuName[name - 1] = asMenuName_[name];
                    ++name;
                }
                return SwingUtil.getMenuElement(apMenuElement[menu], asNewMenuName);
            }
            ++menu;
        }
        return null;
    }

    public static void dispatchKeyEvent(final Component pComponent_, final char c_) {
        SwingUtil.invokeLaterIfNecessary(new Runnable(){

            public void run() {
                KeyEvent pKeyEvent = new KeyEvent(pComponent_, 400, new Date().getTime(), 0, 0, c_);
                pComponent_.dispatchEvent(pKeyEvent);
            }
        });
    }

    public static void dispatchKeyEvent(final Component pComponent_, final int virtualKey_) {
        SwingUtil.invokeLaterIfNecessary(new Runnable(){

            public void run() {
                KeyEvent pKeyEvent = new KeyEvent(pComponent_, 401, new Date().getTime(), 0, virtualKey_);
                pComponent_.dispatchEvent(pKeyEvent);
                pKeyEvent = new KeyEvent(pComponent_, 402, new Date().getTime(), 0, virtualKey_);
                pComponent_.dispatchEvent(pKeyEvent);
            }
        });
    }

    public static void dispatchEnterKeyEvent(Component pComponent_) {
        SwingUtil.dispatchKeyEvent(pComponent_, 10);
    }

    public static void doClick(final JButton btnClick_) {
        SwingUtil.invokeLaterIfNecessary(new Runnable(){

            public void run() {
                btnClick_.doClick();
            }
        });
    }

    public static int lastIndexOf(Segment pSegment_, int c_) {
        return SwingUtil.lastIndexOf(pSegment_, c_, pSegment_.count - 1);
    }

    public static int lastIndexOf(Segment pSegment_, int c_, int fromIndex_) {
        int min = pSegment_.offset;
        int i = pSegment_.offset + (fromIndex_ >= pSegment_.count ? pSegment_.count - 1 : fromIndex_);
        while (i >= min) {
            if (pSegment_.array[i] == c_) {
                return i - pSegment_.offset;
            }
            --i;
        }
        return -1;
    }

    public static void showAboutDialog(MainJFrame pMainFrame_) {
        AboutDialog dlgAbout = new AboutDialog(pMainFrame_);
        pMainFrame_.requestFocus();
        dlgAbout.dispose();
    }

    public static void setList(JList pList_, Vector vValues_) {
        DefaultListModel dlmList = (DefaultListModel)pList_.getModel();
        pList_.clearSelection();
        dlmList.removeAllElements();
        Enumeration eValues = vValues_.elements();
        while (eValues.hasMoreElements()) {
            dlmList.addElement(eValues.nextElement());
        }
    }

    public static int wannaSave(Frame frmParent_) {
        YesNoCancelDialog pYesNoCancelDialog = new YesNoCancelDialog(frmParent_);
        return SwingUtil._yesNoOrCancel(frmParent_, pYesNoCancelDialog);
    }

    public static Dimension getScreenSize() {
        Toolkit pToolkit = Toolkit.getDefaultToolkit();
        Dimension pDimension = pToolkit.getScreenSize();
        return pDimension;
    }

    public static void maximizeWindow(Window pWindow_) {
        pWindow_.setLocation(0, 0);
        pWindow_.setSize(SwingUtil.getScreenSize());
    }

    public static void maximizeWindow(Window window, float percentage) {
        Dimension dimScreen = SwingUtil.getScreenSize();
        Dimension dimWindow = new Dimension((int)((float)dimScreen.width * percentage), (int)((float)dimScreen.height * percentage));
        Point ptLocation = new Point((dimScreen.width - dimWindow.width) / 2, (dimScreen.height - dimWindow.height) / 2);
        window.setLocation(ptLocation.x, ptLocation.y);
        window.setSize(dimWindow);
    }

    public static void centerComponent(Component cmpObject_, Component cmpParent_, int heightFraction_) {
        Util.panicIf(cmpObject_ == null || cmpParent_ == null || heightFraction_ == 0);
        if (!cmpParent_.isVisible()) {
            SwingUtil.centerComponent(cmpObject_);
            return;
        }
        Dimension dimObject = cmpObject_.getSize();
        Dimension dimParent = cmpParent_.getSize();
        Point ptLocation = cmpParent_.getLocation();
        int posX = (dimParent.width - dimObject.width) / 2;
        int posY = (dimParent.height - dimObject.height) / heightFraction_;
        if (posX < 0 || posY < 0) {
            SwingUtil.centerComponent(cmpObject_);
            return;
        }
        cmpObject_.setLocation(ptLocation.x + posX, ptLocation.y + posY);
    }

    public static void centerComponent(Component cmpObject) {
        int posY;
        Dimension dimObject = cmpObject.getSize();
        Dimension dimScreen = SwingUtil.getScreenSize();
        Util.debug("ccl.swing.SwingUtil.centerComponent(..).dimScreen: " + dimScreen);
        int posX = (dimScreen.width - dimObject.width) / 2;
        if (posX < 0) {
            posX = 0;
        }
        if ((posY = (dimScreen.height - dimObject.height) / 2) < 0) {
            posY = 0;
        }
        Util.debug("ccl.swing.SwingUtil.centerComponent(..).posX: " + posX);
        Util.debug("ccl.swing.SwingUtil.centerComponent(..).posY: " + posY);
        cmpObject.setLocation(posX, posY);
    }

    public static Image loadImage(String sImageFileName_) {
        Util.panicIf(Util.isEmpty(sImageFileName_));
        if (!FileUtil.existsFile(sImageFileName_)) {
            return null;
        }
        Canvas cmpDummy = new Canvas();
        MediaTracker pMediaTracker = new MediaTracker(cmpDummy);
        Toolkit pToolkit = cmpDummy.getToolkit();
        Image imgRetVal = null;
        try {
            imgRetVal = pToolkit.getImage(sImageFileName_);
            pMediaTracker.addImage(imgRetVal, 0);
            pMediaTracker.waitForAll();
        }
        catch (Exception pException) {
            return null;
        }
        if (pMediaTracker.isErrorAny()) {
            imgRetVal = null;
        }
        return imgRetVal;
    }

    public static void setMainFrame(Frame pFrame_) {
        _frmMain = pFrame_;
    }

    public static void getValue(Test pTest_) {
        pTest_.setValue(_oTestValue);
    }

    public static Dimension max(Dimension dimA_, Dimension dimB_) {
        if (dimA_ == null && dimB_ == null) {
            return new Dimension(0, 0);
        }
        if (dimA_ == null) {
            return new Dimension(dimB_);
        }
        if (dimB_ == null) {
            return new Dimension(dimA_);
        }
        Dimension dimRetVal = new Dimension(dimA_);
        dimRetVal.width = Math.max(dimRetVal.width, dimB_.width);
        dimB_.height = Math.max(dimRetVal.height, dimB_.height);
        return dimRetVal;
    }

    public static void setDefaultButton(Component pComponent_, JButton pButton_) {
        JRootPane pRootPane = SwingUtilities.getRootPane(pComponent_);
        pRootPane.setDefaultButton(pButton_);
    }

    public static boolean isFileSavable(Frame frmParent_, String sSaveFile_) {
        boolean bSavable = false;
        if (Util.isEmpty(sSaveFile_)) {
            return bSavable;
        }
        if (FileUtil.existsDir(sSaveFile_)) {
            SwingUtil.showMessage(frmParent_, "File\n\n\"" + sSaveFile_ + "\"\n\nexists already as a directory!\n" + "File saving aborted!");
            return bSavable;
        }
        boolean bl = bSavable = !FileUtil.existsFile(sSaveFile_);
        if (!bSavable) {
            bSavable = SwingUtil.isOKOrCancel(frmParent_, "File\n\n\"" + sSaveFile_ + "\"\n\nexists already.\n" + "Is it OK to overwrite it?");
        }
        return bSavable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

