/*
 * Decompiled with CFR 0.152.
 */
package ccl.servlet;

import ccl.util.DBUtil;
import ccl.util.Util;
import ccl.xml.XMLUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class XMLExporter
extends HttpServlet {
    public static String printEscaped(char ch) {
        return XMLUtil.escape(ch);
    }

    public static String printEscaped(String source) {
        return XMLUtil.escape(source);
    }

    private void _printXMLTable(Connection connection_, String sTable_, PrintWriter out_) throws SQLException {
        String sRetVal = "";
        Statement statement = connection_.createStatement();
        ResultSet result = statement.executeQuery("select * from " + sTable_);
        out_.print("  <table name=\"" + sTable_ + "\">\n");
        ResultSetMetaData metaData = result.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        out_.print("    <columns>\n");
        int column = 1;
        while (column <= numberOfColumns) {
            String sColumnName = metaData.getColumnName(column);
            out_.print("      <column>");
            out_.print(sColumnName);
            out_.print("</column>\n");
            ++column;
        }
        out_.print("    </columns>\n");
        out_.print("    <rows>\n");
        while (result.next()) {
            out_.print("      <row>");
            int column2 = 1;
            while (column2 <= numberOfColumns) {
                String sValue = result.getString(column2);
                out_.print("<value>");
                out_.print(XMLUtil.escape(sValue));
                out_.print("</value>");
                ++column2;
            }
            out_.print("</row>\n");
        }
        out_.print("    </rows>\n");
        out_.print("  </table>\n");
        statement.close();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            Connection connection = this.getConnection();
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.println("<database name=\"" + this.getDatabase() + "\">");
            Vector vTables = DBUtil.getUserTables(connection);
            Enumeration eTables = vTables.elements();
            while (eTables.hasMoreElements()) {
                String sNextTable = (String)eTables.nextElement();
                this._printXMLTable(connection, sNextTable, out);
            }
            out.println("</database>");
            connection.close();
        }
        catch (Exception exception) {
            Util.printlnErr(exception.getMessage() + "\n" + Util.getStackTrace(exception));
        }
    }

    public abstract Connection getConnection();

    public abstract String getDatabase();
}

