/*
 * Decompiled with CFR 0.152.
 */
package ccl.platform.test;

import ccl.platform.Linux;
import ccl.platform.Native;
import ccl.util.Test;
import ccl.util.Util;

public class NativeTest
extends Test {
    public NativeTest() {
    }

    public NativeTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() throws Exception {
        Native pNative = Native.getInstance();
        int pid = pNative.getPID();
        this.bugIf(pid == -1 && Util.isOSLinux(), "PID on Linux is -1!");
        if (Util.isOSLinux()) {
            Linux linux = (Linux)pNative;
            int i = 0;
            while (i < 30) {
                int posixPID = linux.getPIDViaPOSIX();
                int procPID = linux.getPIDViaProc();
                this.bugIf(posixPID <= 1 || procPID <= 1);
                if (posixPID != procPID) {
                    this.bugIf(linux.getPGID(posixPID) != linux.getPGID(procPID), "pgid of posix pid " + posixPID + "is " + linux.getPGID(posixPID) + " while pgid of proc pid " + procPID + " is " + linux.getPGID(procPID) + ".");
                } else {
                    this.bugIf(false);
                }
                ++i;
            }
        }
    }

    public static void main(String[] asArg_) {
        NativeTest pTest = new NativeTest();
        pTest.setVerbose(true);
        pTest.setTiming(false);
        pTest.run();
        Test.printResult(pTest);
        System.exit(0);
    }
}

