/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public class BERBitString
extends BERElement {
    private BitSet m_value;
    private int m_value_num_bits;

    public BERBitString(BitSet bitSet) {
        this.m_value = bitSet;
    }

    public BERBitString(BERTagDecoder bERTagDecoder, InputStream inputStream, int[] nArray) throws IOException {
        int n;
        int[] nArray2 = new int[1];
        BERElement bERElement = null;
        if (n == -1) {
            nArray2[0] = 0;
            bERElement = BERBitString.getElement(bERTagDecoder, inputStream, nArray2);
            if (bERElement != null) {
                int n2;
                BERBitString bERBitString = (BERBitString)bERElement;
                BitSet bitSet = new BitSet(this.m_value_num_bits + bERBitString.getSize());
                for (n2 = 0; n2 < this.m_value_num_bits; ++n2) {
                    if (!this.m_value.get(n2)) continue;
                    bitSet.set(n2);
                }
                for (n2 = 0; n2 < bERBitString.getSize(); ++n2) {
                    if (!bERBitString.getValue().get(n2)) continue;
                    bitSet.set(this.m_value_num_bits + n2);
                }
                this.m_value = bitSet;
                this.m_value_num_bits += bERBitString.getSize();
            }
            while (bERElement != null) {
            }
        } else {
            nArray[0] = nArray[0] + n;
            for (n = BERElement.readLengthOctets(inputStream, nArray); n > 0; n -= nArray2[0]) {
                int n3;
                nArray2[0] = 0;
                bERElement = BERBitString.getElement(bERTagDecoder, inputStream, nArray2);
                if (bERElement == null) continue;
                BERBitString bERBitString = (BERBitString)bERElement;
                BitSet bitSet = new BitSet(this.m_value_num_bits + bERBitString.getSize());
                for (n3 = 0; n3 < this.m_value_num_bits; ++n3) {
                    if (!this.m_value.get(n3)) continue;
                    bitSet.set(n3);
                }
                for (n3 = 0; n3 < bERBitString.getSize(); ++n3) {
                    if (!bERBitString.getValue().get(n3)) continue;
                    bitSet.set(this.m_value_num_bits + n3);
                }
                this.m_value = bitSet;
                this.m_value_num_bits += bERBitString.getSize();
            }
        }
    }

    public BERBitString(InputStream inputStream, int[] nArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = BERElement.readLengthOctets(inputStream, nArray);
        int n5 = inputStream.read();
        nArray[0] = nArray[0] + 1;
        this.m_value_num_bits = (--n4 - 1) * 8 + (8 - n5);
        this.m_value = new BitSet();
        int n6 = 0;
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            n2 = inputStream.read();
            n = 128;
            for (int i = 0; i < 8; ++i) {
                if ((n2 & n) > 0) {
                    this.m_value.set(n6);
                } else {
                    this.m_value.clear(n6);
                }
                ++n6;
                n /= 2;
            }
        }
        n2 = inputStream.read();
        n3 = 128;
        for (n = 0; n < 8 - n5; ++n) {
            if ((n2 & n3) > 0) {
                this.m_value.set(n6);
            } else {
                this.m_value.clear(n6);
            }
            ++n6;
            n3 /= 2;
        }
        nArray[0] = nArray[0] + n4;
    }

    public void write(OutputStream outputStream) throws IOException {
        int n;
        int n2;
        int n3;
        outputStream.write(3);
        int n4 = this.m_value_num_bits;
        int n5 = 8 - n4 % 8;
        int n6 = n4 / 8 + 1;
        if (n5 > 0) {
            ++n6;
        }
        outputStream.write(n6);
        outputStream.write(n5);
        for (n3 = 0; n3 < n4 / 8; ++n3) {
            n2 = 0;
            n = 128;
            for (int i = 0; i < 8; ++i) {
                if (this.m_value.get(n3 * 8 + i)) {
                    n2 += n;
                }
                n /= 2;
            }
            outputStream.write(n2);
        }
        if (n5 > 0) {
            n3 = 0;
            n2 = 128;
            for (n = 0; n < n5; ++n) {
                if (this.m_value.get(n4 / 8 * 8 + n)) {
                    n3 += n2;
                }
                n2 /= 2;
            }
            outputStream.write(n3);
        }
    }

    public BitSet getValue() {
        return this.m_value;
    }

    public int getSize() {
        return this.m_value_num_bits;
    }

    public int getType() {
        return 3;
    }

    public String toString() {
        int n;
        int n2;
        int n3;
        String string = "";
        int n4 = this.m_value_num_bits;
        for (n3 = 0; n3 < n4 / 8; ++n3) {
            n2 = 0;
            n = 128;
            for (int i = 0; i < 8; ++i) {
                if (this.m_value.get(n3 * 8 + i)) {
                    n2 += n;
                }
                n /= 2;
            }
            string = string + " " + (byte)n2;
        }
        n3 = 128;
        n2 = 0;
        for (n = 0; n < n4 - n4 / 8; ++n) {
            if (this.m_value.get(n4 / 8 * 8 + n)) {
                n2 += n3;
            }
            n3 /= 2;
        }
        string = string + " " + (byte)n2;
        return "Bitstring {" + string + " }";
    }
}

