/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.CustomAttribute;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class Configurable {
    public static final String LOCALE_KEY = "locale";
    public static final String NUMBER_FORMAT_KEY = "number_format";
    public static final String TIME_FORMAT_KEY = "time_format";
    public static final String DATE_FORMAT_KEY = "date_format";
    public static final String DATETIME_FORMAT_KEY = "datetime_format";
    public static final String TIME_ZONE_KEY = "time_zone";
    public static final String CLASSIC_COMPATIBLE_KEY = "classic_compatible";
    public static final String TEMPLATE_EXCEPTION_HANDLER_KEY = "template_exception_handler";
    public static final String ARITHMETIC_ENGINE_KEY = "arithmetic_engine";
    public static final String OBJECT_WRAPPER_KEY = "object_wrapper";
    public static final String BOOLEAN_FORMAT_KEY = "boolean_format";
    private static final char COMMA = ',';
    private Configurable parent;
    private Properties properties;
    private HashMap customAttributes;
    private Locale locale;
    private String numberFormat;
    private String timeFormat;
    private String dateFormat;
    private String dateTimeFormat;
    private TimeZone timeZone;
    private String trueFormat;
    private String falseFormat;
    private Boolean classicCompatible;
    private TemplateExceptionHandler templateExceptionHandler;
    private ArithmeticEngine arithmeticEngine;
    private ObjectWrapper objectWrapper;

    public Configurable() {
        this.parent = null;
        this.locale = Locale.getDefault();
        this.timeZone = TimeZone.getDefault();
        this.numberFormat = "number";
        this.timeFormat = "";
        this.dateFormat = "";
        this.dateTimeFormat = "";
        this.trueFormat = "true";
        this.falseFormat = "false";
        this.classicCompatible = Boolean.FALSE;
        this.templateExceptionHandler = TemplateExceptionHandler.DEBUG_HANDLER;
        this.arithmeticEngine = ArithmeticEngine.BIGDECIMAL_ENGINE;
        this.objectWrapper = ObjectWrapper.DEFAULT_WRAPPER;
        this.properties = new Properties();
        this.properties.setProperty(LOCALE_KEY, this.locale.toString());
        this.properties.setProperty(TIME_FORMAT_KEY, this.timeFormat);
        this.properties.setProperty(DATE_FORMAT_KEY, this.dateFormat);
        this.properties.setProperty(DATETIME_FORMAT_KEY, this.dateTimeFormat);
        this.properties.setProperty(TIME_ZONE_KEY, this.timeZone.getID());
        this.properties.setProperty(NUMBER_FORMAT_KEY, this.numberFormat);
        this.properties.setProperty(CLASSIC_COMPATIBLE_KEY, this.classicCompatible.toString());
        this.properties.setProperty(TEMPLATE_EXCEPTION_HANDLER_KEY, this.templateExceptionHandler.getClass().getName());
        this.properties.setProperty(ARITHMETIC_ENGINE_KEY, this.arithmeticEngine.getClass().getName());
        this.properties.setProperty(BOOLEAN_FORMAT_KEY, "true,false");
        this.customAttributes = new HashMap();
    }

    public Configurable(Configurable parent) {
        this.parent = parent;
        this.locale = null;
        this.numberFormat = null;
        this.trueFormat = null;
        this.falseFormat = null;
        this.classicCompatible = null;
        this.templateExceptionHandler = null;
        this.properties = new Properties(parent.properties);
        this.customAttributes = new HashMap();
    }

    protected Object clone() throws CloneNotSupportedException {
        Configurable copy = (Configurable)super.clone();
        copy.properties = new Properties(this.properties);
        copy.customAttributes = (HashMap)this.customAttributes.clone();
        return copy;
    }

    public final Configurable getParent() {
        return this.parent;
    }

    final void setParent(Configurable parent) {
        this.parent = parent;
    }

    public void setClassicCompatible(boolean classicCompatibility) {
        this.classicCompatible = classicCompatibility ? Boolean.TRUE : Boolean.FALSE;
        this.properties.setProperty(CLASSIC_COMPATIBLE_KEY, this.classicCompatible.toString());
    }

    public boolean isClassicCompatible() {
        return this.classicCompatible != null ? this.classicCompatible.booleanValue() : this.parent.isClassicCompatible();
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Setting \"locale\" can't be null");
        }
        this.locale = locale;
        this.properties.setProperty(LOCALE_KEY, locale.toString());
    }

    public TimeZone getTimeZone() {
        return this.timeZone != null ? this.timeZone : this.parent.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("Setting \"time_zone\" can't be null");
        }
        this.timeZone = timeZone;
        this.properties.setProperty(TIME_ZONE_KEY, timeZone.getID());
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : this.parent.getLocale();
    }

    public void setNumberFormat(String numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Setting \"number_format\" can't be null");
        }
        this.numberFormat = numberFormat;
        this.properties.setProperty(NUMBER_FORMAT_KEY, numberFormat);
    }

    public String getNumberFormat() {
        return this.numberFormat != null ? this.numberFormat : this.parent.getNumberFormat();
    }

    public void setBooleanFormat(String booleanFormat) {
        if (booleanFormat == null) {
            throw new IllegalArgumentException("Setting \"boolean_format\" can't be null");
        }
        int comma = booleanFormat.indexOf(44);
        if (comma == -1) {
            throw new IllegalArgumentException("Setting \"boolean_format\" must consist of two comma-separated values for true and false respectively");
        }
        this.trueFormat = booleanFormat.substring(0, comma);
        this.falseFormat = booleanFormat.substring(comma + 1);
        this.properties.setProperty(BOOLEAN_FORMAT_KEY, booleanFormat);
    }

    public String getBooleanFormat() {
        if (this.trueFormat == null) {
            return this.parent.getBooleanFormat();
        }
        return this.trueFormat + ',' + this.falseFormat;
    }

    String getBooleanFormat(boolean value) {
        return value ? this.getTrueFormat() : this.getFalseFormat();
    }

    private String getTrueFormat() {
        return this.trueFormat != null ? this.trueFormat : this.parent.getTrueFormat();
    }

    private String getFalseFormat() {
        return this.falseFormat != null ? this.falseFormat : this.parent.getFalseFormat();
    }

    public void setTimeFormat(String timeFormat) {
        if (timeFormat == null) {
            throw new IllegalArgumentException("Setting \"time_format\" can't be null");
        }
        this.timeFormat = timeFormat;
        this.properties.setProperty(TIME_FORMAT_KEY, timeFormat);
    }

    public String getTimeFormat() {
        return this.timeFormat != null ? this.timeFormat : this.parent.getTimeFormat();
    }

    public void setDateFormat(String dateFormat) {
        if (dateFormat == null) {
            throw new IllegalArgumentException("Setting \"date_format\" can't be null");
        }
        this.dateFormat = dateFormat;
        this.properties.setProperty(DATE_FORMAT_KEY, dateFormat);
    }

    public String getDateFormat() {
        return this.dateFormat != null ? this.dateFormat : this.parent.getDateFormat();
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        if (dateTimeFormat == null) {
            throw new IllegalArgumentException("Setting \"datetime_format\" can't be null");
        }
        this.dateTimeFormat = dateTimeFormat;
        this.properties.setProperty(DATETIME_FORMAT_KEY, dateTimeFormat);
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat != null ? this.dateTimeFormat : this.parent.getDateTimeFormat();
    }

    public void setTemplateExceptionHandler(TemplateExceptionHandler templateExceptionHandler) {
        if (templateExceptionHandler == null) {
            throw new IllegalArgumentException("Setting \"template_exception_handler\" can't be null");
        }
        this.templateExceptionHandler = templateExceptionHandler;
        this.properties.setProperty(TEMPLATE_EXCEPTION_HANDLER_KEY, templateExceptionHandler.getClass().getName());
    }

    public TemplateExceptionHandler getTemplateExceptionHandler() {
        return this.templateExceptionHandler != null ? this.templateExceptionHandler : this.parent.getTemplateExceptionHandler();
    }

    public void setArithmeticEngine(ArithmeticEngine arithmeticEngine) {
        if (arithmeticEngine == null) {
            throw new IllegalArgumentException("Setting \"arithmetic_engine\" can't be null");
        }
        this.arithmeticEngine = arithmeticEngine;
        this.properties.setProperty(ARITHMETIC_ENGINE_KEY, arithmeticEngine.getClass().getName());
    }

    public ArithmeticEngine getArithmeticEngine() {
        return this.arithmeticEngine != null ? this.arithmeticEngine : this.parent.getArithmeticEngine();
    }

    public void setObjectWrapper(ObjectWrapper objectWrapper) {
        if (objectWrapper == null) {
            throw new IllegalArgumentException("Setting \"object_wrapper\" can't be null");
        }
        this.objectWrapper = objectWrapper;
        this.properties.setProperty(OBJECT_WRAPPER_KEY, objectWrapper.getClass().getName());
    }

    public ObjectWrapper getObjectWrapper() {
        return this.objectWrapper != null ? this.objectWrapper : this.parent.getObjectWrapper();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSetting(String key, String value) throws TemplateException {
        try {
            if (LOCALE_KEY.equals(key)) {
                this.setLocale(StringUtil.deduceLocale(value));
                return;
            } else if (NUMBER_FORMAT_KEY.equals(key)) {
                this.setNumberFormat(value);
                return;
            } else if (TIME_FORMAT_KEY.equals(key)) {
                this.setTimeFormat(value);
                return;
            } else if (DATE_FORMAT_KEY.equals(key)) {
                this.setDateFormat(value);
                return;
            } else if (DATETIME_FORMAT_KEY.equals(key)) {
                this.setDateTimeFormat(value);
                return;
            } else if (TIME_ZONE_KEY.equals(key)) {
                this.setTimeZone(TimeZone.getTimeZone(value));
                return;
            } else if (CLASSIC_COMPATIBLE_KEY.equals(key)) {
                this.setClassicCompatible(StringUtil.getYesNo(value));
                return;
            } else if (TEMPLATE_EXCEPTION_HANDLER_KEY.equals(key)) {
                if (value.indexOf(46) == -1) {
                    if ("debug".equalsIgnoreCase(value)) {
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
                        return;
                    } else if ("html_debug".equalsIgnoreCase(value)) {
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
                        return;
                    } else if ("ignore".equalsIgnoreCase(value)) {
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
                        return;
                    } else {
                        if (!"rethrow".equalsIgnoreCase(value)) throw this.invalidSettingValueException(key, value);
                        this.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
                    }
                    return;
                } else {
                    this.setTemplateExceptionHandler((TemplateExceptionHandler)ClassUtil.forName(value).newInstance());
                }
                return;
            } else if (ARITHMETIC_ENGINE_KEY.equals(key)) {
                if (value.indexOf(46) == -1) {
                    if ("bigdecimal".equalsIgnoreCase(value)) {
                        this.setArithmeticEngine(ArithmeticEngine.BIGDECIMAL_ENGINE);
                        return;
                    } else {
                        if (!"conservative".equalsIgnoreCase(value)) throw this.invalidSettingValueException(key, value);
                        this.setArithmeticEngine(ArithmeticEngine.CONSERVATIVE_ENGINE);
                    }
                    return;
                } else {
                    this.setArithmeticEngine((ArithmeticEngine)ClassUtil.forName(value).newInstance());
                }
                return;
            } else if (OBJECT_WRAPPER_KEY.equals(key)) {
                if (value.indexOf(46) == -1) {
                    if ("default".equalsIgnoreCase(value)) {
                        this.setObjectWrapper(ObjectWrapper.DEFAULT_WRAPPER);
                    }
                    if ("simple".equalsIgnoreCase(value)) {
                        this.setObjectWrapper(ObjectWrapper.SIMPLE_WRAPPER);
                        return;
                    } else if ("beans".equalsIgnoreCase(value)) {
                        this.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
                        return;
                    } else {
                        if (!"jython".equalsIgnoreCase(value)) throw this.invalidSettingValueException(key, value);
                        Class<?> clazz = Class.forName("freemarker.ext.jython.JythonWrapper");
                        this.setObjectWrapper((ObjectWrapper)clazz.getField("INSTANCE").get(null));
                    }
                    return;
                } else {
                    this.setObjectWrapper((ObjectWrapper)ClassUtil.forName(value).newInstance());
                }
                return;
            } else {
                if (!BOOLEAN_FORMAT_KEY.equals(key)) throw this.unknownSettingException(key);
                this.setBooleanFormat(value);
            }
            return;
        }
        catch (TemplateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException("Failed to set setting " + key + " to value " + value, e, this.getEnvironment());
        }
    }

    public String getSetting(String key) {
        return this.properties.getProperty(key);
    }

    public Map getSettings() {
        return Collections.unmodifiableMap(this.properties);
    }

    protected Environment getEnvironment() {
        return this instanceof Environment ? (Environment)this : Environment.getCurrentEnvironment();
    }

    protected TemplateException unknownSettingException(String name) {
        return new UnknownSettingException(name, this.getEnvironment());
    }

    protected TemplateException invalidSettingValueException(String name, String value) {
        return new TemplateException("Invalid value for setting " + name + ": " + value, this.getEnvironment());
    }

    public void setSettings(Properties props) throws TemplateException {
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.setSetting(key, props.getProperty(key).trim());
        }
    }

    public void setSettings(InputStream propsIn) throws TemplateException, IOException {
        Properties p = new Properties();
        p.load(propsIn);
        this.setSettings(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCustomAttribute(Object key, Object value) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            this.customAttributes.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getCustomAttribute(Object key, CustomAttribute attr) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            Object o = this.customAttributes.get(key);
            if (o == null && !this.customAttributes.containsKey(key)) {
                o = attr.create();
                this.customAttributes.put(key, o);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomAttribute(String name, Object value) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            this.customAttributes.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCustomAttributeNames() {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            LinkedList names = new LinkedList(this.customAttributes.keySet());
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                if (iter.next() instanceof String) continue;
                iter.remove();
            }
            return names.toArray(new String[names.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomAttribute(String name) {
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            this.customAttributes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCustomAttribute(String name) {
        Object retval;
        HashMap hashMap = this.customAttributes;
        synchronized (hashMap) {
            retval = this.customAttributes.get(name);
            if (retval == null && this.customAttributes.containsKey(name)) {
                return null;
            }
        }
        if (retval == null && this.parent != null) {
            return this.parent.getCustomAttribute(name);
        }
        return retval;
    }

    public class UnknownSettingException
    extends TemplateException {
        private UnknownSettingException(String name, Environment env) {
            super("Unknown setting: " + name, env);
        }
    }
}

