/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.GroovyObject;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.MetadataNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.objectweb.asm.Constants;

public class ClassNode
extends MetadataNode
implements Constants {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private String name;
    private int modifiers;
    private String superClass;
    private String[] interfaces;
    private MixinNode[] mixins;
    private List constructors = new ArrayList();
    private List methods = new ArrayList();
    private List fields = new ArrayList();
    private List properties = new ArrayList();
    private Map fieldIndex = new HashMap();
    private ModuleNode module;
    private boolean staticClass = false;
    private boolean scriptBody = false;
    private boolean script;
    private ClassNode superClassNode;

    public ClassNode(String name, int modifiers, String superClass) {
        this(name, modifiers, superClass, EMPTY_STRING_ARRAY, MixinNode.EMPTY_ARRAY);
    }

    public ClassNode(String name, int modifiers, String superClass, String[] interfaces, MixinNode[] mixins) {
        this.name = name;
        this.modifiers = modifiers;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.mixins = mixins;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public List getFields() {
        return this.fields;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public MixinNode[] getMixins() {
        return this.mixins;
    }

    public List getMethods() {
        return this.methods;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public List getProperties() {
        return this.properties;
    }

    public List getConstructors() {
        return this.constructors;
    }

    public ModuleNode getModule() {
        return this.module;
    }

    public void setModule(ModuleNode module) {
        this.module = module;
    }

    public void addField(FieldNode node) {
        this.fields.add(node);
        this.fieldIndex.put(node.getName(), node);
    }

    public void addProperty(PropertyNode node) {
        FieldNode field = node.getField();
        this.addField(field);
        this.properties.add(node);
    }

    public PropertyNode addProperty(String name, int modifiers, String type, Expression initialValueExpression, Statement getterBlock, Statement setterBlock) {
        PropertyNode node = new PropertyNode(name, modifiers, type, this.getName(), initialValueExpression, getterBlock, setterBlock);
        this.addProperty(node);
        return node;
    }

    public void addConstructor(ConstructorNode node) {
        this.constructors.add(node);
    }

    public ConstructorNode addConstructor(int modifiers, Parameter[] parameters, Statement code) {
        ConstructorNode node = new ConstructorNode(modifiers, parameters, code);
        this.addConstructor(node);
        return node;
    }

    public void addMethod(MethodNode node) {
        this.methods.add(node);
    }

    public MethodNode addMethod(String name, int modifiers, String returnType, Parameter[] parameters, Statement code) {
        MethodNode other = this.getMethod(name, parameters);
        if (other != null) {
            return other;
        }
        MethodNode node = new MethodNode(name, modifiers, returnType, parameters, code);
        this.addMethod(node);
        return node;
    }

    public MethodNode addSyntheticMethod(String name, int modifiers, String returnType, Parameter[] parameters, Statement code) {
        MethodNode answer = this.addMethod(name, modifiers, returnType, parameters, code);
        answer.setSynthetic(true);
        return answer;
    }

    public FieldNode addField(String name, int modifiers, String type, Expression initialValue) {
        FieldNode node = new FieldNode(name, modifiers, type, this.getName(), initialValue);
        this.addField(node);
        return node;
    }

    public void addInterface(String name) {
        boolean skip = false;
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (!name.equals(this.interfaces[i])) continue;
            skip = true;
        }
        if (!skip) {
            String[] newInterfaces = new String[this.interfaces.length + 1];
            System.arraycopy(this.interfaces, 0, newInterfaces, 0, this.interfaces.length);
            newInterfaces[this.interfaces.length] = name;
            this.interfaces = newInterfaces;
        }
    }

    public void addMixin(MixinNode mixin) {
        boolean skip = false;
        String name = mixin.getName();
        for (int i = 0; i < this.mixins.length; ++i) {
            if (!name.equals(this.mixins[i].getName())) continue;
            skip = true;
        }
        if (!skip) {
            MixinNode[] newMixins = new MixinNode[this.mixins.length + 1];
            System.arraycopy(this.mixins, 0, newMixins, 0, this.mixins.length);
            newMixins[this.mixins.length] = mixin;
            this.mixins = newMixins;
        }
    }

    public FieldNode getField(String name) {
        return (FieldNode)this.fieldIndex.get(name);
    }

    public FieldNode getOuterField(String name) {
        return null;
    }

    public ClassNode getOuterClass() {
        return null;
    }

    public void addStaticInitializerStatements(List staticStatements) {
        MethodNode method = this.getMethod("<clinit>");
        if (method == null) {
            method = this.addMethod("<clinit>", 9, "void", Parameter.EMPTY_ARRAY, new BlockStatement());
        }
        BlockStatement block = null;
        Statement statement = method.getCode();
        if (statement == null) {
            block = new BlockStatement();
        } else if (statement instanceof BlockStatement) {
            block = (BlockStatement)statement;
        } else {
            block = new BlockStatement();
            block.addStatement(statement);
        }
        block.addStatements(staticStatements);
    }

    public MethodNode getMethod(String name) {
        Iterator iter = this.methods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public MethodNode getMethod(String name, Parameter[] parameters) {
        Iterator iter = this.methods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!name.equals(method.getName()) || !this.parametersEqual(method.getParameters(), parameters)) continue;
            return method;
        }
        return null;
    }

    public boolean isDerivedFrom(String name) {
        for (ClassNode node = this.getSuperClassNode(); node != null; node = node.getSuperClassNode()) {
            if (!name.equals(node.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isDerivedFromGroovyObject() {
        return this.implementsInteface(GroovyObject.class.getName());
    }

    public boolean implementsInteface(String name) {
        ClassNode node = this;
        do {
            if (!node.declaresInterface(name)) continue;
            return true;
        } while ((node = node.getSuperClassNode()) != null);
        return false;
    }

    public boolean declaresInterface(String name) {
        int size = this.interfaces.length;
        for (int i = 0; i < size; ++i) {
            if (!name.equals(this.interfaces[i])) continue;
            return true;
        }
        return false;
    }

    public ClassNode getSuperClassNode() {
        if (this.superClassNode == null && !this.superClass.equals("java.lang.Object")) {
            this.superClassNode = this.findClassNode(this.superClass);
        }
        return this.superClassNode;
    }

    public ClassNode findClassNode(String type) {
        ClassNode answer = null;
        CompileUnit compileUnit = this.getCompileUnit();
        if (compileUnit != null && (answer = compileUnit.getClass(type)) == null) {
            try {
                Class theClass = compileUnit.loadClass(type);
                answer = this.createClassNode(theClass);
            }
            catch (ClassNotFoundException e) {
                this.log.warning("Cannot find class: " + type + " due to: " + e);
            }
        }
        return answer;
    }

    protected ClassNode createClassNode(Class theClass) {
        Class<?>[] interfaces = theClass.getInterfaces();
        int size = interfaces.length;
        String[] interfaceNames = new String[size];
        for (int i = 0; i < size; ++i) {
            interfaceNames[i] = interfaces[i].getName();
        }
        ClassNode answer = new ClassNode(theClass.getName(), theClass.getModifiers(), theClass.getSuperclass().getName(), interfaceNames, MixinNode.EMPTY_ARRAY);
        return answer;
    }

    public String resolveClassName(String type) {
        String answer = null;
        if (type != null) {
            String packageName;
            if (this.getName().equals(type) || this.getNameWithoutPackage().equals(type)) {
                return this.getName();
            }
            answer = this.tryResolveClassFromCompileUnit(type);
            if (answer == null && (packageName = this.getPackageName()) != null && packageName.length() > 0) {
                answer = this.tryResolveClassFromCompileUnit(packageName + "." + type);
            }
            if (answer == null && this.module != null) {
                Iterator iter = this.module.getImportPackages().iterator();
                while (iter.hasNext()) {
                    String packageName2 = (String)iter.next();
                    answer = this.tryResolveClassFromCompileUnit(packageName2 + type);
                    if (answer == null) continue;
                    return answer;
                }
            }
        }
        return answer;
    }

    protected String tryResolveClassFromCompileUnit(String type) {
        CompileUnit compileUnit = this.getCompileUnit();
        if (compileUnit != null) {
            if (compileUnit.getClass(type) != null) {
                return type;
            }
            try {
                compileUnit.loadClass(type);
                return type;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public CompileUnit getCompileUnit() {
        return this.module != null ? this.module.getUnit() : null;
    }

    protected boolean parametersEqual(Parameter[] a, Parameter[] b) {
        if (a.length == b.length) {
            boolean answer = true;
            for (int i = 0; i < a.length; ++i) {
                if (a[i].getType().equals(b[i].getType())) continue;
                answer = false;
                break;
            }
            return answer;
        }
        return false;
    }

    public String getClassNameForExpression(String identifier) {
        String className = null;
        if (this.module != null) {
            className = this.module.getImport(identifier);
            if (className == null) {
                if (this.module.getUnit().getClass(identifier) != null) {
                    className = identifier;
                } else {
                    String packageName = this.getPackageName();
                    if (packageName != null) {
                        String guessName = packageName + "." + identifier;
                        if (this.module.getUnit().getClass(guessName) != null) {
                            className = guessName;
                        } else if (guessName.equals(this.name)) {
                            className = this.name;
                        }
                    }
                }
            }
        } else {
            System.out.println("No module for class: " + this.getName());
        }
        return className;
    }

    public String getPackageName() {
        int idx = this.name.lastIndexOf(46);
        if (idx > 0) {
            return this.name.substring(0, idx);
        }
        return null;
    }

    public String getNameWithoutPackage() {
        int idx = this.name.lastIndexOf(46);
        if (idx > 0) {
            return this.name.substring(idx + 1);
        }
        return this.name;
    }

    public void visitContents(GroovyClassVisitor visitor) {
        Iterator iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            visitor.visitProperty((PropertyNode)iter.next());
        }
        iter = this.getFields().iterator();
        while (iter.hasNext()) {
            visitor.visitField((FieldNode)iter.next());
        }
        iter = this.getConstructors().iterator();
        while (iter.hasNext()) {
            visitor.visitConstructor((ConstructorNode)iter.next());
        }
        iter = this.getMethods().iterator();
        while (iter.hasNext()) {
            visitor.visitMethod((MethodNode)iter.next());
        }
    }

    public MethodNode getGetterMethod(String getterName) {
        Iterator iter = this.methods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!getterName.equals(method.getName()) || "void".equals(method.getReturnType()) || method.getParameters().length != 0) continue;
            return method;
        }
        return null;
    }

    public MethodNode getSetterMethod(String getterName) {
        Iterator iter = this.methods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!getterName.equals(method.getName()) || !"void".equals(method.getReturnType()) || method.getParameters().length != 1) continue;
            return method;
        }
        return null;
    }

    public boolean isStaticClass() {
        return this.staticClass;
    }

    public void setStaticClass(boolean staticClass) {
        this.staticClass = staticClass;
    }

    public boolean isScriptBody() {
        return this.scriptBody;
    }

    public void setScriptBody(boolean scriptBody) {
        this.scriptBody = scriptBody;
    }

    public boolean isScript() {
        return this.script | this.isDerivedFrom(Script.class.getName());
    }

    public void setScript(boolean script) {
        this.script = script;
    }

    public String toString() {
        return super.toString() + "[name: " + this.name + "]";
    }
}

