/*-*- mode:c;indent-tabs-mode:nil;c-basic-offset:2;tab-width:8;coding:utf-8 -*-│
│vi: set net ft=c ts=2 sts=2 sw=2 fenc=utf-8                                :vi│
╞══════════════════════════════════════════════════════════════════════════════╡
│ Copyright 2022 Justine Alexandra Roberts Tunney                              │
│                                                                              │
│ Permission to use, copy, modify, and/or distribute this software for         │
│ any purpose with or without fee is hereby granted, provided that the         │
│ above copyright notice and this permission notice appear in all copies.      │
│                                                                              │
│ THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL                │
│ WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED                │
│ WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE             │
│ AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL         │
│ DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR        │
│ PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER               │
│ TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR             │
│ PERFORMANCE OF THIS SOFTWARE.                                                │
╚─────────────────────────────────────────────────────────────────────────────*/
#include "blink/builtin.h"
#include "blink/case.h"
#include "blink/debug.h"

const char *DescribeMopcode(int code) {
  switch (code) {
    XLAT(0x000, "OpAlub");
    XLAT(0x001, "OpAluw");
    XLAT(0x002, "OpAlubFlip");
    XLAT(0x003, "OpAluwFlip");
    XLAT(0x004, "OpAluAlIbAdd");
    XLAT(0x005, "OpAluRaxIvds");
    XLAT(0x006, "OpPushSeg");
    XLAT(0x007, "OpPopSeg");
    XLAT(0x008, "OpAlub");
    XLAT(0x009, "OpAluw");
    XLAT(0x00A, "OpAlubFlip");
    XLAT(0x00B, "OpAluwFlip");
    XLAT(0x00C, "OpAluAlIbOr");
    XLAT(0x00D, "OpAluRaxIvds");
    XLAT(0x00E, "OpPushSeg");
    XLAT(0x00F, "OpPopSeg");
    XLAT(0x010, "OpAlub");
    XLAT(0x011, "OpAluw");
    XLAT(0x012, "OpAlubFlip");
    XLAT(0x013, "OpAluwFlip");
    XLAT(0x014, "OpAluAlIbAdc");
    XLAT(0x015, "OpAluRaxIvds");
    XLAT(0x016, "OpPushSeg");
    XLAT(0x017, "OpPopSeg");
    XLAT(0x018, "OpAlub");
    XLAT(0x019, "OpAluw");
    XLAT(0x01A, "OpAlubFlip");
    XLAT(0x01B, "OpAluwFlip");
    XLAT(0x01C, "OpAluAlIbSbb");
    XLAT(0x01D, "OpAluRaxIvds");
    XLAT(0x01E, "OpPushSeg");
    XLAT(0x01F, "OpPopSeg");
    XLAT(0x020, "OpAlub");
    XLAT(0x021, "OpAluw");
    XLAT(0x022, "OpAlubFlip");
    XLAT(0x023, "OpAluwFlip");
    XLAT(0x024, "OpAluAlIbAnd");
    XLAT(0x025, "OpAluRaxIvds");
    XLAT(0x026, "OpPushSeg");
    XLAT(0x027, "OpPopSeg");
    XLAT(0x028, "OpAlub");
    XLAT(0x029, "OpAluw");
    XLAT(0x02A, "OpAlubFlip");
    XLAT(0x02B, "OpAluwFlip");
    XLAT(0x02C, "OpAluAlIbSub");
    XLAT(0x02D, "OpAluRaxIvds");
    XLAT(0x02E, "OpUd");
    XLAT(0x02F, "OpDas");
    XLAT(0x030, "OpAlub");
    XLAT(0x031, "OpAluw");
    XLAT(0x032, "OpAlubFlip");
    XLAT(0x033, "OpAluwFlip");
    XLAT(0x034, "OpAluAlIbXor");
    XLAT(0x035, "OpAluRaxIvds");
    XLAT(0x036, "OpUd");
    XLAT(0x037, "OpAaa");
    XLAT(0x038, "OpAlubCmp");
    XLAT(0x039, "OpAluwCmp");
    XLAT(0x03A, "OpAlubFlipCmp");
    XLAT(0x03B, "OpAluwFlipCmp");
    XLAT(0x03C, "OpCmpAlIb");
    XLAT(0x03D, "OpCmpRaxIvds");
    XLAT(0x03E, "OpUd");
    XLAT(0x03F, "OpAas");
    XLAT(0x040, "OpIncZv");
    XLAT(0x041, "OpIncZv");
    XLAT(0x042, "OpIncZv");
    XLAT(0x043, "OpIncZv");
    XLAT(0x044, "OpIncZv");
    XLAT(0x045, "OpIncZv");
    XLAT(0x046, "OpIncZv");
    XLAT(0x047, "OpIncZv");
    XLAT(0x048, "OpDecZv");
    XLAT(0x049, "OpDecZv");
    XLAT(0x04A, "OpDecZv");
    XLAT(0x04B, "OpDecZv");
    XLAT(0x04C, "OpDecZv");
    XLAT(0x04D, "OpDecZv");
    XLAT(0x04E, "OpDecZv");
    XLAT(0x04F, "OpDecZv");
    XLAT(0x050, "OpPushZvq");
    XLAT(0x051, "OpPushZvq");
    XLAT(0x052, "OpPushZvq");
    XLAT(0x053, "OpPushZvq");
    XLAT(0x054, "OpPushZvq");
    XLAT(0x055, "OpPushZvq");
    XLAT(0x056, "OpPushZvq");
    XLAT(0x057, "OpPushZvq");
    XLAT(0x058, "OpPopZvq");
    XLAT(0x059, "OpPopZvq");
    XLAT(0x05A, "OpPopZvq");
    XLAT(0x05B, "OpPopZvq");
    XLAT(0x05C, "OpPopZvq");
    XLAT(0x05D, "OpPopZvq");
    XLAT(0x05E, "OpPopZvq");
    XLAT(0x05F, "OpPopZvq");
    XLAT(0x060, "OpPusha");
    XLAT(0x061, "OpPopa");
    XLAT(0x062, "OpUd");
    XLAT(0x063, "OpMovsxdGdqpEd");
    XLAT(0x064, "OpUd");
    XLAT(0x065, "OpUd");
    XLAT(0x066, "OpUd");
    XLAT(0x067, "OpUd");
    XLAT(0x068, "OpPushImm");
    XLAT(0x069, "OpImulGvqpEvqpImm");
    XLAT(0x06A, "OpPushImm");
    XLAT(0x06B, "OpImulGvqpEvqpImm");
    XLAT(0x06C, "OpIns");
    XLAT(0x06D, "OpIns");
    XLAT(0x06E, "OpOuts");
    XLAT(0x06F, "OpOuts");
    XLAT(0x070, "OpJo");
    XLAT(0x071, "OpJno");
    XLAT(0x072, "OpJb");
    XLAT(0x073, "OpJae");
    XLAT(0x074, "OpJe");
    XLAT(0x075, "OpJne");
    XLAT(0x076, "OpJbe");
    XLAT(0x077, "OpJa");
    XLAT(0x078, "OpJs");
    XLAT(0x079, "OpJns");
    XLAT(0x07A, "OpJp");
    XLAT(0x07B, "OpJnp");
    XLAT(0x07C, "OpJl");
    XLAT(0x07D, "OpJge");
    XLAT(0x07E, "OpJle");
    XLAT(0x07F, "OpJg");
    XLAT(0x080, "OpAlubiReg");
    XLAT(0x081, "OpAluwiReg");
    XLAT(0x082, "OpAlubiReg");
    XLAT(0x083, "OpAluwiReg");
    XLAT(0x084, "OpAlubTest");
    XLAT(0x085, "OpAluwTest");
    XLAT(0x086, "OpXchgGbEb");
    XLAT(0x087, "OpXchgGvqpEvqp");
    XLAT(0x088, "OpMovEbGb");
    XLAT(0x089, "OpMovEvqpGvqp");
    XLAT(0x08A, "OpMovGbEb");
    XLAT(0x08B, "OpMovGvqpEvqp");
    XLAT(0x08C, "OpMovEvqpSw");
    XLAT(0x08D, "OpLeaGvqpM");
    XLAT(0x08E, "OpMovSwEvqp");
    XLAT(0x08F, "OpPopEvq");
    XLAT(0x090, "OpNop");
    XLAT(0x091, "OpXchgZvqp");
    XLAT(0x092, "OpXchgZvqp");
    XLAT(0x093, "OpXchgZvqp");
    XLAT(0x094, "OpXchgZvqp");
    XLAT(0x095, "OpXchgZvqp");
    XLAT(0x096, "OpXchgZvqp");
    XLAT(0x097, "OpXchgZvqp");
    XLAT(0x098, "OpSax");
    XLAT(0x099, "OpConvert");
    XLAT(0x09A, "OpCallf");
    XLAT(0x09B, "OpFwait");
    XLAT(0x09C, "OpPushf");
    XLAT(0x09D, "OpPopf");
    XLAT(0x09E, "OpSahf");
    XLAT(0x09F, "OpLahf");
    XLAT(0x0A0, "OpMovAlOb");
    XLAT(0x0A1, "OpMovRaxOvqp");
    XLAT(0x0A2, "OpMovObAl");
    XLAT(0x0A3, "OpMovOvqpRax");
    XLAT(0x0A4, "OpMovsb");
    XLAT(0x0A5, "OpMovs");
    XLAT(0x0A6, "OpCmps");
    XLAT(0x0A7, "OpCmps");
    XLAT(0x0A8, "OpTestAlIb");
    XLAT(0x0A9, "OpTestRaxIvds");
    XLAT(0x0AA, "OpStosb");
    XLAT(0x0AB, "OpStos");
    XLAT(0x0AC, "OpLods");
    XLAT(0x0AD, "OpLods");
    XLAT(0x0AE, "OpScas");
    XLAT(0x0AF, "OpScas");
    XLAT(0x0B0, "OpMovZbIb");
    XLAT(0x0B1, "OpMovZbIb");
    XLAT(0x0B2, "OpMovZbIb");
    XLAT(0x0B3, "OpMovZbIb");
    XLAT(0x0B4, "OpMovZbIb");
    XLAT(0x0B5, "OpMovZbIb");
    XLAT(0x0B6, "OpMovZbIb");
    XLAT(0x0B7, "OpMovZbIb");
    XLAT(0x0B8, "OpMovZvqpIvqp");
    XLAT(0x0B9, "OpMovZvqpIvqp");
    XLAT(0x0BA, "OpMovZvqpIvqp");
    XLAT(0x0BB, "OpMovZvqpIvqp");
    XLAT(0x0BC, "OpMovZvqpIvqp");
    XLAT(0x0BD, "OpMovZvqpIvqp");
    XLAT(0x0BE, "OpMovZvqpIvqp");
    XLAT(0x0BF, "OpMovZvqpIvqp");
    XLAT(0x0C0, "OpBsubiImm");
    XLAT(0x0C1, "OpBsuwiImm");
    XLAT(0x0C2, "OpRetIw");
    XLAT(0x0C3, "OpRet");
    XLAT(0x0C4, "OpLes");
    XLAT(0x0C5, "OpLds");
    XLAT(0x0C6, "OpMovEbIb");
    XLAT(0x0C7, "OpMovEvqpIvds");
    XLAT(0x0C8, "OpUd");
    XLAT(0x0C9, "OpLeave");
    XLAT(0x0CA, "OpRetf");
    XLAT(0x0CB, "OpRetf");
    XLAT(0x0CC, "OpInterrupt3");
    XLAT(0x0CD, "OpInterruptImm");
    XLAT(0x0CE, "OpUd");
    XLAT(0x0CF, "OpUd");
    XLAT(0x0D0, "OpBsubi1");
    XLAT(0x0D1, "OpBsuwi1");
    XLAT(0x0D2, "OpBsubiCl");
    XLAT(0x0D3, "OpBsuwiCl");
    XLAT(0x0D4, "OpAam");
    XLAT(0x0D5, "OpAad");
    XLAT(0x0D6, "OpSalc");
    XLAT(0x0D7, "OpXlatAlBbb");
    XLAT(0x0D8, "OpFpu");
    XLAT(0x0D9, "OpFpu");
    XLAT(0x0DA, "OpFpu");
    XLAT(0x0DB, "OpFpu");
    XLAT(0x0DC, "OpFpu");
    XLAT(0x0DD, "OpFpu");
    XLAT(0x0DE, "OpFpu");
    XLAT(0x0DF, "OpFpu");
    XLAT(0x0E0, "OpLoopne");
    XLAT(0x0E1, "OpLoope");
    XLAT(0x0E2, "OpLoop1");
    XLAT(0x0E3, "OpJcxz");
    XLAT(0x0E4, "OpInAlImm");
    XLAT(0x0E5, "OpInAxImm");
    XLAT(0x0E6, "OpOutImmAl");
    XLAT(0x0E7, "OpOutImmAx");
    XLAT(0x0E8, "OpCallJvds");
    XLAT(0x0E9, "OpJmp");
    XLAT(0x0EA, "OpJmpf");
    XLAT(0x0EB, "OpJmp");
    XLAT(0x0EC, "OpInAlDx");
    XLAT(0x0ED, "OpInAxDx");
    XLAT(0x0EE, "OpOutDxAl");
    XLAT(0x0EF, "OpOutDxAx");
    XLAT(0x0F0, "OpUd");
    XLAT(0x0F1, "OpInterrupt1");
    XLAT(0x0F2, "OpUd");
    XLAT(0x0F3, "OpUd");
    XLAT(0x0F4, "OpHlt");
    XLAT(0x0F5, "OpCmc");
    XLAT(0x0F6, "Op0f6");
    XLAT(0x0F7, "Op0f7");
    XLAT(0x0F8, "OpClc");
    XLAT(0x0F9, "OpStc");
    XLAT(0x0FA, "OpCli");
    XLAT(0x0FB, "OpSti");
    XLAT(0x0FC, "OpCld");
    XLAT(0x0FD, "OpStd");
    XLAT(0x0FE, "Op0fe");
    XLAT(0x0FF, "Op0ff");
    XLAT(0x100, "OpUd");
    XLAT(0x101, "Op101");
    XLAT(0x102, "OpUd");
    XLAT(0x103, "OpLsl");
    XLAT(0x104, "OpUd");
    XLAT(0x105, "OpSyscall");
    XLAT(0x106, "OpUd");
    XLAT(0x107, "OpUd");
    XLAT(0x108, "OpUd");
    XLAT(0x109, "OpUd");
    XLAT(0x10A, "OpUd");
    XLAT(0x10B, "OpUd");
    XLAT(0x10C, "OpUd");
    XLAT(0x10D, "OpHintNopEv");
    XLAT(0x10E, "OpUd");
    XLAT(0x10F, "OpUd");
    XLAT(0x110, "OpMov0f10");
    XLAT(0x111, "OpMovWpsVps");
    XLAT(0x112, "OpMov0f12");
    XLAT(0x113, "OpMov0f13");
    XLAT(0x114, "OpUnpcklpsd");
    XLAT(0x115, "OpUnpckhpsd");
    XLAT(0x116, "OpMov0f16");
    XLAT(0x117, "OpMov0f17");
    XLAT(0x118, "OpHintNopEv");
    XLAT(0x119, "OpHintNopEv");
    XLAT(0x11A, "OpHintNopEv");
    XLAT(0x11B, "OpHintNopEv");
    XLAT(0x11C, "OpHintNopEv");
    XLAT(0x11D, "OpHintNopEv");
    XLAT(0x11E, "OpHintNopEv");
    XLAT(0x11F, "OpNopEv");
    XLAT(0x120, "OpMovRqCq");
    XLAT(0x121, "OpUd");
    XLAT(0x122, "OpMovCqRq");
    XLAT(0x123, "OpUd");
    XLAT(0x124, "OpUd");
    XLAT(0x125, "OpUd");
    XLAT(0x126, "OpUd");
    XLAT(0x127, "OpUd");
    XLAT(0x128, "OpMov0f28");
    XLAT(0x129, "OpMovWpsVps");
    XLAT(0x12A, "OpCvt0f2a");
    XLAT(0x12B, "OpMov0f2b");
    XLAT(0x12C, "OpCvtt0f2c");
    XLAT(0x12D, "OpCvt0f2d");
    XLAT(0x12E, "OpComissVsWs");
    XLAT(0x12F, "OpComissVsWs");
    XLAT(0x130, "OpWrmsr");
    XLAT(0x131, "OpRdtsc");
    XLAT(0x132, "OpRdmsr");
    XLAT(0x133, "OpUd");
    XLAT(0x134, "OpUd");
    XLAT(0x135, "OpUd");
    XLAT(0x136, "OpUd");
    XLAT(0x137, "OpUd");
    XLAT(0x138, "OpUd");
    XLAT(0x139, "OpUd");
    XLAT(0x13A, "OpUd");
    XLAT(0x13B, "OpUd");
    XLAT(0x13C, "OpUd");
    XLAT(0x13D, "OpUd");
    XLAT(0x13E, "OpUd");
    XLAT(0x13F, "OpUd");
    XLAT(0x140, "OpCmovo");
    XLAT(0x141, "OpCmovno");
    XLAT(0x142, "OpCmovb");
    XLAT(0x143, "OpCmovae");
    XLAT(0x144, "OpCmove");
    XLAT(0x145, "OpCmovne");
    XLAT(0x146, "OpCmovbe");
    XLAT(0x147, "OpCmova");
    XLAT(0x148, "OpCmovs");
    XLAT(0x149, "OpCmovns");
    XLAT(0x14A, "OpCmovp");
    XLAT(0x14B, "OpCmovnp");
    XLAT(0x14C, "OpCmovl");
    XLAT(0x14D, "OpCmovge");
    XLAT(0x14E, "OpCmovle");
    XLAT(0x14F, "OpCmovg");
    XLAT(0x150, "OpMovmskpsd");
    XLAT(0x151, "OpSqrtpsd");
    XLAT(0x152, "OpRsqrtps");
    XLAT(0x153, "OpRcpps");
    XLAT(0x154, "OpAndpsd");
    XLAT(0x155, "OpAndnpsd");
    XLAT(0x156, "OpOrpsd");
    XLAT(0x157, "OpXorpsd");
    XLAT(0x158, "OpAddpsd");
    XLAT(0x159, "OpMulpsd");
    XLAT(0x15A, "OpCvt0f5a");
    XLAT(0x15B, "OpCvt0f5b");
    XLAT(0x15C, "OpSubpsd");
    XLAT(0x15D, "OpMinpsd");
    XLAT(0x15E, "OpDivpsd");
    XLAT(0x15F, "OpMaxpsd");
    XLAT(0x160, "OpSsePunpcklbw");
    XLAT(0x161, "OpSsePunpcklwd");
    XLAT(0x162, "OpSsePunpckldq");
    XLAT(0x163, "OpSsePacksswb");
    XLAT(0x164, "OpSsePcmpgtb");
    XLAT(0x165, "OpSsePcmpgtw");
    XLAT(0x166, "OpSsePcmpgtd");
    XLAT(0x167, "OpSsePackuswb");
    XLAT(0x168, "OpSsePunpckhbw");
    XLAT(0x169, "OpSsePunpckhwd");
    XLAT(0x16A, "OpSsePunpckhdq");
    XLAT(0x16B, "OpSsePackssdw");
    XLAT(0x16C, "OpSsePunpcklqdq");
    XLAT(0x16D, "OpSsePunpckhqdq");
    XLAT(0x16E, "OpMov0f6e");
    XLAT(0x16F, "OpMov0f6f");
    XLAT(0x170, "OpShuffle");
    XLAT(0x171, "Op171");
    XLAT(0x172, "Op172");
    XLAT(0x173, "Op173");
    XLAT(0x174, "OpSsePcmpeqb");
    XLAT(0x175, "OpSsePcmpeqw");
    XLAT(0x176, "OpSsePcmpeqd");
    XLAT(0x177, "OpEmms");
    XLAT(0x178, "OpUd");
    XLAT(0x179, "OpUd");
    XLAT(0x17A, "OpUd");
    XLAT(0x17B, "OpUd");
    XLAT(0x17C, "OpHaddpsd");
    XLAT(0x17D, "OpHsubpsd");
    XLAT(0x17E, "OpMov0f7e");
    XLAT(0x17F, "OpMov0f7f");
    XLAT(0x180, "OpJo");
    XLAT(0x181, "OpJno");
    XLAT(0x182, "OpJb");
    XLAT(0x183, "OpJae");
    XLAT(0x184, "OpJe");
    XLAT(0x185, "OpJne");
    XLAT(0x186, "OpJbe");
    XLAT(0x187, "OpJa");
    XLAT(0x188, "OpJs");
    XLAT(0x189, "OpJns");
    XLAT(0x18A, "OpJp");
    XLAT(0x18B, "OpJnp");
    XLAT(0x18C, "OpJl");
    XLAT(0x18D, "OpJge");
    XLAT(0x18E, "OpJle");
    XLAT(0x18F, "OpJg");
    XLAT(0x190, "OpSeto");
    XLAT(0x191, "OpSetno");
    XLAT(0x192, "OpSetb");
    XLAT(0x193, "OpSetae");
    XLAT(0x194, "OpSete");
    XLAT(0x195, "OpSetne");
    XLAT(0x196, "OpSetbe");
    XLAT(0x197, "OpSeta");
    XLAT(0x198, "OpSets");
    XLAT(0x199, "OpSetns");
    XLAT(0x19A, "OpSetp");
    XLAT(0x19B, "OpSetnp");
    XLAT(0x19C, "OpSetl");
    XLAT(0x19D, "OpSetge");
    XLAT(0x19E, "OpSetle");
    XLAT(0x19F, "OpSetg");
    XLAT(0x1A0, "OpPushSeg");
    XLAT(0x1A1, "OpPopSeg");
    XLAT(0x1A2, "OpCpuid");
    XLAT(0x1A3, "OpBit");
    XLAT(0x1A4, "OpDoubleShift");
    XLAT(0x1A5, "OpDoubleShift");
    XLAT(0x1A6, "OpUd");
    XLAT(0x1A7, "OpUd");
    XLAT(0x1A8, "OpPushSeg");
    XLAT(0x1A9, "OpPopSeg");
    XLAT(0x1AA, "OpUd");
    XLAT(0x1AB, "OpBit");
    XLAT(0x1AC, "OpDoubleShift");
    XLAT(0x1AD, "OpDoubleShift");
    XLAT(0x1AE, "Op1ae");
    XLAT(0x1AF, "OpImulGvqpEvqp");
    XLAT(0x1B0, "OpCmpxchgEbAlGb");
    XLAT(0x1B1, "OpCmpxchgEvqpRaxGvqp");
    XLAT(0x1B2, "OpLss");
    XLAT(0x1B3, "OpBit");
    XLAT(0x1B4, "OpLfs");
    XLAT(0x1B5, "OpLgs");
    XLAT(0x1B6, "OpMovzbGvqpEb");
    XLAT(0x1B7, "OpMovzwGvqpEw");
    XLAT(0x1B8, "Op1b8");
    XLAT(0x1B9, "OpUd");
    XLAT(0x1BA, "OpBit");
    XLAT(0x1BB, "OpBit");
    XLAT(0x1BC, "OpBsf");
    XLAT(0x1BD, "OpBsr");
    XLAT(0x1BE, "OpMovsbGvqpEb");
    XLAT(0x1BF, "OpMovswGvqpEw");
    XLAT(0x1C0, "OpXaddEbGb");
    XLAT(0x1C1, "OpXaddEvqpGvqp");
    XLAT(0x1C2, "OpCmppsd");
    XLAT(0x1C3, "OpMovntiMdqpGdqp");
    XLAT(0x1C4, "OpPinsrwVdqEwIb");
    XLAT(0x1C5, "OpPextrwGdqpUdqIb");
    XLAT(0x1C6, "OpShufpsd");
    XLAT(0x1C7, "Op1c7");
    XLAT(0x1C8, "OpBswapZvqp");
    XLAT(0x1C9, "OpBswapZvqp");
    XLAT(0x1CA, "OpBswapZvqp");
    XLAT(0x1CB, "OpBswapZvqp");
    XLAT(0x1CC, "OpBswapZvqp");
    XLAT(0x1CD, "OpBswapZvqp");
    XLAT(0x1CE, "OpBswapZvqp");
    XLAT(0x1CF, "OpBswapZvqp");
    XLAT(0x1D0, "OpAddsubpsd");
    XLAT(0x1D1, "OpSsePsrlwv");
    XLAT(0x1D2, "OpSsePsrldv");
    XLAT(0x1D3, "OpSsePsrlqv");
    XLAT(0x1D4, "OpSsePaddq");
    XLAT(0x1D5, "OpSsePmullw");
    XLAT(0x1D6, "OpMov0fD6");
    XLAT(0x1D7, "OpPmovmskbGdqpNqUdq");
    XLAT(0x1D8, "OpSsePsubusb");
    XLAT(0x1D9, "OpSsePsubusw");
    XLAT(0x1DA, "OpSsePminub");
    XLAT(0x1DB, "OpSsePand");
    XLAT(0x1DC, "OpSsePaddusb");
    XLAT(0x1DD, "OpSsePaddusw");
    XLAT(0x1DE, "OpSsePmaxub");
    XLAT(0x1DF, "OpSsePandn");
    XLAT(0x1E0, "OpSsePavgb");
    XLAT(0x1E1, "OpSsePsrawv");
    XLAT(0x1E2, "OpSsePsradv");
    XLAT(0x1E3, "OpSsePavgw");
    XLAT(0x1E4, "OpSsePmulhuw");
    XLAT(0x1E5, "OpSsePmulhw");
    XLAT(0x1E6, "OpCvt0fE6");
    XLAT(0x1E7, "OpMov0fE7");
    XLAT(0x1E8, "OpSsePsubsb");
    XLAT(0x1E9, "OpSsePsubsw");
    XLAT(0x1EA, "OpSsePminsw");
    XLAT(0x1EB, "OpSsePor");
    XLAT(0x1EC, "OpSsePaddsb");
    XLAT(0x1ED, "OpSsePaddsw");
    XLAT(0x1EE, "OpSsePmaxsw");
    XLAT(0x1EF, "OpSsePxor");
    XLAT(0x1F0, "OpLddquVdqMdq");
    XLAT(0x1F1, "OpSsePsllwv");
    XLAT(0x1F2, "OpSsePslldv");
    XLAT(0x1F3, "OpSsePsllqv");
    XLAT(0x1F4, "OpSsePmuludq");
    XLAT(0x1F5, "OpSsePmaddwd");
    XLAT(0x1F6, "OpSsePsadbw");
    XLAT(0x1F7, "OpMaskMovDiXmmRegXmmRm");
    XLAT(0x1F8, "OpSsePsubb");
    XLAT(0x1F9, "OpSsePsubw");
    XLAT(0x1FA, "OpSsePsubd");
    XLAT(0x1FB, "OpSsePsubq");
    XLAT(0x1FC, "OpSsePaddb");
    XLAT(0x1FD, "OpSsePaddw");
    XLAT(0x1FE, "OpSsePaddd");
    XLAT(0x1FF, "OpUd");
    XLAT(0x200, "OpSsePshufb");
    XLAT(0x201, "OpSsePhaddw");
    XLAT(0x202, "OpSsePhaddd");
    XLAT(0x203, "OpSsePhaddsw");
    XLAT(0x204, "OpSsePmaddubsw");
    XLAT(0x205, "OpSsePhsubw");
    XLAT(0x206, "OpSsePhsubd");
    XLAT(0x207, "OpSsePhsubsw");
    XLAT(0x208, "OpSsePsignb");
    XLAT(0x209, "OpSsePsignw");
    XLAT(0x20A, "OpSsePsignd");
    XLAT(0x20B, "OpSsePmulhrsw");
    XLAT(0x21c, "OpSsePabsb");
    XLAT(0x21d, "OpSsePabsw");
    XLAT(0x21e, "OpSsePabsd");
    XLAT(0x22a, "OpMovntdqaVdqMdq");
    XLAT(0x240, "OpSsePmulld");
    XLAT(0x30f, "OpSsePalignr");
    XLAT(0x344, "OpSsePclmulqdq");
    default:
      return "UNKNOWN";
  }
}
