;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: wasm-opt %s -all --roundtrip -S -o - | filecheck %s

(module
 ;; CHECK:      (type $functype (func))
 (type $functype (func))

 ;; CHECK:      (table $table 48 funcref)
 (table $table 48 funcref)
 ;; CHECK:      (table $table64 i64 96 funcref)
 (table $table64 i64 96 funcref)

 ;; a type that appears in the table and nowhere else. this test checks that
 ;; we do not crash during the roundtrip on seeing an unexpected type that
 ;; collectHeapTypes() did not scan.
 (elem (table $table) (i32.const 0) funcref (ref.null $functype))

 ;; CHECK:      (elem $0 (table $table) (i32.const 0) funcref (item (ref.null nofunc)))

 ;; CHECK:      (func $set (type $functype)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i64.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (table.set $table64
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $set
  (table.set $table64
   (i64.const 0)
   (block (result funcref)
    ;; This unreachable code must not confuse the parser. Specifically the
    ;; index should not be replaced with the i32, which would not validate.
    (i32.lt_u
     (i32.const 0)
     (unreachable)
    )
    (ref.null nofunc)
   )
  )
 )
)

