;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.
;; NOTE: Test has been generated by scripts/test/gen-cast-test.py. Do not edit manually.

;; Exhaustively test optimization of all interesting casts.

;; RUN: wasm-opt %s -all                              --optimize-instructions -S -o - | filecheck %s
;; RUN: wasm-opt %s -all --disable-custom-descriptors --optimize-instructions -S -o - | filecheck %s --check-prefix=NO_CD

(module
  ;; CHECK:      (type $super (sub (struct)))
  ;; NO_CD:      (type $super (sub (struct)))
  (type $super (sub (struct)))
  ;; CHECK:      (type $sub (sub $super (struct)))
  ;; NO_CD:      (type $sub (sub $super (struct)))
  (type $sub (sub $super (struct)))
  ;; CHECK:      (type $sub-final (sub final $super (struct)))
  ;; NO_CD:      (type $sub-final (sub final $super (struct)))
  (type $sub-final (sub final $super (struct)))

  ;; CHECK:      (func $cast-to-self-nonfinal-null-exact-to-null-inexact (type $3) (param $0 (ref null (exact $super))) (result (ref null $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null (exact $super)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-nonfinal-null-exact-to-null-inexact (type $3) (param $0 (ref null (exact $super))) (result (ref null $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null (exact $super)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-nonfinal-null-exact-to-null-inexact (param (ref null (exact $super))) (result (ref null $super))
    (local anyref)
    (ref.cast (ref null $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-nonfinal-null-exact-to-non-null-inexact (type $4) (param $0 (ref null (exact $super))) (result (ref $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null (exact $super)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (ref.as_non_null
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-nonfinal-null-exact-to-non-null-inexact (type $4) (param $0 (ref null (exact $super))) (result (ref $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null (exact $super)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (ref.as_non_null
  ;; NO_CD-NEXT:   (local.get $2)
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-self-nonfinal-null-exact-to-non-null-inexact (param (ref null (exact $super))) (result (ref $super))
    (local anyref)
    (ref.cast (ref $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-nonfinal-null-inexact-to-null-inexact (type $5) (param $0 (ref null $super)) (result (ref null $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null $super))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-nonfinal-null-inexact-to-null-inexact (type $5) (param $0 (ref null $super)) (result (ref null $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null $super))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-nonfinal-null-inexact-to-null-inexact (param (ref null $super)) (result (ref null $super))
    (local anyref)
    (ref.cast (ref null $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-nonfinal-null-inexact-to-non-null-inexact (type $6) (param $0 (ref null $super)) (result (ref $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null $super))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (ref.as_non_null
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-nonfinal-null-inexact-to-non-null-inexact (type $6) (param $0 (ref null $super)) (result (ref $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null $super))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (ref.as_non_null
  ;; NO_CD-NEXT:   (local.get $2)
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-self-nonfinal-null-inexact-to-non-null-inexact (param (ref null $super)) (result (ref $super))
    (local anyref)
    (ref.cast (ref $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-nonfinal-non-null-exact-to-null-inexact (type $7) (param $0 (ref (exact $super))) (result (ref null $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref (exact $super)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-nonfinal-non-null-exact-to-null-inexact (type $7) (param $0 (ref (exact $super))) (result (ref null $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref (exact $super)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-nonfinal-non-null-exact-to-null-inexact (param (ref (exact $super))) (result (ref null $super))
    (local anyref)
    (ref.cast (ref null $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-nonfinal-non-null-exact-to-non-null-inexact (type $8) (param $0 (ref (exact $super))) (result (ref $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref (exact $super)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-nonfinal-non-null-exact-to-non-null-inexact (type $8) (param $0 (ref (exact $super))) (result (ref $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref (exact $super)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-nonfinal-non-null-exact-to-non-null-inexact (param (ref (exact $super))) (result (ref $super))
    (local anyref)
    (ref.cast (ref $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-nonfinal-non-null-inexact-to-null-inexact (type $9) (param $0 (ref $super)) (result (ref null $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref $super))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-nonfinal-non-null-inexact-to-null-inexact (type $9) (param $0 (ref $super)) (result (ref null $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref $super))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-nonfinal-non-null-inexact-to-null-inexact (param (ref $super)) (result (ref null $super))
    (local anyref)
    (ref.cast (ref null $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-nonfinal-non-null-inexact-to-non-null-inexact (type $10) (param $0 (ref $super)) (result (ref $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref $super))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-nonfinal-non-null-inexact-to-non-null-inexact (type $10) (param $0 (ref $super)) (result (ref $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref $super))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-nonfinal-non-null-inexact-to-non-null-inexact (param (ref $super)) (result (ref $super))
    (local anyref)
    (ref.cast (ref $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-final-null-exact-to-null-inexact (type $11) (param $0 (ref null (exact $sub-final))) (result (ref null $sub-final))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null (exact $sub-final)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-final-null-exact-to-null-inexact (type $11) (param $0 (ref null (exact $sub-final))) (result (ref null $sub-final))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null (exact $sub-final)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-final-null-exact-to-null-inexact (param (ref null (exact $sub-final))) (result (ref null $sub-final))
    (local anyref)
    (ref.cast (ref null $sub-final)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-final-null-exact-to-non-null-inexact (type $12) (param $0 (ref null (exact $sub-final))) (result (ref $sub-final))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null (exact $sub-final)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (ref.as_non_null
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-final-null-exact-to-non-null-inexact (type $12) (param $0 (ref null (exact $sub-final))) (result (ref $sub-final))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null (exact $sub-final)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (ref.as_non_null
  ;; NO_CD-NEXT:   (local.get $2)
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-self-final-null-exact-to-non-null-inexact (param (ref null (exact $sub-final))) (result (ref $sub-final))
    (local anyref)
    (ref.cast (ref $sub-final)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-final-null-inexact-to-null-inexact (type $13) (param $0 (ref null $sub-final)) (result (ref null $sub-final))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null $sub-final))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-final-null-inexact-to-null-inexact (type $13) (param $0 (ref null $sub-final)) (result (ref null $sub-final))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null $sub-final))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-final-null-inexact-to-null-inexact (param (ref null $sub-final)) (result (ref null $sub-final))
    (local anyref)
    (ref.cast (ref null $sub-final)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-final-null-inexact-to-non-null-inexact (type $14) (param $0 (ref null $sub-final)) (result (ref $sub-final))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null $sub-final))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (ref.as_non_null
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-final-null-inexact-to-non-null-inexact (type $14) (param $0 (ref null $sub-final)) (result (ref $sub-final))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null $sub-final))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (ref.as_non_null
  ;; NO_CD-NEXT:   (local.get $2)
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-self-final-null-inexact-to-non-null-inexact (param (ref null $sub-final)) (result (ref $sub-final))
    (local anyref)
    (ref.cast (ref $sub-final)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-final-non-null-exact-to-null-inexact (type $15) (param $0 (ref (exact $sub-final))) (result (ref null $sub-final))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref (exact $sub-final)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-final-non-null-exact-to-null-inexact (type $15) (param $0 (ref (exact $sub-final))) (result (ref null $sub-final))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref (exact $sub-final)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-final-non-null-exact-to-null-inexact (param (ref (exact $sub-final))) (result (ref null $sub-final))
    (local anyref)
    (ref.cast (ref null $sub-final)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-final-non-null-exact-to-non-null-inexact (type $16) (param $0 (ref (exact $sub-final))) (result (ref $sub-final))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref (exact $sub-final)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-final-non-null-exact-to-non-null-inexact (type $16) (param $0 (ref (exact $sub-final))) (result (ref $sub-final))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref (exact $sub-final)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-final-non-null-exact-to-non-null-inexact (param (ref (exact $sub-final))) (result (ref $sub-final))
    (local anyref)
    (ref.cast (ref $sub-final)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-final-non-null-inexact-to-null-inexact (type $17) (param $0 (ref $sub-final)) (result (ref null $sub-final))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref $sub-final))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-final-non-null-inexact-to-null-inexact (type $17) (param $0 (ref $sub-final)) (result (ref null $sub-final))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref $sub-final))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-final-non-null-inexact-to-null-inexact (param (ref $sub-final)) (result (ref null $sub-final))
    (local anyref)
    (ref.cast (ref null $sub-final)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-self-final-non-null-inexact-to-non-null-inexact (type $18) (param $0 (ref $sub-final)) (result (ref $sub-final))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref $sub-final))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-self-final-non-null-inexact-to-non-null-inexact (type $18) (param $0 (ref $sub-final)) (result (ref $sub-final))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref $sub-final))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-self-final-non-null-inexact-to-non-null-inexact (param (ref $sub-final)) (result (ref $sub-final))
    (local anyref)
    (ref.cast (ref $sub-final)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-super-null-exact-to-null-inexact (type $19) (param $0 (ref null (exact $sub))) (result (ref null $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null (exact $sub)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-super-null-exact-to-null-inexact (type $19) (param $0 (ref null (exact $sub))) (result (ref null $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null (exact $sub)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-super-null-exact-to-null-inexact (param (ref null (exact $sub))) (result (ref null $super))
    (local anyref)
    (ref.cast (ref null $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-super-null-exact-to-non-null-inexact (type $20) (param $0 (ref null (exact $sub))) (result (ref $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null (exact $sub)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (ref.as_non_null
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-super-null-exact-to-non-null-inexact (type $20) (param $0 (ref null (exact $sub))) (result (ref $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null (exact $sub)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (ref.as_non_null
  ;; NO_CD-NEXT:   (local.get $2)
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-super-null-exact-to-non-null-inexact (param (ref null (exact $sub))) (result (ref $super))
    (local anyref)
    (ref.cast (ref $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-super-null-inexact-to-null-inexact (type $21) (param $0 (ref null $sub)) (result (ref null $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null $sub))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-super-null-inexact-to-null-inexact (type $21) (param $0 (ref null $sub)) (result (ref null $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null $sub))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-super-null-inexact-to-null-inexact (param (ref null $sub)) (result (ref null $super))
    (local anyref)
    (ref.cast (ref null $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-super-null-inexact-to-non-null-inexact (type $22) (param $0 (ref null $sub)) (result (ref $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref null $sub))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (ref.as_non_null
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-super-null-inexact-to-non-null-inexact (type $22) (param $0 (ref null $sub)) (result (ref $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref null $sub))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (ref.as_non_null
  ;; NO_CD-NEXT:   (local.get $2)
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-super-null-inexact-to-non-null-inexact (param (ref null $sub)) (result (ref $super))
    (local anyref)
    (ref.cast (ref $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-super-non-null-exact-to-null-inexact (type $23) (param $0 (ref (exact $sub))) (result (ref null $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref (exact $sub)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-super-non-null-exact-to-null-inexact (type $23) (param $0 (ref (exact $sub))) (result (ref null $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref (exact $sub)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-super-non-null-exact-to-null-inexact (param (ref (exact $sub))) (result (ref null $super))
    (local anyref)
    (ref.cast (ref null $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-super-non-null-exact-to-non-null-inexact (type $24) (param $0 (ref (exact $sub))) (result (ref $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref (exact $sub)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-super-non-null-exact-to-non-null-inexact (type $24) (param $0 (ref (exact $sub))) (result (ref $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref (exact $sub)))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-super-non-null-exact-to-non-null-inexact (param (ref (exact $sub))) (result (ref $super))
    (local anyref)
    (ref.cast (ref $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-super-non-null-inexact-to-null-inexact (type $25) (param $0 (ref $sub)) (result (ref null $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref $sub))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-super-non-null-inexact-to-null-inexact (type $25) (param $0 (ref $sub)) (result (ref null $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref $sub))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-super-non-null-inexact-to-null-inexact (param (ref $sub)) (result (ref null $super))
    (local anyref)
    (ref.cast (ref null $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-super-non-null-inexact-to-non-null-inexact (type $26) (param $0 (ref $sub)) (result (ref $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (local $2 (ref $sub))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.tee $2
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $2)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-super-non-null-inexact-to-non-null-inexact (type $26) (param $0 (ref $sub)) (result (ref $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (local $2 (ref $sub))
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.tee $2
  ;; NO_CD-NEXT:     (local.get $0)
  ;; NO_CD-NEXT:    )
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (local.get $2)
  ;; NO_CD-NEXT: )
  (func $cast-to-super-non-null-inexact-to-non-null-inexact (param (ref $sub)) (result (ref $super))
    (local anyref)
    (ref.cast (ref $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sub-null-exact-to-null-inexact (type $27) (param $0 (ref null (exact $super))) (result (ref null $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (ref.cast nullref
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sub-null-exact-to-null-inexact (type $27) (param $0 (ref null (exact $super))) (result (ref null $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (ref.cast nullref
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-sub-null-exact-to-null-inexact (param (ref null (exact $super))) (result (ref null $sub))
    (local anyref)
    (ref.cast (ref null $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sub-null-exact-to-non-null-inexact (type $28) (param $0 (ref null (exact $super))) (result (ref $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sub-null-exact-to-non-null-inexact (type $28) (param $0 (ref null (exact $super))) (result (ref $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-sub-null-exact-to-non-null-inexact (param (ref null (exact $super))) (result (ref $sub))
    (local anyref)
    (ref.cast (ref $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sub-null-inexact-to-null-inexact (type $29) (param $0 (ref null $super)) (result (ref null $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (ref.cast (ref null $sub)
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sub-null-inexact-to-null-inexact (type $29) (param $0 (ref null $super)) (result (ref null $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (ref.cast (ref null $sub)
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-sub-null-inexact-to-null-inexact (param (ref null $super)) (result (ref null $sub))
    (local anyref)
    (ref.cast (ref null $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sub-null-inexact-to-non-null-inexact (type $30) (param $0 (ref null $super)) (result (ref $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (ref.cast (ref $sub)
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sub-null-inexact-to-non-null-inexact (type $30) (param $0 (ref null $super)) (result (ref $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (ref.cast (ref $sub)
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-sub-null-inexact-to-non-null-inexact (param (ref null $super)) (result (ref $sub))
    (local anyref)
    (ref.cast (ref $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sub-non-null-exact-to-null-inexact (type $31) (param $0 (ref (exact $super))) (result (ref null $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sub-non-null-exact-to-null-inexact (type $31) (param $0 (ref (exact $super))) (result (ref null $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-sub-non-null-exact-to-null-inexact (param (ref (exact $super))) (result (ref null $sub))
    (local anyref)
    (ref.cast (ref null $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sub-non-null-exact-to-non-null-inexact (type $32) (param $0 (ref (exact $super))) (result (ref $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sub-non-null-exact-to-non-null-inexact (type $32) (param $0 (ref (exact $super))) (result (ref $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-sub-non-null-exact-to-non-null-inexact (param (ref (exact $super))) (result (ref $sub))
    (local anyref)
    (ref.cast (ref $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sub-non-null-inexact-to-null-inexact (type $33) (param $0 (ref $super)) (result (ref null $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (ref.cast (ref $sub)
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sub-non-null-inexact-to-null-inexact (type $33) (param $0 (ref $super)) (result (ref null $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (ref.cast (ref $sub)
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-sub-non-null-inexact-to-null-inexact (param (ref $super)) (result (ref null $sub))
    (local anyref)
    (ref.cast (ref null $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sub-non-null-inexact-to-non-null-inexact (type $34) (param $0 (ref $super)) (result (ref $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (ref.cast (ref $sub)
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sub-non-null-inexact-to-non-null-inexact (type $34) (param $0 (ref $super)) (result (ref $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (ref.cast (ref $sub)
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-sub-non-null-inexact-to-non-null-inexact (param (ref $super)) (result (ref $sub))
    (local anyref)
    (ref.cast (ref $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sibling-null-exact-to-null-inexact (type $35) (param $0 (ref null (exact $sub-final))) (result (ref null $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (ref.cast nullref
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sibling-null-exact-to-null-inexact (type $35) (param $0 (ref null (exact $sub-final))) (result (ref null $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (ref.cast nullref
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-sibling-null-exact-to-null-inexact (param (ref null (exact $sub-final))) (result (ref null $sub))
    (local anyref)
    (ref.cast (ref null $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sibling-null-exact-to-non-null-inexact (type $36) (param $0 (ref null (exact $sub-final))) (result (ref $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sibling-null-exact-to-non-null-inexact (type $36) (param $0 (ref null (exact $sub-final))) (result (ref $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-sibling-null-exact-to-non-null-inexact (param (ref null (exact $sub-final))) (result (ref $sub))
    (local anyref)
    (ref.cast (ref $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sibling-null-inexact-to-null-inexact (type $37) (param $0 (ref null $sub-final)) (result (ref null $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (ref.cast nullref
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sibling-null-inexact-to-null-inexact (type $37) (param $0 (ref null $sub-final)) (result (ref null $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (ref.cast nullref
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-sibling-null-inexact-to-null-inexact (param (ref null $sub-final)) (result (ref null $sub))
    (local anyref)
    (ref.cast (ref null $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sibling-null-inexact-to-non-null-inexact (type $38) (param $0 (ref null $sub-final)) (result (ref $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sibling-null-inexact-to-non-null-inexact (type $38) (param $0 (ref null $sub-final)) (result (ref $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-sibling-null-inexact-to-non-null-inexact (param (ref null $sub-final)) (result (ref $sub))
    (local anyref)
    (ref.cast (ref $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sibling-non-null-exact-to-null-inexact (type $39) (param $0 (ref (exact $sub-final))) (result (ref null $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sibling-non-null-exact-to-null-inexact (type $39) (param $0 (ref (exact $sub-final))) (result (ref null $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-sibling-non-null-exact-to-null-inexact (param (ref (exact $sub-final))) (result (ref null $sub))
    (local anyref)
    (ref.cast (ref null $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sibling-non-null-exact-to-non-null-inexact (type $40) (param $0 (ref (exact $sub-final))) (result (ref $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sibling-non-null-exact-to-non-null-inexact (type $40) (param $0 (ref (exact $sub-final))) (result (ref $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-sibling-non-null-exact-to-non-null-inexact (param (ref (exact $sub-final))) (result (ref $sub))
    (local anyref)
    (ref.cast (ref $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sibling-non-null-inexact-to-null-inexact (type $41) (param $0 (ref $sub-final)) (result (ref null $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sibling-non-null-inexact-to-null-inexact (type $41) (param $0 (ref $sub-final)) (result (ref null $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-sibling-non-null-inexact-to-null-inexact (param (ref $sub-final)) (result (ref null $sub))
    (local anyref)
    (ref.cast (ref null $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-sibling-non-null-inexact-to-non-null-inexact (type $42) (param $0 (ref $sub-final)) (result (ref $sub))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-sibling-non-null-inexact-to-non-null-inexact (type $42) (param $0 (ref $sub-final)) (result (ref $sub))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-sibling-non-null-inexact-to-non-null-inexact (param (ref $sub-final)) (result (ref $sub))
    (local anyref)
    (ref.cast (ref $sub)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-bottom-null-exact-to-null-inexact (type $43) (param $0 (ref null (exact $super))) (result nullref)
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (ref.cast nullref
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-bottom-null-exact-to-null-inexact (type $43) (param $0 (ref null (exact $super))) (result nullref)
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (ref.cast nullref
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-bottom-null-exact-to-null-inexact (param (ref null (exact $super))) (result (ref null none))
    (local anyref)
    (ref.cast (ref null none)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-bottom-null-exact-to-non-null-inexact (type $44) (param $0 (ref null (exact $super))) (result (ref none))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-bottom-null-exact-to-non-null-inexact (type $44) (param $0 (ref null (exact $super))) (result (ref none))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-bottom-null-exact-to-non-null-inexact (param (ref null (exact $super))) (result (ref none))
    (local anyref)
    (ref.cast (ref none)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-bottom-null-inexact-to-null-inexact (type $45) (param $0 (ref null $super)) (result nullref)
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (ref.cast nullref
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-bottom-null-inexact-to-null-inexact (type $45) (param $0 (ref null $super)) (result nullref)
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (ref.cast nullref
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT: )
  (func $cast-to-bottom-null-inexact-to-null-inexact (param (ref null $super)) (result (ref null none))
    (local anyref)
    (ref.cast (ref null none)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-bottom-null-inexact-to-non-null-inexact (type $46) (param $0 (ref null $super)) (result (ref none))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-bottom-null-inexact-to-non-null-inexact (type $46) (param $0 (ref null $super)) (result (ref none))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-bottom-null-inexact-to-non-null-inexact (param (ref null $super)) (result (ref none))
    (local anyref)
    (ref.cast (ref none)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-bottom-non-null-exact-to-null-inexact (type $47) (param $0 (ref (exact $super))) (result nullref)
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-bottom-non-null-exact-to-null-inexact (type $47) (param $0 (ref (exact $super))) (result nullref)
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-bottom-non-null-exact-to-null-inexact (param (ref (exact $super))) (result (ref null none))
    (local anyref)
    (ref.cast (ref null none)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-bottom-non-null-exact-to-non-null-inexact (type $48) (param $0 (ref (exact $super))) (result (ref none))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-bottom-non-null-exact-to-non-null-inexact (type $48) (param $0 (ref (exact $super))) (result (ref none))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-bottom-non-null-exact-to-non-null-inexact (param (ref (exact $super))) (result (ref none))
    (local anyref)
    (ref.cast (ref none)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-bottom-non-null-inexact-to-null-inexact (type $49) (param $0 (ref $super)) (result nullref)
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-bottom-non-null-inexact-to-null-inexact (type $49) (param $0 (ref $super)) (result nullref)
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-bottom-non-null-inexact-to-null-inexact (param (ref $super)) (result (ref null none))
    (local anyref)
    (ref.cast (ref null none)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-to-bottom-non-null-inexact-to-non-null-inexact (type $50) (param $0 (ref $super)) (result (ref none))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-to-bottom-non-null-inexact-to-non-null-inexact (type $50) (param $0 (ref $super)) (result (ref none))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-to-bottom-non-null-inexact-to-non-null-inexact (param (ref $super)) (result (ref none))
    (local anyref)
    (ref.cast (ref none)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-from-bottom-null-inexact-to-null-inexact (type $51) (param $0 nullref) (result (ref null $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (ref.null none)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-from-bottom-null-inexact-to-null-inexact (type $51) (param $0 nullref) (result (ref null $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (ref.null none)
  ;; NO_CD-NEXT: )
  (func $cast-from-bottom-null-inexact-to-null-inexact (param (ref null none)) (result (ref null $super))
    (local anyref)
    (ref.cast (ref null $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-from-bottom-null-inexact-to-non-null-inexact (type $52) (param $0 nullref) (result (ref $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-from-bottom-null-inexact-to-non-null-inexact (type $52) (param $0 nullref) (result (ref $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-from-bottom-null-inexact-to-non-null-inexact (param (ref null none)) (result (ref $super))
    (local anyref)
    (ref.cast (ref $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-from-bottom-non-null-inexact-to-null-inexact (type $53) (param $0 (ref none)) (result (ref null $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-from-bottom-non-null-inexact-to-null-inexact (type $53) (param $0 (ref none)) (result (ref null $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-from-bottom-non-null-inexact-to-null-inexact (param (ref none)) (result (ref null $super))
    (local anyref)
    (ref.cast (ref null $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $cast-from-bottom-non-null-inexact-to-non-null-inexact (type $54) (param $0 (ref none)) (result (ref $super))
  ;; CHECK-NEXT:  (local $1 anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.tee $1
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  ;; NO_CD:      (func $cast-from-bottom-non-null-inexact-to-non-null-inexact (type $54) (param $0 (ref none)) (result (ref $super))
  ;; NO_CD-NEXT:  (local $1 anyref)
  ;; NO_CD-NEXT:  (drop
  ;; NO_CD-NEXT:   (local.tee $1
  ;; NO_CD-NEXT:    (local.get $0)
  ;; NO_CD-NEXT:   )
  ;; NO_CD-NEXT:  )
  ;; NO_CD-NEXT:  (unreachable)
  ;; NO_CD-NEXT: )
  (func $cast-from-bottom-non-null-inexact-to-non-null-inexact (param (ref none)) (result (ref $super))
    (local anyref)
    (ref.cast (ref $super)
      (local.tee 1
        (local.get 0)
      )
    )
  )
)
