/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.testing.junit.testparameterinjector.AutoValue_TestInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@AutoValue
abstract class TestInfo {
    static final int MAX_TEST_NAME_LENGTH = 200;

    TestInfo() {
    }

    public abstract Method getMethod();

    public abstract String getName();

    public abstract ImmutableList<Annotation> getAnnotations();

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }

    private TestInfo withName(String otherName) {
        return TestInfo.create(this.getMethod(), otherName, this.getAnnotations());
    }

    public static TestInfo create(Method method, String name, List<Annotation> annotations) {
        return new AutoValue_TestInfo(method, name, (ImmutableList<Annotation>)ImmutableList.copyOf(annotations));
    }

    static ImmutableList<TestInfo> shortenNamesIfNecessary(List<TestInfo> testInfos, Function<TestInfo, String> shorterNameFunction) {
        if (testInfos.stream().anyMatch(i -> i.getName().length() > 200)) {
            return ImmutableList.copyOf((Collection)testInfos.stream().map(testInfo -> testInfo.withName((String)shorterNameFunction.apply((TestInfo)testInfo))).collect(Collectors.toList()));
        }
        return ImmutableList.copyOf(testInfos);
    }
}

