/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.testing.junit.testparameterinjector.AutoAnnotation_ParameterizedTestMethodProcessor_TestIndexHolderFactory_create;
import com.google.testing.junit.testparameterinjector.TestInfo;
import com.google.testing.junit.testparameterinjector.TestMethodProcessor;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

class ParameterizedTestMethodProcessor
implements TestMethodProcessor {
    private final Optional<Iterable<?>> parametersForAllTests;
    private final Optional<String> testNamePattern;

    ParameterizedTestMethodProcessor(TestClass testClass) {
        Optional<FrameworkMethod> parametersMethod = this.getParametersMethod(testClass);
        if (parametersMethod.isPresent()) {
            Object parameters;
            try {
                parameters = ((FrameworkMethod)parametersMethod.get()).invokeExplosively(null, new Object[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            if (parameters instanceof Iterable) {
                this.parametersForAllTests = Optional.of((Object)((Iterable)parameters));
            } else if (parameters instanceof Object[]) {
                this.parametersForAllTests = Optional.of((Object)ImmutableList.copyOf((Object[])((Object[])parameters)));
            } else {
                throw new IllegalStateException("Unsupported @Parameters return value type: " + parameters.getClass());
            }
            this.testNamePattern = Optional.of((Object)((Parameterized.Parameters)((FrameworkMethod)parametersMethod.get()).getAnnotation(Parameterized.Parameters.class)).name());
        } else {
            this.parametersForAllTests = Optional.absent();
            this.testNamePattern = Optional.absent();
        }
    }

    @Override
    public TestMethodProcessor.ValidationResult validateConstructor(TestClass testClass, List<Throwable> list) {
        if (this.parametersForAllTests.isPresent()) {
            Object[] testParameters;
            if (testClass.getJavaClass().getConstructors().length != 1) {
                list.add(new IllegalStateException("Test class should have exactly one public constructor"));
                return TestMethodProcessor.ValidationResult.HANDLED;
            }
            Constructor constructor = testClass.getOnlyConstructor();
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != (testParameters = this.getTestParameters(0)).length) {
                list.add(new IllegalStateException("Mismatch constructor parameter count with values returned by the @Parameters method"));
                return TestMethodProcessor.ValidationResult.HANDLED;
            }
            for (int i = 0; i < testParameters.length; ++i) {
                if (parameterTypes[i].isAssignableFrom(testParameters[i].getClass())) continue;
                list.add(new IllegalStateException(String.format("Mismatch constructor parameter type %s with value returned by the @Parameters method: %s", parameterTypes[i], testParameters[i])));
            }
            return TestMethodProcessor.ValidationResult.HANDLED;
        }
        return TestMethodProcessor.ValidationResult.NOT_HANDLED;
    }

    @Override
    public TestMethodProcessor.ValidationResult validateTestMethod(TestClass testClass, FrameworkMethod testMethod, List<Throwable> errorsReturned) {
        return TestMethodProcessor.ValidationResult.NOT_HANDLED;
    }

    @Override
    public List<TestInfo> processTest(Class<?> testClass, TestInfo originalTest) {
        if (this.parametersForAllTests.isPresent()) {
            ImmutableList.Builder tests = ImmutableList.builder();
            int testIndex = 0;
            for (Object parameters : (Iterable)this.parametersForAllTests.get()) {
                Object[] parametersForOneTest = parameters instanceof Object[] ? (Object[])parameters : new Object[]{parameters};
                String namePattern = ((String)this.testNamePattern.get()).replace("{index}", Integer.toString(testIndex));
                String testName = MessageFormat.format(namePattern, parametersForOneTest);
                tests.add((Object)TestInfo.create(originalTest.getMethod(), originalTest.getName() + "[" + testName + "]", this.updateAnnotationList(originalTest, testIndex)));
                ++testIndex;
            }
            return tests.build();
        }
        return ImmutableList.of((Object)originalTest);
    }

    @Override
    public Statement processStatement(Statement originalStatement, Description finalTestDescription) {
        return originalStatement;
    }

    @Override
    public Optional<Object> createTest(TestClass testClass, FrameworkMethod method, Optional<Object> test) {
        if (this.parametersForAllTests.isPresent()) {
            Object[] testParameters = this.getTestParameters(((TestIndexHolder)method.getAnnotation(TestIndexHolder.class)).testIndex());
            try {
                Constructor constructor = testClass.getOnlyConstructor();
                return Optional.of(constructor.newInstance(testParameters));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return test;
    }

    @Override
    public Optional<Statement> createStatement(TestClass testClass, FrameworkMethod method, Object testObject, Optional<Statement> statement) {
        return statement;
    }

    private ImmutableList<Annotation> updateAnnotationList(TestInfo originalTest, int testIndex) {
        TestIndexHolder parameterHolder = TestIndexHolderFactory.create(testIndex);
        return new ImmutableList.Builder().addAll(originalTest.getAnnotations()).add((Object)parameterHolder).build();
    }

    private Object[] getTestParameters(int testIndex) {
        Object parameters = Iterables.get((Iterable)((Iterable)this.parametersForAllTests.get()), (int)testIndex);
        if (parameters instanceof Object[]) {
            return (Object[])parameters;
        }
        return new Object[]{parameters};
    }

    private Optional<FrameworkMethod> getParametersMethod(TestClass testClass) {
        List methods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        if (methods.isEmpty()) {
            return Optional.absent();
        }
        FrameworkMethod method = (FrameworkMethod)Iterables.getOnlyElement((Iterable)methods);
        Preconditions.checkState((method.isPublic() && method.isStatic() ? 1 : 0) != 0, (String)"@Parameters method %s should be static and public", (Object)method.getName());
        return Optional.of((Object)method);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestIndexHolder {
        public int testIndex();
    }

    static class TestIndexHolderFactory {
        static TestIndexHolder create(int testIndex) {
            return new AutoAnnotation_ParameterizedTestMethodProcessor_TestIndexHolderFactory_create(testIndex);
        }

        private TestIndexHolderFactory() {
        }
    }
}

