/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_43a39aa.core.internal.analysis;

import org.jacoco.agent.rt.internal_43a39aa.core.analysis.ICounter;

public abstract class CounterImpl
implements ICounter {
    private static final int SINGLETON_LIMIT = 30;
    private static final CounterImpl[][] SINGLETONS = new CounterImpl[31][];
    public static final CounterImpl COUNTER_0_0;
    public static final CounterImpl COUNTER_1_0;
    public static final CounterImpl COUNTER_0_1;
    protected int missed;
    protected int covered;

    public static CounterImpl getInstance(int missed, int covered) {
        if (missed <= 30 && covered <= 30) {
            return SINGLETONS[missed][covered];
        }
        return new Var(missed, covered);
    }

    public static CounterImpl getInstance(ICounter counter) {
        return CounterImpl.getInstance(counter.getMissedCount(), counter.getCoveredCount());
    }

    protected CounterImpl(int missed, int covered) {
        this.missed = missed;
        this.covered = covered;
    }

    public CounterImpl increment(ICounter counter) {
        return this.increment(counter.getMissedCount(), counter.getCoveredCount());
    }

    public abstract CounterImpl increment(int var1, int var2);

    @Override
    public double getValue(ICounter.CounterValue value) {
        switch (value) {
            case TOTALCOUNT: {
                return this.getTotalCount();
            }
            case MISSEDCOUNT: {
                return this.getMissedCount();
            }
            case COVEREDCOUNT: {
                return this.getCoveredCount();
            }
            case MISSEDRATIO: {
                return this.getMissedRatio();
            }
            case COVEREDRATIO: {
                return this.getCoveredRatio();
            }
        }
        throw new AssertionError((Object)value);
    }

    @Override
    public int getTotalCount() {
        return this.missed + this.covered;
    }

    @Override
    public int getCoveredCount() {
        return this.covered;
    }

    @Override
    public int getMissedCount() {
        return this.missed;
    }

    @Override
    public double getCoveredRatio() {
        return (double)this.covered / (double)(this.missed + this.covered);
    }

    @Override
    public double getMissedRatio() {
        return (double)this.missed / (double)(this.missed + this.covered);
    }

    @Override
    public int getStatus() {
        int status;
        int n = status = this.covered > 0 ? 2 : 0;
        if (this.missed > 0) {
            status |= 1;
        }
        return status;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ICounter) {
            ICounter that = (ICounter)obj;
            return this.missed == that.getMissedCount() && this.covered == that.getCoveredCount();
        }
        return false;
    }

    public int hashCode() {
        return this.missed ^ this.covered * 17;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Counter[");
        b.append(this.getMissedCount());
        b.append('/').append(this.getCoveredCount());
        b.append(']');
        return b.toString();
    }

    static {
        for (int i = 0; i <= 30; ++i) {
            CounterImpl.SINGLETONS[i] = new CounterImpl[31];
            for (int j = 0; j <= 30; ++j) {
                CounterImpl.SINGLETONS[i][j] = new Fix(i, j);
            }
        }
        COUNTER_0_0 = SINGLETONS[0][0];
        COUNTER_1_0 = SINGLETONS[1][0];
        COUNTER_0_1 = SINGLETONS[0][1];
    }

    private static class Fix
    extends CounterImpl {
        public Fix(int missed, int covered) {
            super(missed, covered);
        }

        @Override
        public CounterImpl increment(int missed, int covered) {
            return Fix.getInstance(this.missed + missed, this.covered + covered);
        }
    }

    private static class Var
    extends CounterImpl {
        public Var(int missed, int covered) {
            super(missed, covered);
        }

        @Override
        public CounterImpl increment(int missed, int covered) {
            this.missed += missed;
            this.covered += covered;
            return this;
        }
    }
}

