/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessUtils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;

@BugPattern(summary="Field is assigned (or compared against) a definitely null value but is not annotated @Nullable", severity=BugPattern.SeverityLevel.SUGGESTION)
public class FieldMissingNullable
extends BugChecker
implements BugChecker.BinaryTreeMatcher,
BugChecker.AssignmentTreeMatcher,
BugChecker.VariableTreeMatcher {
    private final boolean beingConservative;

    @Inject
    FieldMissingNullable(ErrorProneFlags flags) {
        this.beingConservative = NullnessUtils.nullnessChecksShouldBeConservative(flags);
    }

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (this.beingConservative) {
            return Description.NO_MATCH;
        }
        NullnessUtils.NullCheck nullCheck = NullnessUtils.getNullCheck(tree);
        if (nullCheck == null) {
            return Description.NO_MATCH;
        }
        return this.matchIfLocallyDeclaredReferenceFieldWithoutNullable(nullCheck.varSymbolButUsuallyPreferBareIdentifier(), tree, state);
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        return this.match(ASTHelpers.getSymbol((Tree)tree.getVariable()), tree.getExpression(), state);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.match(ASTHelpers.getSymbol((VariableTree)tree), tree.getInitializer(), state);
    }

    private Description match(Symbol assigned, ExpressionTree expression, VisitorState state) {
        if (expression == null) {
            return Description.NO_MATCH;
        }
        ImmutableSet<Name> varsProvenNullByParentIf = NullnessUtils.varsProvenNullByParentIf(state.getPath().getParentPath());
        if (!NullnessUtils.hasDefinitelyNullBranch(expression, (Set<Symbol.VarSymbol>)ImmutableSet.of(), varsProvenNullByParentIf, state)) {
            return Description.NO_MATCH;
        }
        return this.matchIfLocallyDeclaredReferenceFieldWithoutNullable(assigned, expression, state);
    }

    private Description matchIfLocallyDeclaredReferenceFieldWithoutNullable(Symbol assigned, ExpressionTree treeToReportOn, VisitorState state) {
        if (assigned == null || assigned.getKind() != ElementKind.FIELD || assigned.type.isPrimitive()) {
            return Description.NO_MATCH;
        }
        if (NullnessUtils.isAlreadyAnnotatedNullable(assigned)) {
            return Description.NO_MATCH;
        }
        VariableTree fieldDecl = NullnessUtils.findDeclaration(state, assigned);
        if (fieldDecl == null) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = NullnessUtils.fixByAddingNullableAnnotationToType(state, fieldDecl);
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(treeToReportOn, (Fix)fix);
    }
}

