/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeCompatibility;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.io.Serializable;
import java.util.stream.Stream;
import javax.inject.Inject;

@BugPattern(summary="Argument is not compatible with the subject's type.", severity=BugPattern.SeverityLevel.WARNING)
public class TruthIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> START_OF_ASSERTION = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClassAny(new String[]{"com.google.common.truth.Truth", "com.google.common.truth.Truth8"}).named("assertThat"), MethodMatchers.staticMethod().onClass("com.google.common.truth.extensions.proto.ProtoTruth").named("assertThat"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that")});
    private static final Matcher<ExpressionTree> IS_EQUAL_TO = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").namedAnyOf(new String[]{"isEqualTo", "isNotEqualTo"}), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.extensions.proto.ProtoFluentAssertion").namedAnyOf(new String[]{"isEqualTo", "isNotEqualTo"})});
    private static final Matcher<ExpressionTree> FLUENT_PROTO_CHAIN = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.extensions.proto.ProtoFluentAssertion"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.extensions.proto.ProtoSubject")});
    private static final Matcher<ExpressionTree> SCALAR_CONTAINS = MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"com.google.common.truth.IterableSubject", "com.google.common.truth.StreamSubject"}).namedAnyOf(new String[]{"contains", "containsExactly", "doesNotContain", "containsAnyOf", "containsNoneOf"});
    private static final Matcher<ExpressionTree> IS_ANY_OF = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").namedAnyOf(new String[]{"isAnyOf", "isNoneOf"});
    private static final Matcher<ExpressionTree> IS_IN = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").namedAnyOf(new String[]{"isIn", "isNotIn"});
    private static final Matcher<ExpressionTree> VECTOR_CONTAINS = MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"com.google.common.truth.IterableSubject", "com.google.common.truth.StreamSubject"}).namedAnyOf(new String[]{"containsExactlyElementsIn", "containsAnyIn", "containsAtLeastElementsIn", "containsNoneIn"}).withParameters("java.lang.Iterable", new String[0]);
    private static final Matcher<ExpressionTree> MAP_SCALAR_CONTAINS = MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"com.google.common.truth.MapSubject", "com.google.common.truth.MultimapSubject"}).namedAnyOf(new String[]{"containsEntry", "doesNotContainEntry", "containsExactly", "containsAtLeast"});
    private static final Matcher<ExpressionTree> MAP_SCALAR_KEYS = MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"com.google.common.truth.MapSubject", "com.google.common.truth.MultimapSubject"}).namedAnyOf(new String[]{"containsKey", "doesNotContainKey"});
    private static final Matcher<ExpressionTree> MAP_VECTOR_CONTAINS = MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"com.google.common.truth.MapSubject", "com.google.common.truth.MultimapSubject"}).namedAnyOf(new String[]{"containsExactlyEntriesIn", "containsAtLeastEntriesIn"});
    private static final Matcher<ExpressionTree> COMPARING_ELEMENTS_USING = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.IterableSubject").named("comparingElementsUsing");
    private static final Matcher<ExpressionTree> ARRAY_CONTAINS = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.IterableSubject").namedAnyOf(new String[]{"containsExactlyElementsIn", "containsAnyIn", "containsAtLeastElementsIn", "containsNoneIn"}), Matchers.not(VECTOR_CONTAINS)});
    private static final Supplier<Type> CORRESPONDENCE = Suppliers.typeFromString((String)"com.google.common.truth.Correspondence");
    private final TypeCompatibility typeCompatibility;
    private final boolean flagMoreCases;
    private static final Supplier<Type> JAVA_LANG_NUMBER = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.Number"));

    @Inject
    TruthIncompatibleType(TypeCompatibility typeCompatibility, ErrorProneFlags flags) {
        this.typeCompatibility = typeCompatibility;
        this.flagMoreCases = flags.getBoolean("TruthIncompatibleType:FlagMoreCases").orElse(true);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Streams.concat((Stream[])new Stream[]{this.matchEquality(tree, state), this.matchIsAnyOf(tree, state), this.matchIsIn(tree, state), this.matchVectorContains(tree, state), this.matchArrayContains(tree, state), this.matchScalarContains(tree, state), this.matchCorrespondence(tree, state), this.matchMapVectorContains(tree, state), this.matchMapScalarContains(tree, state), this.matchMapContainsKey(tree, state)}).forEach(arg_0 -> ((VisitorState)state).reportMatch(arg_0));
        return Description.NO_MATCH;
    }

    private Stream<Description> matchEquality(MethodInvocationTree tree, VisitorState state) {
        if (!IS_EQUAL_TO.matches((Tree)tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        while (true) {
            if (!(receiver instanceof MethodInvocationTree)) {
                return Stream.empty();
            }
            if (START_OF_ASSERTION.matches((Tree)receiver, state)) break;
            if (!FLUENT_PROTO_CHAIN.matches((Tree)receiver, state)) {
                return Stream.empty();
            }
            receiver = ASTHelpers.getReceiver((ExpressionTree)receiver);
        }
        Type targetType = ASTHelpers.getType((Tree)this.ignoringCasts((Tree)Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments())));
        Type sourceType = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments())));
        if (TruthIncompatibleType.isNumericType(sourceType, state) && TruthIncompatibleType.isNumericType(targetType, state)) {
            return Stream.of(new Description[0]);
        }
        return this.checkCompatibility((ExpressionTree)Iterables.getOnlyElement(tree.getArguments()), targetType, sourceType, state);
    }

    private Stream<Description> matchIsAnyOf(MethodInvocationTree tree, VisitorState state) {
        if (!this.flagMoreCases || !IS_ANY_OF.matches((Tree)tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!START_OF_ASSERTION.matches((Tree)receiver, state)) {
            return Stream.empty();
        }
        Type targetType = ASTHelpers.getType((Tree)this.ignoringCasts((Tree)Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments())));
        return this.matchScalarContains(tree, targetType, state);
    }

    private Stream<Description> matchIsIn(MethodInvocationTree tree, VisitorState state) {
        if (!this.flagMoreCases || !IS_IN.matches((Tree)tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!START_OF_ASSERTION.matches((Tree)receiver, state)) {
            return Stream.empty();
        }
        Type targetType = ASTHelpers.getType((Tree)this.ignoringCasts((Tree)Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments())));
        Type sourceType = TruthIncompatibleType.getIterableTypeArg(ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments()))), (Tree)Iterables.getOnlyElement(tree.getArguments()), state);
        return this.checkCompatibility((ExpressionTree)Iterables.getOnlyElement(tree.getArguments()), targetType, sourceType, state);
    }

    private Stream<Description> matchVectorContains(MethodInvocationTree tree, VisitorState state) {
        if (!VECTOR_CONTAINS.matches((Tree)tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!START_OF_ASSERTION.matches((Tree)receiver, state)) {
            return Stream.empty();
        }
        Type targetType = TruthIncompatibleType.getIterableTypeArg(((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type, this.ignoringCasts((Tree)Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments())), state);
        Type sourceType = TruthIncompatibleType.getIterableTypeArg(((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type, (Tree)Iterables.getOnlyElement(tree.getArguments()), state);
        return this.checkCompatibility((ExpressionTree)Iterables.getOnlyElement(tree.getArguments()), targetType, sourceType, state);
    }

    private Stream<Description> matchArrayContains(MethodInvocationTree tree, VisitorState state) {
        if (!ARRAY_CONTAINS.matches((Tree)tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!START_OF_ASSERTION.matches((Tree)receiver, state)) {
            return Stream.empty();
        }
        Type targetType = TruthIncompatibleType.getIterableTypeArg(((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type, this.ignoringCasts((Tree)Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments())), state);
        Type sourceType = ((Type.ArrayType)ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments())))).elemtype;
        return this.checkCompatibility((ExpressionTree)Iterables.getOnlyElement(tree.getArguments()), targetType, sourceType, state);
    }

    private Stream<Description> matchScalarContains(MethodInvocationTree tree, VisitorState state) {
        if (!SCALAR_CONTAINS.matches((Tree)tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!START_OF_ASSERTION.matches((Tree)receiver, state)) {
            return Stream.empty();
        }
        Type targetType = TruthIncompatibleType.getIterableTypeArg(((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type, this.ignoringCasts((Tree)Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments())), state);
        return this.matchScalarContains(tree, targetType, state);
    }

    private Stream<Description> matchScalarContains(MethodInvocationTree tree, Type targetType, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        return Streams.mapWithIndex(tree.getArguments().stream(), (arg, index) -> {
            Type argumentType = ASTHelpers.getType((Tree)arg);
            return TruthIncompatibleType.isNonVarargsCall(methodSymbol, index, argumentType) ? this.checkCompatibility((ExpressionTree)arg, targetType, ((Type.ArrayType)argumentType).elemtype, state) : this.checkCompatibility((ExpressionTree)arg, targetType, argumentType, state);
        }).flatMap(x -> x);
    }

    private Stream<Description> matchCorrespondence(MethodInvocationTree tree, VisitorState state) {
        String targetTypeName;
        if (!COMPARING_ELEMENTS_USING.matches((Tree)tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!START_OF_ASSERTION.matches((Tree)receiver, state)) {
            return Stream.empty();
        }
        Type targetType = TruthIncompatibleType.getIterableTypeArg(((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type, this.ignoringCasts((Tree)Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments())), state);
        if (targetType == null) {
            return Stream.empty();
        }
        ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        Type sourceType = TruthIncompatibleType.getCorrespondenceTypeArg(argument, state);
        if (sourceType == null || ASTHelpers.isCastable((Type)targetType, (Type)sourceType, (VisitorState)state)) {
            return Stream.empty();
        }
        String sourceTypeName = Signatures.prettyType((Type)sourceType);
        if (sourceTypeName.equals(targetTypeName = Signatures.prettyType((Type)targetType))) {
            sourceTypeName = sourceType.toString();
            targetTypeName = targetType.toString();
        }
        return Stream.of(this.buildDescription(argument).setMessage(String.format("Argument '%s' should not be passed to this method: its type `%s` is not compatible with `%s`", state.getSourceForNode((Tree)argument), sourceTypeName, targetTypeName)).build());
    }

    private Stream<Description> matchMapVectorContains(MethodInvocationTree tree, VisitorState state) {
        if (!MAP_VECTOR_CONTAINS.matches((Tree)tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!START_OF_ASSERTION.matches((Tree)receiver, state)) {
            return Stream.empty();
        }
        ExpressionTree assertee = (ExpressionTree)Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments());
        Symbol.TypeSymbol assertionType = ((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type.tsym;
        Type targetKeyType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)this.ignoringCasts(assertee)), assertionType, 0, state.getTypes());
        Type targetValueType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)this.ignoringCasts(assertee)), assertionType, 1, state.getTypes());
        Type sourceKeyType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments()))), assertionType, 0, state.getTypes());
        Type sourceValueType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments()))), assertionType, 1, state.getTypes());
        return Stream.concat(this.checkCompatibility((ExpressionTree)Iterables.getOnlyElement(tree.getArguments()), targetKeyType, sourceKeyType, state), this.checkCompatibility((ExpressionTree)Iterables.getOnlyElement(tree.getArguments()), targetValueType, sourceValueType, state));
    }

    private Stream<Description> matchMapContainsKey(MethodInvocationTree tree, VisitorState state) {
        if (!MAP_SCALAR_KEYS.matches((Tree)tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!START_OF_ASSERTION.matches((Tree)receiver, state)) {
            return Stream.empty();
        }
        ExpressionTree assertee = (ExpressionTree)Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments());
        Symbol.TypeSymbol assertionType = ((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type.tsym;
        Type targetKeyType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)this.ignoringCasts(assertee)), assertionType, 0, state.getTypes());
        return this.checkCompatibility((ExpressionTree)Iterables.getOnlyElement(tree.getArguments()), targetKeyType, ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments()))), state);
    }

    private Stream<Description> matchMapScalarContains(MethodInvocationTree tree, VisitorState state) {
        if (!MAP_SCALAR_CONTAINS.matches((Tree)tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!START_OF_ASSERTION.matches((Tree)receiver, state)) {
            return Stream.empty();
        }
        ExpressionTree assertee = (ExpressionTree)Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments());
        Symbol.TypeSymbol assertionType = ((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type.tsym;
        Type targetKeyType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)this.ignoringCasts(assertee)), assertionType, 0, state.getTypes());
        Type targetValueType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)this.ignoringCasts(assertee)), assertionType, 1, state.getTypes());
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        return Streams.mapWithIndex(tree.getArguments().stream(), (arg, index) -> TruthIncompatibleType.isNonVarargsCall(methodSymbol, index, ASTHelpers.getType((Tree)arg)) ? Stream.empty() : this.checkCompatibility((ExpressionTree)arg, index % 2L == 0L ? targetKeyType : targetValueType, ASTHelpers.getType((Tree)arg), state)).flatMap(x -> x);
    }

    private static boolean isNonVarargsCall(Symbol.MethodSymbol methodSymbol, long index, Type argumentType) {
        return (long)(((List)methodSymbol.getParameters()).size() - 1) == index && methodSymbol.isVarArgs() && argumentType instanceof Type.ArrayType && !((Type.ArrayType)argumentType).elemtype.isPrimitive();
    }

    private Stream<Description> checkCompatibility(ExpressionTree tree, Type targetType, Type sourceType, VisitorState state) {
        String targetTypeName;
        TypeCompatibility.TypeCompatibilityReport compatibilityReport = this.typeCompatibility.compatibilityOfTypes(targetType, sourceType, state);
        if (compatibilityReport.isCompatible()) {
            return Stream.empty();
        }
        String sourceTypeName = Signatures.prettyType((Type)sourceType);
        if (sourceTypeName.equals(targetTypeName = Signatures.prettyType((Type)targetType))) {
            sourceTypeName = sourceType.toString();
            targetTypeName = targetType.toString();
        }
        return Stream.of(this.buildDescription(tree).setMessage(String.format("Argument '%s' should not be passed to this method: its type `%s` is not compatible with `%s`" + compatibilityReport.extraReason(), state.getSourceForNode((Tree)tree), sourceTypeName, targetTypeName)).build());
    }

    private Tree ignoringCasts(Tree tree) {
        return tree.accept(new SimpleTreeVisitor<Tree, Void>(){

            @Override
            protected Tree defaultAction(Tree node, Void unused) {
                return node;
            }

            @Override
            public Tree visitTypeCast(TypeCastTree node, Void unused) {
                return ASTHelpers.getType((Tree)node).isPrimitive() ? node : node.getExpression().accept(this, null);
            }

            @Override
            public Tree visitParenthesized(ParenthesizedTree node, Void unused) {
                return node.getExpression().accept(this, null);
            }
        }, null);
    }

    private static Type getIterableTypeArg(Type type, Tree onlyElement, VisitorState state) {
        return AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)onlyElement), type.tsym, 0, state.getTypes());
    }

    private static Type getCorrespondenceTypeArg(Tree onlyElement, VisitorState state) {
        return AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)onlyElement), ((Type)TruthIncompatibleType.CORRESPONDENCE.get((VisitorState)state)).tsym, 0, state.getTypes());
    }

    private static boolean isNumericType(Type parameter, VisitorState state) {
        return parameter.isNumeric() || ASTHelpers.isSubtype((Type)parameter, (Type)((Type)JAVA_LANG_NUMBER.get(state)), (VisitorState)state);
    }
}

