/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractBanUnsafeAPIChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.SerializableReads;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;
import java.io.Serializable;

@BugPattern(summary="Deserializing user input via the `Serializable` API is extremely dangerous", severity=BugPattern.SeverityLevel.ERROR)
public final class BanSerializableRead
extends AbstractBanUnsafeAPIChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> EXEMPT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf((String)"java.io.Serializable")), Matchers.enclosingMethod((Matcher)Matchers.methodIsNamed((String)"readObject"))}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf((String)"java.io.ObjectInputStream")), Matchers.enclosingMethod((Matcher & Serializable)(methodTree, state) -> SerializableReads.BANNED_OBJECT_INPUT_STREAM_METHODS.contains((Object)methodTree.getName().toString()))})});
    private static final Matcher<MethodInvocationTree> OBJECT_INPUT_STREAM_DESERIALIZE_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.io.ObjectInputStream").namedAnyOf(SerializableReads.BANNED_OBJECT_INPUT_STREAM_METHODS), Matchers.instanceMethod().onDescendantOf("java.io.Serializable").named("readObject"), Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.io.ObjectInput").named("readObject"), Matchers.instanceMethod().onDescendantOf("java.io.Externalizable").named("readExternal")}), Matchers.not((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingMethod((Matcher)Matchers.methodIsNamed((String)"readExternal")), Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf((String)"java.io.Externalizable"))}))})}), Matchers.not(EXEMPT)});
    private static final Matcher<MethodInvocationTree> MATCHER = OBJECT_INPUT_STREAM_DESERIALIZE_MATCHER;

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.matchHelper(tree, state, MATCHER);
    }
}

