/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.base.Preconditions;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.apply.Diff;
import com.google.errorprone.apply.ImportOrganizer;
import com.google.errorprone.apply.ImportStatements;
import com.google.errorprone.apply.SourceFile;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.fixes.Replacements;
import com.google.errorprone.matchers.Description;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class DescriptionBasedDiff
implements DescriptionListener,
Diff {
    private final String sourcePath;
    private final boolean ignoreOverlappingFixes;
    private final JCTree.JCCompilationUnit compilationUnit;
    private final Set<String> importsToAdd;
    private final Set<String> importsToRemove;
    private final EndPosTable endPositions;
    private final Replacements replacements = new Replacements();
    private final ImportOrganizer importOrganizer;

    public static DescriptionBasedDiff create(JCTree.JCCompilationUnit compilationUnit, ImportOrganizer importOrganizer) {
        return new DescriptionBasedDiff(compilationUnit, false, importOrganizer);
    }

    public static DescriptionBasedDiff createIgnoringOverlaps(JCTree.JCCompilationUnit compilationUnit, ImportOrganizer importOrganizer) {
        return new DescriptionBasedDiff(compilationUnit, true, importOrganizer);
    }

    private DescriptionBasedDiff(JCTree.JCCompilationUnit compilationUnit, boolean ignoreOverlappingFixes, ImportOrganizer importOrganizer) {
        this.compilationUnit = (JCTree.JCCompilationUnit)Preconditions.checkNotNull((Object)compilationUnit);
        URI sourceFileUri = compilationUnit.getSourceFile().toUri();
        this.sourcePath = sourceFileUri.isAbsolute() && Objects.equals(sourceFileUri.getScheme(), "file") ? Paths.get(sourceFileUri).toAbsolutePath().toString() : sourceFileUri.getPath();
        this.ignoreOverlappingFixes = ignoreOverlappingFixes;
        this.importsToAdd = new LinkedHashSet<String>();
        this.importsToRemove = new LinkedHashSet<String>();
        this.endPositions = compilationUnit.endPositions;
        this.importOrganizer = importOrganizer;
    }

    @Override
    public String getRelevantFileName() {
        return this.sourcePath;
    }

    public boolean isEmpty() {
        return this.importsToAdd.isEmpty() && this.importsToRemove.isEmpty() && this.replacements.isEmpty();
    }

    @Override
    public void onDescribed(Description description) {
        if (description.fixes.size() > 0) {
            this.handleFix((Fix)description.fixes.get(0));
        }
    }

    public void handleFix(Fix fix) {
        this.importsToAdd.addAll((Collection<String>)fix.getImportsToAdd());
        this.importsToRemove.addAll((Collection<String>)fix.getImportsToRemove());
        for (Replacement replacement : fix.getReplacements(this.endPositions)) {
            try {
                this.replacements.add(replacement, fix.getCoalescePolicy());
            }
            catch (IllegalArgumentException iae) {
                if (this.ignoreOverlappingFixes) continue;
                throw iae;
            }
        }
    }

    @Override
    public void applyDifferences(SourceFile sourceFile) {
        if (!this.importsToAdd.isEmpty() || !this.importsToRemove.isEmpty()) {
            ImportStatements importStatements = ImportStatements.create(this.compilationUnit, this.importOrganizer);
            importStatements.addAll(this.importsToAdd);
            importStatements.removeAll(this.importsToRemove);
            if (importStatements.importsHaveChanged()) {
                this.replacements.add(Replacement.create(importStatements.getStartPos(), importStatements.getEndPos(), importStatements.toString()), Replacements.CoalescePolicy.REPLACEMENT_FIRST);
            }
        }
        sourceFile.makeReplacements(this.replacements);
    }
}

