/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

class LambdaCodec
implements ObjectCodec<Serializable> {
    private final Method readResolveMethod;

    LambdaCodec() {
        try {
            this.readResolveMethod = SerializedLambda.class.getDeclaredMethod("readResolve", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        this.readResolveMethod.setAccessible(true);
    }

    static boolean isProbablyLambda(Class<?> type) {
        return type.isSynthetic() && !type.isLocalClass() && !type.isAnonymousClass();
    }

    @Override
    public Class<? extends Serializable> getEncodedClass() {
        return Serializable.class;
    }

    @Override
    public void serialize(SerializationContext context, Serializable obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        SerializedLambda serializedLambda;
        Method writeReplaceMethod;
        Class<?> objClass = obj.getClass();
        if (!LambdaCodec.isProbablyLambda(objClass)) {
            throw new SerializationException(String.valueOf(obj) + " is not a lambda: " + String.valueOf(objClass));
        }
        try {
            writeReplaceMethod = objClass.getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException("No writeReplace method for " + String.valueOf(obj) + " with " + String.valueOf(objClass), e);
        }
        writeReplaceMethod.setAccessible(true);
        try {
            serializedLambda = (SerializedLambda)writeReplaceMethod.invoke((Object)obj, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new SerializationException("Exception invoking writeReplace for " + String.valueOf(obj) + " with " + String.valueOf(objClass), e);
        }
        context.serialize(serializedLambda, codedOut);
    }

    @Override
    public Serializable deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        SerializedLambda serializedLambda = (SerializedLambda)context.deserialize(codedIn);
        try {
            return (Serializable)this.readResolveMethod.invoke((Object)serializedLambda, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Error read-resolving " + String.valueOf(serializedLambda), e);
        }
    }
}

