/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.util;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.shaded.dataflow.qual.Pure;
import org.checkerframework.shaded.dataflow.util.PurityUtils;
import org.checkerframework.shaded.javacutil.AnnotationProvider;
import org.checkerframework.shaded.javacutil.Pair;
import org.checkerframework.shaded.javacutil.TreeUtils;

public class PurityChecker {
    public static PurityResult checkPurity(TreePath statement, AnnotationProvider annoProvider, boolean assumeSideEffectFree, boolean assumeDeterministic) {
        PurityCheckerHelper helper = new PurityCheckerHelper(annoProvider, assumeSideEffectFree, assumeDeterministic);
        helper.scan(statement, null);
        return helper.purityResult;
    }

    protected static class PurityCheckerHelper
    extends TreePathScanner<Void, Void> {
        PurityResult purityResult = new PurityResult();
        protected final AnnotationProvider annoProvider;
        private final boolean assumeSideEffectFree;
        private final boolean assumeDeterministic;

        public PurityCheckerHelper(AnnotationProvider annoProvider, boolean assumeSideEffectFree, boolean assumeDeterministic) {
            this.annoProvider = annoProvider;
            this.assumeSideEffectFree = assumeSideEffectFree;
            this.assumeDeterministic = assumeDeterministic;
        }

        @Override
        public Void visitCatch(CatchTree node, Void ignore) {
            this.purityResult.addNotDetReason(node, "catch");
            return (Void)super.visitCatch(node, ignore);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void ignore) {
            assert (TreeUtils.isUseOfElement(node)) : "@AssumeAssertion(nullness): tree kind";
            ExecutableElement elt = TreeUtils.elementFromUse(node);
            if (!PurityUtils.hasPurityAnnotation(this.annoProvider, elt)) {
                this.purityResult.addNotBothReason(node, "call");
            } else {
                boolean seFree;
                EnumSet<Pure.Kind> purityKinds = this.assumeDeterministic && this.assumeSideEffectFree ? EnumSet.of(Pure.Kind.DETERMINISTIC, Pure.Kind.SIDE_EFFECT_FREE) : PurityUtils.getPurityKinds(this.annoProvider, elt);
                boolean det = this.assumeDeterministic || purityKinds.contains((Object)Pure.Kind.DETERMINISTIC);
                boolean bl = seFree = this.assumeSideEffectFree || purityKinds.contains((Object)Pure.Kind.SIDE_EFFECT_FREE);
                if (!det && !seFree) {
                    this.purityResult.addNotBothReason(node, "call");
                } else if (!det) {
                    this.purityResult.addNotDetReason(node, "call");
                } else if (!seFree) {
                    this.purityResult.addNotSEFreeReason(node, "call");
                }
            }
            return (Void)super.visitMethodInvocation(node, ignore);
        }

        @Override
        public Void visitNewClass(NewClassTree node, Void ignore) {
            boolean sideEffectFree;
            boolean okThrowDeterministic;
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            boolean bl = okThrowDeterministic = parent.getKind() == Tree.Kind.THROW;
            assert (TreeUtils.isUseOfElement(node)) : "@AssumeAssertion(nullness): tree kind";
            ExecutableElement ctorElement = TreeUtils.elementFromUse(node);
            boolean deterministic = this.assumeDeterministic || okThrowDeterministic;
            boolean bl2 = sideEffectFree = this.assumeSideEffectFree || PurityUtils.isSideEffectFree(this.annoProvider, ctorElement);
            if (!deterministic) {
                this.purityResult.addNotDetReason(node, "object.creation");
            }
            if (!sideEffectFree) {
                this.purityResult.addNotSEFreeReason(node, "call");
            }
            return (Void)super.visitNewClass(node, ignore);
        }

        @Override
        public Void visitAssignment(AssignmentTree node, Void ignore) {
            ExpressionTree variable = node.getVariable();
            this.assignmentCheck(variable);
            return (Void)super.visitAssignment(node, ignore);
        }

        protected void assignmentCheck(ExpressionTree variable) {
            if (TreeUtils.isFieldAccess(variable)) {
                this.purityResult.addNotBothReason(variable, "assign.field");
            } else if (variable instanceof ArrayAccessTree) {
                this.purityResult.addNotBothReason(variable, "assign.array");
            } else assert (this.isLocalVariable(variable));
        }

        protected boolean isLocalVariable(ExpressionTree variable) {
            return variable instanceof IdentifierTree && !TreeUtils.isFieldAccess(variable);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, Void ignore) {
            ExpressionTree variable = node.getVariable();
            this.assignmentCheck(variable);
            return (Void)super.visitCompoundAssignment(node, ignore);
        }
    }

    public static class PurityResult {
        protected final List<Pair<Tree, String>> notSEFreeReasons = new ArrayList<Pair<Tree, String>>(1);
        protected final List<Pair<Tree, String>> notDetReasons = new ArrayList<Pair<Tree, String>>(1);
        protected final List<Pair<Tree, String>> notBothReasons = new ArrayList<Pair<Tree, String>>(1);
        protected EnumSet<Pure.Kind> kinds = EnumSet.allOf(Pure.Kind.class);

        public EnumSet<Pure.Kind> getKinds() {
            return this.kinds;
        }

        public boolean isPure(EnumSet<Pure.Kind> otherKinds) {
            return this.kinds.containsAll(otherKinds);
        }

        public List<Pair<Tree, String>> getNotSEFreeReasons() {
            return this.notSEFreeReasons;
        }

        public void addNotSEFreeReason(Tree t, String msgId) {
            this.notSEFreeReasons.add(Pair.of(t, msgId));
            this.kinds.remove((Object)Pure.Kind.SIDE_EFFECT_FREE);
        }

        public List<Pair<Tree, String>> getNotDetReasons() {
            return this.notDetReasons;
        }

        public void addNotDetReason(Tree t, String msgId) {
            this.notDetReasons.add(Pair.of(t, msgId));
            this.kinds.remove((Object)Pure.Kind.DETERMINISTIC);
        }

        public List<Pair<Tree, String>> getNotBothReasons() {
            return this.notBothReasons;
        }

        public void addNotBothReason(Tree t, String msgId) {
            this.notBothReasons.add(Pair.of(t, msgId));
            this.kinds.remove((Object)Pure.Kind.DETERMINISTIC);
            this.kinds.remove((Object)Pure.Kind.SIDE_EFFECT_FREE);
        }
    }
}

