/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="MemberName", severity=BugPattern.SeverityLevel.WARNING, summary="Methods and non-static variables should be named in lowerCamelCase.", linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s5.2-specific-identifier-names")
public final class MemberName
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Supplier<ImmutableSet<Name>> EXEMPTED_CLASS_ANNOTATIONS = VisitorState.memoize((Supplier & Serializable)s -> (ImmutableSet)Stream.of("org.robolectric.annotation.Implements").map(arg_0 -> ((VisitorState)s).getName(arg_0)).collect(ImmutableSet.toImmutableSet()));
    private static final Supplier<ImmutableSet<Name>> EXEMPTED_METHOD_ANNOTATIONS = VisitorState.memoize((Supplier & Serializable)s -> (ImmutableSet)Stream.of("com.pholser.junit.quickcheck.Property", "com.google.caliper.Benchmark", "com.google.caliper.api.Macrobenchmark", "com.google.caliper.api.Footprint").map(arg_0 -> ((VisitorState)s).getName(arg_0)).collect(ImmutableSet.toImmutableSet()));
    private static final Pattern LOWER_UNDERSCORE_PATTERN = Pattern.compile("[a-z0-9_]+");
    private static final Pattern UPPER_UNDERSCORE_PATTERN = Pattern.compile("[A-Z0-9_]+");
    private static final Splitter UNDERSCORE_SPLITTER = Splitter.on((char)'_');

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.annotationsAmong((Symbol)symbol.owner, (Set)((Set)EXEMPTED_CLASS_ANNOTATIONS.get(state)), (VisitorState)state).isEmpty()) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.annotationsAmong((Symbol)symbol, (Set)((Set)EXEMPTED_METHOD_ANNOTATIONS.get(state)), (VisitorState)state).isEmpty()) {
            return Description.NO_MATCH;
        }
        if (MemberName.hasTestAnnotation(symbol) || ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, (Types)state.getTypes()).stream().anyMatch(s -> MemberName.hasTestAnnotation(s))) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)symbol, (String)"org.junit.Ignore", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.findSuperMethod((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)tree), (Types)state.getTypes()).isPresent()) {
            return Description.NO_MATCH;
        }
        if (tree.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
            return Description.NO_MATCH;
        }
        if (((Name)symbol.getSimpleName()).toString().startsWith("parametersFor")) {
            return Description.NO_MATCH;
        }
        if (JUnitMatchers.TEST_CASE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String name = tree.getName().toString();
        if (MemberName.isConformant(name)) {
            return Description.NO_MATCH;
        }
        String suggested = MemberName.suggestedRename(name);
        return suggested.equals(name) || !symbol.isPrivate() ? this.buildDescription(tree).setMessage(String.format("Methods and non-static variables should be named in lowerCamelCase; did you mean '%s'?", suggested)).build() : this.describeMatch(tree, (Fix)SuggestedFixes.renameMethodWithInvocations((MethodTree)tree, (String)suggested, (VisitorState)state));
    }

    private static boolean hasTestAnnotation(Symbol.MethodSymbol symbol) {
        return symbol.getRawAttributes().stream().anyMatch(c -> ((Name)c.type.tsym.getSimpleName()).toString().contains("Test"));
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        if (symbol.isStatic()) {
            return Description.NO_MATCH;
        }
        String name = tree.getName().toString();
        if (UPPER_UNDERSCORE_PATTERN.matcher(name).matches() && !symbol.isStatic()) {
            return Description.NO_MATCH;
        }
        if (MemberName.isConformant(name)) {
            return Description.NO_MATCH;
        }
        String suggested = MemberName.suggestedRename(name);
        return suggested.equals(name) || !MemberName.canBeRenamed(symbol) ? this.describeMatch(tree) : this.describeMatch(tree, (Fix)SuggestedFixes.renameVariable((VariableTree)tree, (String)suggested, (VisitorState)state));
    }

    private static String suggestedRename(String name) {
        if (UPPER_UNDERSCORE_PATTERN.matcher(name).matches()) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        }
        if (LOWER_UNDERSCORE_PATTERN.matcher(name).matches()) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        }
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, UNDERSCORE_SPLITTER.splitToStream((CharSequence)name).map(c -> CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, c)).collect(Collectors.joining("")));
    }

    private static boolean canBeRenamed(Symbol symbol) {
        return symbol.isPrivate() || symbol.getKind().equals((Object)ElementKind.LOCAL_VARIABLE);
    }

    private static boolean isConformant(String name) {
        return !name.contains("_") && !Ascii.isUpperCase((char)name.charAt(0));
    }
}

