/*
 * Decompiled with CFR 0.152.
 */
package javax.annotation.processing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public abstract class AbstractProcessor
implements Processor {
    protected ProcessingEnvironment processingEnv;
    private boolean initialized = false;

    protected AbstractProcessor() {
    }

    @Override
    public Set<String> getSupportedOptions() {
        SupportedOptions supportedOptions = this.getClass().getAnnotation(SupportedOptions.class);
        if (supportedOptions == null) {
            return Collections.emptySet();
        }
        return AbstractProcessor.arrayToSet(supportedOptions.value(), false);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        SupportedAnnotationTypes supportedAnnotationTypes = this.getClass().getAnnotation(SupportedAnnotationTypes.class);
        boolean bl = this.isInitialized();
        if (supportedAnnotationTypes == null) {
            if (bl) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No SupportedAnnotationTypes annotation found on " + this.getClass().getName() + ", returning an empty set.");
            }
            return Collections.emptySet();
        }
        boolean bl2 = bl && this.processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_8) <= 0;
        return AbstractProcessor.arrayToSet(supportedAnnotationTypes.value(), bl2);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SupportedSourceVersion supportedSourceVersion = this.getClass().getAnnotation(SupportedSourceVersion.class);
        SourceVersion sourceVersion = null;
        if (supportedSourceVersion == null) {
            sourceVersion = SourceVersion.RELEASE_6;
            if (this.isInitialized()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No SupportedSourceVersion annotation found on " + this.getClass().getName() + ", returning " + (Object)((Object)sourceVersion) + ".");
            }
        } else {
            sourceVersion = supportedSourceVersion.value();
        }
        return sourceVersion;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot call init more than once.");
        }
        Objects.requireNonNull(processingEnvironment, "Tool provided null ProcessingEnvironment");
        this.processingEnv = processingEnvironment;
        this.initialized = true;
    }

    @Override
    public abstract boolean process(Set<? extends TypeElement> var1, RoundEnvironment var2);

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotationMirror, ExecutableElement executableElement, String string) {
        return Collections.emptyList();
    }

    protected synchronized boolean isInitialized() {
        return this.initialized;
    }

    private static Set<String> arrayToSet(String[] stringArray, boolean bl) {
        assert (stringArray != null);
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string : stringArray) {
            int n;
            if (bl && (n = string.indexOf(47)) != -1) {
                string = string.substring(n + 1);
            }
            hashSet.add(string);
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

