/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.client.impl.client.AllPartitionsClientRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapEntries;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableHook;
import com.hazelcast.replicatedmap.impl.operation.PutAllOperationFactory;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;

public class ClientReplicatedMapPutAllRequest
extends AllPartitionsClientRequest {
    private String name;
    private ReplicatedMapEntries entrySet;

    public ClientReplicatedMapPutAllRequest() {
    }

    public ClientReplicatedMapPutAllRequest(String name, ReplicatedMapEntries entrySet) {
        this.name = name;
        this.entrySet = entrySet;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new PutAllOperationFactory(this.name, this.entrySet);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        for (Map.Entry<Integer, Object> entry : map.entrySet()) {
            Object result = this.serializationService.toObject(entry.getValue());
            if (!(result instanceof Throwable)) continue;
            throw ExceptionUtil.rethrow((Throwable)result);
        }
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        this.entrySet.writePortable(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.entrySet = new ReplicatedMapEntries();
        this.entrySet.readPortable(reader);
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.name, "put");
    }

    @Override
    public String getMethodName() {
        return "putAll";
    }

    @Override
    public Object[] getParameters() {
        HashMap<Data, Data> map = new HashMap<Data, Data>();
        for (Map.Entry<Data, Data> entry : this.entrySet.getEntries()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return new Object[]{map};
    }
}

