/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.spinning;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.ascii.TextWriteHandler;
import com.hazelcast.nio.tcp.NewClientWriteHandler;
import com.hazelcast.nio.tcp.OldClientWriteHandler;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.SocketWriter;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.WriteHandler;
import com.hazelcast.nio.tcp.spinning.AbstractHandler;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.StringUtil;
import com.hazelcast.util.counters.SwCounter;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SpinningSocketWriter
extends AbstractHandler
implements SocketWriter {
    private static final long TIMEOUT = 3L;
    @Probe(name="out.writeQueueSize")
    private final Queue<OutboundFrame> writeQueue;
    @Probe(name="out.priorityWriteQueueSize")
    private final Queue<OutboundFrame> urgentWriteQueue;
    private final ILogger logger;
    private final SocketChannelWrapper socketChannel;
    private ByteBuffer outputBuffer;
    @Probe(name="out.bytesWritten")
    private final SwCounter bytesWritten = SwCounter.newSwCounter();
    @Probe(name="out.normalFramesWritten")
    private final SwCounter normalFramesWritten = SwCounter.newSwCounter();
    @Probe(name="out.priorityFramesWritten")
    private final SwCounter priorityFramesWritten = SwCounter.newSwCounter();
    private final MetricsRegistry metricsRegistry;
    private volatile long lastWriteTime;
    private WriteHandler writeHandler;
    private volatile OutboundFrame currentFrame;

    public SpinningSocketWriter(TcpIpConnection connection, MetricsRegistry metricsRegistry, ILogger logger) {
        super(connection, logger);
        this.metricsRegistry = metricsRegistry;
        this.logger = logger;
        this.socketChannel = connection.getSocketChannelWrapper();
        this.writeQueue = new ConcurrentLinkedQueue<OutboundFrame>();
        this.urgentWriteQueue = new ConcurrentLinkedQueue<OutboundFrame>();
        metricsRegistry.scanAndRegister(this, "tcp.connection[" + connection.getMetricsId() + "]");
    }

    @Override
    public void offer(OutboundFrame frame) {
        if (frame.isUrgent()) {
            this.urgentWriteQueue.add(frame);
        } else {
            this.writeQueue.add(frame);
        }
    }

    @Probe(name="out.writeQueuePendingBytes")
    public long bytesPending() {
        return this.bytesPending(this.writeQueue);
    }

    @Probe(name="out.priorityWriteQueuePendingBytes")
    public long priorityBytesPending() {
        return this.bytesPending(this.urgentWriteQueue);
    }

    @Probe(name="out.idleTimeMs")
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastWriteTime, 0L);
    }

    @Override
    public int totalFramesPending() {
        return this.urgentWriteQueue.size() + this.writeQueue.size();
    }

    private long bytesPending(Queue<OutboundFrame> writeQueue) {
        long bytesPending = 0L;
        for (OutboundFrame frame : writeQueue) {
            if (!(frame instanceof Packet)) continue;
            bytesPending += (long)((Packet)frame).packetSize();
        }
        return bytesPending;
    }

    @Override
    public long getLastWriteTimeMillis() {
        return this.lastWriteTime;
    }

    @Override
    public WriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    @Override
    public void setProtocol(final String protocol) {
        final CountDownLatch latch = new CountDownLatch(1);
        this.urgentWriteQueue.add(new TaskFrame(){

            @Override
            public void run() {
                SpinningSocketWriter.this.logger.info("Setting protocol: " + protocol);
                SpinningSocketWriter.this.createWriter(protocol);
                latch.countDown();
            }
        });
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.finest("CountDownLatch::await interrupted", e);
        }
    }

    private void createWriter(String protocol) {
        if (this.writeHandler != null) {
            return;
        }
        if ("HZC".equals(protocol)) {
            this.configureBuffers(this.ioService.getSocketSendBufferSize() * 1024);
            this.writeHandler = this.ioService.createWriteHandler(this.connection);
            this.outputBuffer.put(StringUtil.stringToBytes("HZC"));
        } else if ("CB1".equals(protocol)) {
            this.configureBuffers(this.ioService.getSocketClientSendBufferSize() * 1024);
            this.writeHandler = new OldClientWriteHandler();
        } else if ("CB2".equals(protocol)) {
            this.configureBuffers(this.ioService.getSocketClientReceiveBufferSize() * 1024);
            this.writeHandler = new NewClientWriteHandler();
        } else {
            this.configureBuffers(this.ioService.getSocketClientSendBufferSize() * 1024);
            this.writeHandler = new TextWriteHandler(this.connection);
        }
    }

    private void configureBuffers(int size) {
        this.outputBuffer = ByteBuffer.allocate(size);
        try {
            this.connection.setSendBufferSize(size);
        }
        catch (SocketException e) {
            this.logger.finest("Failed to adjust TCP send buffer of " + this.connection + " to " + size + " B.", e);
        }
    }

    private OutboundFrame poll() {
        OutboundFrame frame;
        boolean urgent;
        while (true) {
            urgent = true;
            frame = this.urgentWriteQueue.poll();
            if (frame == null) {
                urgent = false;
                frame = this.writeQueue.poll();
            }
            if (frame == null) {
                return null;
            }
            if (!(frame instanceof TaskFrame)) break;
            ((TaskFrame)frame).run();
        }
        if (urgent) {
            this.priorityFramesWritten.inc();
        } else {
            this.normalFramesWritten.inc();
        }
        return frame;
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
        this.metricsRegistry.deregister(this);
        this.writeQueue.clear();
        this.urgentWriteQueue.clear();
        ShutdownTask shutdownTask = new ShutdownTask();
        this.offer(shutdownTask);
        shutdownTask.awaitCompletion();
    }

    public void write() throws Exception {
        if (!this.connection.isAlive()) {
            return;
        }
        if (this.writeHandler == null) {
            this.logger.log(Level.WARNING, "SocketWriter is not set, creating SocketWriter with CLUSTER protocol!");
            this.createWriter("HZC");
            return;
        }
        this.fillOutputBuffer();
        if (this.dirtyOutputBuffer()) {
            this.writeOutputBufferToSocket();
        }
    }

    private boolean dirtyOutputBuffer() {
        if (this.outputBuffer == null) {
            return false;
        }
        return this.outputBuffer.position() > 0;
    }

    private void fillOutputBuffer() throws Exception {
        while (this.outputBuffer == null || this.outputBuffer.hasRemaining()) {
            if (this.currentFrame == null) {
                this.currentFrame = this.poll();
                if (this.currentFrame == null) {
                    return;
                }
            }
            if (!this.writeHandler.onWrite(this.currentFrame, this.outputBuffer)) {
                return;
            }
            this.currentFrame = null;
        }
        return;
    }

    private void writeOutputBufferToSocket() throws Exception {
        this.outputBuffer.flip();
        int result = this.socketChannel.write(this.outputBuffer);
        if (result > 0) {
            this.lastWriteTime = System.currentTimeMillis();
            this.bytesWritten.inc(result);
        }
        if (this.outputBuffer.hasRemaining()) {
            this.outputBuffer.compact();
        } else {
            this.outputBuffer.clear();
        }
    }

    private class ShutdownTask
    extends TaskFrame {
        private final CountDownLatch latch;

        private ShutdownTask() {
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void run() {
            try {
                SpinningSocketWriter.this.socketChannel.closeOutbound();
            }
            catch (IOException e) {
                SpinningSocketWriter.this.logger.finest("Error while closing outbound", e);
            }
            finally {
                this.latch.countDown();
            }
        }

        void awaitCompletion() {
            try {
                this.latch.await(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                EmptyStatement.ignore(e);
            }
        }
    }

    private abstract class TaskFrame
    implements OutboundFrame {
        private TaskFrame() {
        }

        abstract void run();

        @Override
        public boolean isUrgent() {
            return true;
        }
    }
}

