/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import javax.lang.model.element.ElementKind;

@BugPattern(name="EqualsHashCode", summary="Classes that override equals should also override hashCode.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class EqualsHashCode
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<MethodTree> EQUALS_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"equals"), Matchers.methodHasVisibility((MethodVisibility.Visibility)MethodVisibility.Visibility.PUBLIC), Matchers.methodReturns((Supplier)Suppliers.BOOLEAN_TYPE), Matchers.methodHasParameters((Matcher[])new Matcher[]{Matchers.variableType((Matcher)Matchers.isSameType((Supplier)Suppliers.OBJECT_TYPE))})});

    public Description matchClass(ClassTree classTree, VisitorState state) {
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)classTree);
        if (((Symbol)symbol).getKind() != ElementKind.CLASS) {
            return Description.NO_MATCH;
        }
        MethodTree equals = null;
        for (Tree tree : classTree.getMembers()) {
            MethodTree methodTree;
            if (!(tree instanceof MethodTree) || !EQUALS_MATCHER.matches((Tree)(methodTree = (MethodTree)tree), state)) continue;
            equals = methodTree;
        }
        if (equals == null || this.isSuppressed(equals)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol hashCodeSym = ASTHelpers.resolveExistingMethod((VisitorState)state, (Symbol.TypeSymbol)symbol, (Name)state.getName("hashCode"), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
        if (hashCodeSym.owner.equals(state.getSymtab().objectType.tsym)) {
            return this.describeMatch(equals);
        }
        return Description.NO_MATCH;
    }
}

