/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.internal;

public final class StringUtil {
    public static final int MAX_LENGTH = 255;
    public static final char UNPRINTABLE_CHAR_SUBSTITUTE = '_';

    public static String sanitize(String str) {
        if (str.length() > 255) {
            str = str.substring(0, 255);
        }
        if (StringUtil.isPrintableString(str)) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            builder.append(StringUtil.isPrintableChar(ch) ? ch : (char)'_');
        }
        return builder.toString();
    }

    public static boolean isPrintableString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtil.isPrintableChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrintableChar(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    StringUtil() {
        throw new AssertionError();
    }
}

