/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.OperatorPrecedence;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.type.TypeKind;

@BugPattern(name="NarrowingCompoundAssignment", summary="Compound assignments to bytes, shorts, chars, and floats hide dangerous casts", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class NarrowingCompoundAssignment
extends BugChecker
implements BugChecker.CompoundAssignmentTreeMatcher {
    private static final Set<TypeKind> DEFICIENT_TYPES = Collections.unmodifiableSet(EnumSet.of(TypeKind.BYTE, TypeKind.SHORT, TypeKind.CHAR, TypeKind.FLOAT));
    private static final Set<TypeKind> INTEGRAL_TYPES = Collections.unmodifiableSet(EnumSet.of(TypeKind.BYTE, TypeKind.SHORT, TypeKind.CHAR, TypeKind.INT, TypeKind.LONG));
    private static final Set<TypeKind> FLOAT_TYPES = Collections.unmodifiableSet(EnumSet.of(TypeKind.FLOAT, TypeKind.DOUBLE));

    static String assignmentToString(Tree.Kind kind) {
        switch (kind) {
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case REMAINDER: {
                return "%";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case LEFT_SHIFT: {
                return "<<";
            }
            case AND: {
                return "&";
            }
            case XOR: {
                return "^";
            }
            case OR: {
                return "|";
            }
            case RIGHT_SHIFT: {
                return ">>";
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return ">>>";
            }
        }
        throw new IllegalArgumentException("Unexpected operator assignment kind: " + (Object)((Object)kind));
    }

    static Tree.Kind regularAssignmentFromCompound(Tree.Kind kind) {
        switch (kind) {
            case MULTIPLY_ASSIGNMENT: {
                return Tree.Kind.MULTIPLY;
            }
            case DIVIDE_ASSIGNMENT: {
                return Tree.Kind.DIVIDE;
            }
            case REMAINDER_ASSIGNMENT: {
                return Tree.Kind.REMAINDER;
            }
            case PLUS_ASSIGNMENT: {
                return Tree.Kind.PLUS;
            }
            case MINUS_ASSIGNMENT: {
                return Tree.Kind.MINUS;
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.LEFT_SHIFT;
            }
            case AND_ASSIGNMENT: {
                return Tree.Kind.AND;
            }
            case XOR_ASSIGNMENT: {
                return Tree.Kind.XOR;
            }
            case OR_ASSIGNMENT: {
                return Tree.Kind.OR;
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.RIGHT_SHIFT;
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.UNSIGNED_RIGHT_SHIFT;
            }
        }
        throw new IllegalArgumentException("Unexpected compound assignment kind: " + (Object)((Object)kind));
    }

    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        NarrowingCastKind castKind = NarrowingCompoundAssignment.identifyBadCast(ASTHelpers.getType((Tree)tree.getVariable()), ASTHelpers.getType((Tree)tree.getExpression()), state.getTypes());
        if (castKind == null) {
            return Description.NO_MATCH;
        }
        Optional<Fix> fix = NarrowingCompoundAssignment.rewriteCompoundAssignment(tree, state);
        if (!fix.isPresent()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix((Fix)fix.get()).setMessage(castKind.message()).build();
    }

    private static NarrowingCastKind identifyBadCast(Type lhs, Type rhs, Types types) {
        if (types.isConvertible(rhs, lhs)) {
            return null;
        }
        if (DEFICIENT_TYPES.contains((Object)lhs.getKind())) {
            return NarrowingCastKind.DEFICIENT;
        }
        if (FLOAT_TYPES.contains((Object)rhs.getKind()) && INTEGRAL_TYPES.contains((Object)lhs.getKind())) {
            return NarrowingCastKind.FLOAT_TO_INTEGRAL;
        }
        return null;
    }

    private static Optional<Fix> rewriteCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        Tree.Kind rhsKind;
        String var = state.getSourceForNode((Tree)((JCTree)((Object)tree.getVariable())));
        String expr = state.getSourceForNode((Tree)((JCTree)((Object)tree.getExpression())));
        if (var == null || expr == null) {
            return Optional.absent();
        }
        switch (tree.getKind()) {
            case RIGHT_SHIFT_ASSIGNMENT: {
                return Optional.absent();
            }
        }
        Tree.Kind regularAssignmentKind = NarrowingCompoundAssignment.regularAssignmentFromCompound(tree.getKind());
        String op = NarrowingCompoundAssignment.assignmentToString(regularAssignmentKind);
        if (tree.getExpression() instanceof JCTree.JCBinary && !OperatorPrecedence.from((Tree.Kind)(rhsKind = ((JCTree.JCBinary)tree.getExpression()).getKind())).isHigher(OperatorPrecedence.from((Tree.Kind)regularAssignmentKind))) {
            expr = String.format("(%s)", expr);
        }
        String castType = ASTHelpers.getType((Tree)tree.getVariable()).toString();
        String replacement = String.format("%s = (%s) (%s %s %s)", var, castType, var, op, expr);
        return Optional.of((Object)SuggestedFix.replace((Tree)tree, (String)replacement));
    }

    private static enum NarrowingCastKind {
        DEFICIENT("Compound assignments to bytes, shorts, chars, and floats hide dangerous casts"),
        FLOAT_TO_INTEGRAL("Compound assignments from floating point to integral types hide dangerous casts");

        private final String message;

        private NarrowingCastKind(String message) {
            this.message = message;
        }

        String message() {
            return this.message;
        }
    }
}

