/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableListMultimap;
import dagger.Module;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.KeyFormatter;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.MultibindingsMethodValidator;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

final class MultibindingsValidator {
    private final Elements elements;
    private final Key.Factory keyFactory;
    private final KeyFormatter keyFormatter;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final TypeElement objectElement;
    private final MultibindingsMethodValidator multibindingsMethodValidator;

    MultibindingsValidator(Elements elements, Key.Factory keyFactory, KeyFormatter keyFormatter, MethodSignatureFormatter methodSignatureFormatter, MultibindingsMethodValidator multibindingsMethodValidator) {
        this.elements = elements;
        this.keyFactory = keyFactory;
        this.keyFormatter = keyFormatter;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.multibindingsMethodValidator = multibindingsMethodValidator;
        this.objectElement = elements.getTypeElement(Object.class.getCanonicalName());
    }

    public ValidationReport<TypeElement> validate(TypeElement multibindingsType) {
        Optional<BindingType> bindingType;
        ValidationReport.Builder<TypeElement> validation = ValidationReport.about(multibindingsType);
        if (!multibindingsType.getKind().equals((Object)ElementKind.INTERFACE)) {
            validation.addError("@Multibindings can be applied only to interfaces", multibindingsType);
        }
        if (!multibindingsType.getTypeParameters().isEmpty()) {
            validation.addError("@Multibindings types must not have type parameters", multibindingsType);
        }
        if (!(bindingType = this.bindingType(multibindingsType)).isPresent()) {
            validation.addError("@Multibindings types must be nested within a @Module or @ProducerModule", multibindingsType);
        }
        ImmutableListMultimap.Builder methodsByKey = ImmutableListMultimap.builder();
        for (ExecutableElement method : MoreElements.getLocalAndInheritedMethods(multibindingsType, this.elements)) {
            if (method.getEnclosingElement().equals(this.objectElement)) continue;
            ValidationReport<ExecutableElement> methodReport = this.multibindingsMethodValidator.validate(method);
            validation.addItems((Iterable<ValidationReport.Item>)methodReport.items());
            if (!methodReport.isClean() || !bindingType.isPresent()) continue;
            methodsByKey.put((Object)this.keyFactory.forMultibindsMethod((BindingType)((Object)bindingType.get()), MoreTypes.asExecutable(method.asType()), method), (Object)method);
        }
        for (Map.Entry entry : methodsByKey.build().asMap().entrySet()) {
            Collection methods = (Collection)entry.getValue();
            if (methods.size() <= 1) continue;
            Key key = (Key)entry.getKey();
            validation.addError(this.tooManyMultibindingsMethodsForKey(key, methods), multibindingsType);
        }
        return validation.build();
    }

    private String tooManyMultibindingsMethodsForKey(Key key, Collection<ExecutableElement> methods) {
        StringBuilder builder = new StringBuilder(ErrorMessages.MultibindingsMessages.tooManyMethodsForKey(this.keyFormatter.format(key)));
        builder.append(':');
        this.methodSignatureFormatter.formatIndentedList(builder, methods, 1, 10);
        return builder.toString();
    }

    private Optional<BindingType> bindingType(TypeElement multibindingsType) {
        if (MoreElements.isAnnotationPresent(multibindingsType.getEnclosingElement(), Module.class)) {
            return Optional.of((Object)((Object)BindingType.PROVISION));
        }
        if (MoreElements.isAnnotationPresent(multibindingsType.getEnclosingElement(), ProducerModule.class)) {
            return Optional.of((Object)((Object)BindingType.PRODUCTION));
        }
        return Optional.absent();
    }
}

