/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.DescribedNode;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.Identifier;
import lombok.ast.ListAccessor;
import lombok.ast.MethodInvocationTemplate;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;

public class MethodInvocation
extends AbstractNode
implements Expression,
DescribedNode {
    private List<Position> parensPositions = new ArrayList<Position>();
    private AbstractNode operand = null;
    ListAccessor<TypeReference, MethodInvocation> methodTypeArguments = ListAccessor.of(this, TypeReference.class, "MethodInvocation.methodTypeArguments");
    private AbstractNode name = this.adopt(new Identifier());
    ListAccessor<Expression, MethodInvocation> arguments = ListAccessor.of(this, Expression.class, "MethodInvocation.arguments");

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public Expression astOperand() {
        if (!(this.operand instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.operand);
    }

    public MethodInvocation astOperand(Expression operand) {
        return this.rawOperand(operand);
    }

    public Node rawOperand() {
        return this.operand;
    }

    public MethodInvocation rawOperand(Node operand) {
        if (operand == this.operand) {
            return this;
        }
        if (operand != null) {
            this.adopt((AbstractNode)operand);
        }
        if (this.operand != null) {
            this.disown(this.operand);
        }
        this.operand = (AbstractNode)operand;
        return this;
    }

    public RawListAccessor<TypeReference, MethodInvocation> rawMethodTypeArguments() {
        return this.methodTypeArguments.asRaw();
    }

    public StrictListAccessor<TypeReference, MethodInvocation> astMethodTypeArguments() {
        return this.methodTypeArguments.asStrict();
    }

    public Identifier astName() {
        if (!(this.name instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.name;
    }

    public MethodInvocation astName(Identifier name) {
        return this.rawName(name);
    }

    private MethodInvocation rawName(Node name) {
        if (name == this.name) {
            return this;
        }
        if (name != null) {
            this.adopt((AbstractNode)name);
        }
        if (this.name != null) {
            this.disown(this.name);
        }
        this.name = (AbstractNode)name;
        return this;
    }

    public RawListAccessor<Expression, MethodInvocation> rawArguments() {
        return this.arguments.asRaw();
    }

    public StrictListAccessor<Expression, MethodInvocation> astArguments() {
        return this.arguments.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.operand != null) {
            result.add(this.operand);
        }
        result.addAll(this.methodTypeArguments.backingList());
        if (this.name != null) {
            result.add(this.name);
        }
        result.addAll(this.arguments.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.operand == original) {
            this.rawOperand(replacement);
            return true;
        }
        if (this.rawMethodTypeArguments().replace(original, replacement)) {
            return true;
        }
        if (this.name == original) {
            if (replacement instanceof Identifier) {
                this.astName((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        return this.rawArguments().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        if (this.operand == child) {
            this.disown((AbstractNode)child);
            this.operand = null;
            return true;
        }
        if (this.rawMethodTypeArguments().remove(child)) {
            return true;
        }
        if (this.name == child) {
            this.disown((AbstractNode)child);
            this.name = null;
            return true;
        }
        return this.rawArguments().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitMethodInvocation(this)) {
            return;
        }
        if (this.operand != null) {
            this.operand.accept(visitor);
        }
        for (AbstractNode child : this.methodTypeArguments.asIterable()) {
            child.accept(visitor);
        }
        if (this.name != null) {
            this.name.accept(visitor);
        }
        for (AbstractNode child : this.arguments.asIterable()) {
            child.accept(visitor);
        }
        visitor.afterVisitMethodInvocation(this);
        visitor.endVisit(this);
    }

    @Override
    public MethodInvocation copy() {
        MethodInvocation result = new MethodInvocation();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        if (this.operand != null) {
            result.rawOperand(this.operand.copy());
        }
        for (AbstractNode n : this.methodTypeArguments.backingList()) {
            result.rawMethodTypeArguments().addToEnd(n == null ? null : n.copy());
        }
        if (this.name != null) {
            result.rawName(this.name.copy());
        }
        for (AbstractNode n : this.arguments.backingList()) {
            result.rawArguments().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return MethodInvocationTemplate.getDescription(this);
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean needsParentheses() {
        return ExpressionMixin.needsParentheses(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

