/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Names;

public abstract class Name
implements javax.lang.model.element.Name {
    public final Table table;

    protected Name(Table table) {
        this.table = table;
    }

    @Override
    public boolean contentEquals(CharSequence cs) {
        return this.toString().equals(cs.toString());
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public Name append(Name n) {
        int len = this.getByteLength();
        byte[] bs = new byte[len + n.getByteLength()];
        this.getBytes(bs, 0);
        n.getBytes(bs, len);
        return this.table.fromUtf(bs, 0, bs.length);
    }

    public Name append(char c, Name n) {
        int len = this.getByteLength();
        byte[] bs = new byte[len + 1 + n.getByteLength()];
        this.getBytes(bs, 0);
        bs[len] = (byte)c;
        n.getBytes(bs, len + 1);
        return this.table.fromUtf(bs, 0, bs.length);
    }

    public int compareTo(Name other) {
        return other.getIndex() - this.getIndex();
    }

    @Override
    public boolean isEmpty() {
        return this.getByteLength() == 0;
    }

    public int lastIndexOf(byte b) {
        int i;
        byte[] bytes = this.getByteArray();
        int offset = this.getByteOffset();
        for (i = this.getByteLength() - 1; i >= 0 && bytes[offset + i] != b; --i) {
        }
        return i;
    }

    public boolean startsWith(Name prefix) {
        int i;
        byte[] thisBytes = this.getByteArray();
        int thisOffset = this.getByteOffset();
        int thisLength = this.getByteLength();
        byte[] prefixBytes = prefix.getByteArray();
        int prefixOffset = prefix.getByteOffset();
        int prefixLength = prefix.getByteLength();
        if (thisLength < prefixLength) {
            return false;
        }
        for (i = 0; i < prefixLength && thisBytes[thisOffset + i] == prefixBytes[prefixOffset + i]; ++i) {
        }
        return i == prefixLength;
    }

    public Name subName(int start, int end) {
        if (end < start) {
            end = start;
        }
        return this.table.fromUtf(this.getByteArray(), this.getByteOffset() + start, end - start);
    }

    @Override
    public String toString() {
        return Convert.utf2string(this.getByteArray(), this.getByteOffset(), this.getByteLength());
    }

    public byte[] toUtf() {
        byte[] bs = new byte[this.getByteLength()];
        this.getBytes(bs, 0);
        return bs;
    }

    public abstract int getIndex();

    public abstract int getByteLength();

    public abstract byte getByteAt(int var1);

    public void getBytes(byte[] cs, int start) {
        System.arraycopy(this.getByteArray(), this.getByteOffset(), cs, start, this.getByteLength());
    }

    public abstract byte[] getByteArray();

    public abstract int getByteOffset();

    public static abstract class Table {
        public final Names names;

        Table(Names names) {
            this.names = names;
        }

        public abstract Name fromChars(char[] var1, int var2, int var3);

        public Name fromString(String s) {
            char[] cs = s.toCharArray();
            return this.fromChars(cs, 0, cs.length);
        }

        public Name fromUtf(byte[] cs) {
            return this.fromUtf(cs, 0, cs.length);
        }

        public abstract Name fromUtf(byte[] var1, int var2, int var3);

        public abstract void dispose();

        protected static int hashValue(byte[] bytes, int offset, int length) {
            int h = 0;
            int off = offset;
            for (int i = 0; i < length; ++i) {
                h = (h << 5) - h + bytes[off++];
            }
            return h;
        }

        protected static boolean equals(byte[] bytes1, int offset1, byte[] bytes2, int offset2, int length) {
            int i;
            for (i = 0; i < length && bytes1[offset1 + i] == bytes2[offset2 + i]; ++i) {
            }
            return i == length;
        }
    }
}

