/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeParameterShadowing;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.names.NamingConventions;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Name;

@BugPattern(name="TypeParameterNaming", summary="Type parameters must be a single letter with an optional numeric suffix, or an UpperCamelCase name followed by the letter 'T'.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"}, linkType=BugPattern.LinkType.CUSTOM, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, link="https://google.github.io/styleguide/javaguide.html#s5.2.8-type-variable-names")
public class TypeParameterNaming
extends BugChecker
implements BugChecker.TypeParameterTreeMatcher {
    private static final Pattern SINGLE_PLUS_MAYBE_DIGIT = Pattern.compile("[A-Z]\\d?");
    private static final Pattern TRAILING_DIGIT_EXTRACTOR = Pattern.compile("^(.*?)(\\d+)$");

    private static String upperCamelToken(String s) {
        return "" + Ascii.toUpperCase((char)s.charAt(0)) + (s.length() == 1 ? "" : s.substring(1));
    }

    public Description matchTypeParameter(TypeParameterTree tree, VisitorState state) {
        if (TypeParameterNaming.matchesTypeParameterNamingScheme(tree.getName())) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("Type Parameter %s must be a single letter with an optional numeric suffix, or an UpperCamelCase name followed by the letter 'T'.", tree.getName())).addFix((Fix)TypeParameterShadowing.renameTypeVariable(tree, state.getPath().getParentPath().getLeaf(), TypeParameterNaming.suggestedNameFollowedWithT(tree.getName().toString()), state)).addFix((Fix)TypeParameterShadowing.renameTypeVariable(tree, state.getPath().getParentPath().getLeaf(), TypeParameterNaming.suggestedSingleLetter(tree.getName().toString(), tree), state)).build();
    }

    private static List<Symbol.TypeVariableSymbol> typeVariablesEnclosing(Symbol sym) {
        ArrayList<Symbol.TypeVariableSymbol> typeVarScopes = new ArrayList<Symbol.TypeVariableSymbol>();
        block4: while (!sym.isStatic()) {
            sym = sym.owner;
            switch (sym.getKind()) {
                case PACKAGE: {
                    break block4;
                }
                case METHOD: 
                case CLASS: {
                    typeVarScopes.addAll(0, sym.getTypeParameters());
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return typeVarScopes;
    }

    private static String suggestedSingleLetter(String id, Tree tree) {
        char firstLetter = id.charAt(0);
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        List<Symbol.TypeVariableSymbol> enclosingTypeSymbols = TypeParameterNaming.typeVariablesEnclosing(sym);
        for (Symbol.TypeVariableSymbol typeName : enclosingTypeSymbols) {
            char enclosingTypeFirstLetter = typeName.toString().charAt(0);
            if (enclosingTypeFirstLetter != firstLetter || TypeParameterNaming.matchesTypeParameterNamingScheme(typeName.name)) continue;
            List typeVarsInScope = (List)Streams.concat((Stream[])new Stream[]{enclosingTypeSymbols.stream(), sym.getTypeParameters().stream()}).map(v -> v.name.toString()).collect(ImmutableList.toImmutableList());
            return TypeParameterNaming.firstLetterReplacementName(id, typeVarsInScope);
        }
        return Character.toString(firstLetter);
    }

    private static String firstLetterReplacementName(String name, List<String> superTypeVars) {
        String firstLetterOfBase = Character.toString(name.charAt(0));
        int typeVarNum = 2;
        boolean first = true;
        Matcher matcher = TRAILING_DIGIT_EXTRACTOR.matcher(name);
        if (matcher.matches()) {
            name = matcher.group(1);
            typeVarNum = Integer.parseInt(matcher.group(2)) + 1;
        }
        String replacementName = "";
        for (String superTypeVar : superTypeVars) {
            if (superTypeVar.equals(name)) {
                if (typeVarNum != 2 || !first) break;
                return firstLetterOfBase;
            }
            if (superTypeVar.charAt(0) != name.charAt(0)) continue;
            if (!first) {
                ++typeVarNum;
            } else {
                first = false;
            }
            replacementName = firstLetterOfBase + typeVarNum;
        }
        while (superTypeVars.contains(replacementName)) {
            replacementName = firstLetterOfBase + ++typeVarNum;
        }
        return replacementName;
    }

    static boolean matchesTypeParameterNamingScheme(Name name) {
        return SINGLE_PLUS_MAYBE_DIGIT.matcher(name).matches() || TypeParameterNaming.matchesClassWithT(name.toString());
    }

    private static String suggestedNameFollowedWithT(String identifier) {
        String token;
        Preconditions.checkArgument((!identifier.isEmpty() ? 1 : 0) != 0);
        if (identifier.length() > 2 && identifier.charAt(0) == 'T' && Ascii.isUpperCase((char)identifier.charAt(1)) && Ascii.isLowerCase((char)identifier.charAt(2))) {
            ImmutableList tokens = NamingConventions.splitToLowercaseTerms((String)identifier.substring(1));
            return Streams.concat((Stream[])new Stream[]{tokens.stream(), Stream.of("T")}).map(TypeParameterNaming::upperCamelToken).collect(Collectors.joining());
        }
        ImmutableList tokens = NamingConventions.splitToLowercaseTerms((String)identifier);
        if (tokens.size() == 1 && (token = (String)tokens.get(0)).toUpperCase().equals(identifier)) {
            return TypeParameterNaming.upperCamelToken(token) + "T";
        }
        if (((String)Iterables.getLast((Iterable)tokens)).equals("type")) {
            return Streams.concat((Stream[])new Stream[]{tokens.subList(0, tokens.size() - 1).stream(), Stream.of("T")}).map(TypeParameterNaming::upperCamelToken).collect(Collectors.joining());
        }
        return identifier + "T";
    }

    @VisibleForTesting
    static boolean matchesClassWithT(String identifier) {
        if (!identifier.endsWith("T")) {
            return false;
        }
        ImmutableList tokens = NamingConventions.splitToLowercaseTerms((String)identifier);
        String reassembled = tokens.stream().map(TypeParameterNaming::upperCamelToken).collect(Collectors.joining());
        return identifier.equals(reassembled);
    }
}

