/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model;

public enum SourceVersion {
    RELEASE_0,
    RELEASE_1,
    RELEASE_2,
    RELEASE_3,
    RELEASE_4,
    RELEASE_5,
    RELEASE_6,
    RELEASE_7,
    RELEASE_8,
    RELEASE_9,
    RELEASE_10;

    private static final SourceVersion latestSupported;

    public static SourceVersion latest() {
        return RELEASE_10;
    }

    private static SourceVersion getLatestSupported() {
        try {
            String specVersion;
            switch (specVersion = System.getProperty("java.specification.version")) {
                case "10": {
                    return RELEASE_10;
                }
                case "9": {
                    return RELEASE_9;
                }
                case "1.8": {
                    return RELEASE_8;
                }
                case "1.7": {
                    return RELEASE_7;
                }
                case "1.6": {
                    return RELEASE_6;
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return RELEASE_5;
    }

    public static SourceVersion latestSupported() {
        return latestSupported;
    }

    public static boolean isIdentifier(CharSequence name) {
        String id = name.toString();
        if (id.length() == 0) {
            return false;
        }
        int cp = id.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        for (int i = Character.charCount(cp); i < id.length(); i += Character.charCount(cp)) {
            cp = id.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    public static boolean isName(CharSequence name) {
        return SourceVersion.isName(name, SourceVersion.latest());
    }

    public static boolean isName(CharSequence name, SourceVersion version) {
        String id = name.toString();
        for (String s : id.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s) && !SourceVersion.isKeyword(s, version)) continue;
            return false;
        }
        return true;
    }

    public static boolean isKeyword(CharSequence s) {
        return SourceVersion.isKeyword(s, SourceVersion.latest());
    }

    public static boolean isKeyword(CharSequence s, SourceVersion version) {
        String id;
        switch (id = s.toString()) {
            case "strictfp": {
                return version.compareTo(RELEASE_2) >= 0;
            }
            case "assert": {
                return version.compareTo(RELEASE_4) >= 0;
            }
            case "enum": {
                return version.compareTo(RELEASE_5) >= 0;
            }
            case "_": {
                return version.compareTo(RELEASE_9) >= 0;
            }
            case "public": 
            case "protected": 
            case "private": 
            case "abstract": 
            case "static": 
            case "final": 
            case "transient": 
            case "volatile": 
            case "synchronized": 
            case "native": 
            case "class": 
            case "interface": 
            case "extends": 
            case "package": 
            case "throws": 
            case "implements": 
            case "boolean": 
            case "byte": 
            case "char": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "void": 
            case "if": 
            case "else": 
            case "try": 
            case "catch": 
            case "finally": 
            case "do": 
            case "while": 
            case "for": 
            case "continue": 
            case "switch": 
            case "case": 
            case "default": 
            case "break": 
            case "throw": 
            case "return": 
            case "this": 
            case "new": 
            case "super": 
            case "import": 
            case "instanceof": 
            case "goto": 
            case "const": 
            case "null": 
            case "true": 
            case "false": {
                return true;
            }
        }
        return false;
    }

    static {
        latestSupported = SourceVersion.getLatestSupported();
    }
}

