/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor.escapevelocity;

import autovalue.shaded.com.google$.common.base.$Joiner;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import autovalue.shaded.com.google$.common.primitives.$Primitives;
import com.google.auto.value.processor.escapevelocity.EvaluationContext;
import com.google.auto.value.processor.escapevelocity.ExpressionNode;
import com.google.auto.value.processor.escapevelocity.Node;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class ReferenceNode
extends ExpressionNode {
    private static final String THIS_PACKAGE;
    private static final Method CLASS_GET_MODULE_METHOD;
    private static final Method MODULE_IS_EXPORTED_METHOD;

    ReferenceNode(String resourceName, int lineNumber) {
        super(resourceName, lineNumber);
    }

    Object invokeMethod(Method method, Object target, List<Object> argValues) {
        if (!ReferenceNode.classIsPublic(target.getClass()) && (method = ReferenceNode.visibleMethod(method, target.getClass())) == null) {
            throw this.evaluationException("Method is not visible in class " + target.getClass().getName() + ": " + method);
        }
        try {
            return method.invoke(target, argValues.toArray());
        }
        catch (InvocationTargetException e) {
            throw this.evaluationException(e.getCause());
        }
        catch (Exception e) {
            throw this.evaluationException(e);
        }
    }

    private static String packageNameOf(Class<?> c) {
        String name = c.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot > 0) {
            return name.substring(0, lastDot);
        }
        return "";
    }

    static Method visibleMethod(Method method, Class<?> in) {
        Method methodInClass;
        if (in == null) {
            return null;
        }
        try {
            methodInClass = in.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (ReferenceNode.classIsPublic(in) || in.getName().startsWith(THIS_PACKAGE)) {
            return methodInClass;
        }
        Method methodSuper = ReferenceNode.visibleMethod(method, in.getSuperclass());
        if (methodSuper != null) {
            return methodSuper;
        }
        for (Class<?> intf : in.getInterfaces()) {
            Method methodIntf = ReferenceNode.visibleMethod(method, intf);
            if (methodIntf == null) continue;
            return methodIntf;
        }
        return null;
    }

    private static boolean classIsPublic(Class<?> c) {
        if (!Modifier.isPublic(c.getModifiers())) {
            return false;
        }
        if (CLASS_GET_MODULE_METHOD != null) {
            return ReferenceNode.classIsExported(c);
        }
        return true;
    }

    private static boolean classIsExported(Class<?> c) {
        try {
            String pkg = ReferenceNode.packageNameOf(c);
            Object module = CLASS_GET_MODULE_METHOD.invoke(c, new Object[0]);
            return (Boolean)MODULE_IS_EXPORTED_METHOD.invoke(module, pkg);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        Method moduleIsExportedMethod;
        Method classGetModuleMethod;
        THIS_PACKAGE = ReferenceNode.packageNameOf(Node.class) + ".";
        try {
            classGetModuleMethod = Class.class.getMethod("getModule", new Class[0]);
            Class<?> moduleClass = classGetModuleMethod.getReturnType();
            moduleIsExportedMethod = moduleClass.getMethod("isExported", String.class);
        }
        catch (Exception e) {
            classGetModuleMethod = null;
            moduleIsExportedMethod = null;
        }
        CLASS_GET_MODULE_METHOD = classGetModuleMethod;
        MODULE_IS_EXPORTED_METHOD = moduleIsExportedMethod;
    }

    static class MethodReferenceNode
    extends ReferenceNode {
        final ReferenceNode lhs;
        final String id;
        final List<ExpressionNode> args;
        private static final $ImmutableList<Class<?>> NUMERICAL_PRIMITIVES = $ImmutableList.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
        private static final int INDEX_OF_INT = NUMERICAL_PRIMITIVES.indexOf(Integer.TYPE);

        MethodReferenceNode(ReferenceNode lhs, String id, List<ExpressionNode> args) {
            super(lhs.resourceName, lhs.lineNumber);
            this.lhs = lhs;
            this.id = id;
            this.args = args;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            Object lhsValue = this.lhs.evaluate(context);
            if (lhsValue == null) {
                throw this.evaluationException("Cannot invoke method " + this.id + " on null value");
            }
            ArrayList<Object> argValues = new ArrayList<Object>();
            for (ExpressionNode expressionNode : this.args) {
                argValues.add(expressionNode.evaluate(context));
            }
            ArrayList<Method> methodsWithName = new ArrayList<Method>();
            for (Method method : lhsValue.getClass().getMethods()) {
                if (!method.getName().equals(this.id) || method.isSynthetic()) continue;
                methodsWithName.add(method);
            }
            if (methodsWithName.isEmpty()) {
                throw this.evaluationException("No method " + this.id + " in " + lhsValue.getClass().getName());
            }
            ArrayList<Method> arrayList = new ArrayList<Method>();
            for (Method method : methodsWithName) {
                if (!MethodReferenceNode.compatibleArgs(method.getParameterTypes(), argValues)) continue;
                arrayList.add(method);
            }
            switch (arrayList.size()) {
                case 0: {
                    throw this.evaluationException("Parameters for method " + this.id + " have wrong types: " + argValues);
                }
                case 1: {
                    return this.invokeMethod((Method)$Iterables.getOnlyElement(arrayList), lhsValue, argValues);
                }
            }
            throw this.evaluationException("Ambiguous method invocation, could be one of:\n  " + $Joiner.on("\n  ").join(arrayList));
        }

        static boolean compatibleArgs(Class<?>[] paramTypes, List<Object> argValues) {
            if (paramTypes.length != argValues.size()) {
                return false;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> paramType = paramTypes[i];
                Object argValue = argValues.get(i);
                if (paramType.isPrimitive()) {
                    return MethodReferenceNode.primitiveIsCompatible(paramType, argValue);
                }
                if (paramType.isInstance(argValue)) continue;
                return false;
            }
            return true;
        }

        private static boolean primitiveIsCompatible(Class<?> primitive, Object value) {
            if (value == null || !$Primitives.isWrapperType(value.getClass())) {
                return false;
            }
            return MethodReferenceNode.primitiveTypeIsAssignmentCompatible(primitive, $Primitives.unwrap(value.getClass()));
        }

        static boolean primitiveTypeIsAssignmentCompatible(Class<?> to, Class<?> from) {
            if (to == from) {
                return true;
            }
            int toI = NUMERICAL_PRIMITIVES.indexOf(to);
            if (toI < 0) {
                return false;
            }
            if (from == Character.TYPE) {
                return toI >= INDEX_OF_INT;
            }
            int fromI = NUMERICAL_PRIMITIVES.indexOf(from);
            if (fromI < 0) {
                return false;
            }
            return toI >= fromI;
        }
    }

    static class IndexReferenceNode
    extends ReferenceNode {
        final ReferenceNode lhs;
        final ExpressionNode index;

        IndexReferenceNode(ReferenceNode lhs, ExpressionNode index) {
            super(lhs.resourceName, lhs.lineNumber);
            this.lhs = lhs;
            this.index = index;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            Object lhsValue = this.lhs.evaluate(context);
            if (lhsValue == null) {
                throw this.evaluationException("Cannot index null value");
            }
            if (lhsValue instanceof List) {
                Object indexValue = this.index.evaluate(context);
                if (!(indexValue instanceof Integer)) {
                    throw this.evaluationException("List index is not an integer: " + indexValue);
                }
                List lhsList = (List)lhsValue;
                int i = (Integer)indexValue;
                if (i < 0 || i >= lhsList.size()) {
                    throw this.evaluationException("List index " + i + " is not valid for list of size " + lhsList.size());
                }
                return lhsList.get(i);
            }
            if (lhsValue instanceof Map) {
                Object indexValue = this.index.evaluate(context);
                Map lhsMap = (Map)lhsValue;
                return lhsMap.get(indexValue);
            }
            MethodReferenceNode node = new MethodReferenceNode(this.lhs, "get", $ImmutableList.of(this.index));
            return node.evaluate(context);
        }
    }

    static class MemberReferenceNode
    extends ReferenceNode {
        final ReferenceNode lhs;
        final String id;
        private static final String[] PREFIXES = new String[]{"get", "is"};
        private static final boolean[] CHANGE_CASE = new boolean[]{false, true};

        MemberReferenceNode(ReferenceNode lhs, String id) {
            super(lhs.resourceName, lhs.lineNumber);
            this.lhs = lhs;
            this.id = id;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            Object lhsValue = this.lhs.evaluate(context);
            if (lhsValue == null) {
                throw this.evaluationException("Cannot get member " + this.id + " of null value");
            }
            for (String prefix : PREFIXES) {
                for (boolean changeCase : CHANGE_CASE) {
                    String baseId = changeCase ? MemberReferenceNode.changeInitialCase(this.id) : this.id;
                    String methodName = prefix + baseId;
                    try {
                        Method method = lhsValue.getClass().getMethod(methodName, new Class[0]);
                        if (prefix.equals("is") && !method.getReturnType().equals(Boolean.TYPE)) continue;
                        return this.invokeMethod(method, lhsValue, $ImmutableList.of());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            throw this.evaluationException("Member " + this.id + " does not correspond to a public getter of " + lhsValue + ", a " + lhsValue.getClass().getName());
        }

        private static String changeInitialCase(String id) {
            int initial = id.codePointAt(0);
            String rest = id.substring(Character.charCount(initial));
            if (Character.isUpperCase(initial)) {
                initial = Character.toLowerCase(initial);
            } else if (Character.isLowerCase(initial)) {
                initial = Character.toUpperCase(initial);
            }
            return new StringBuilder().appendCodePoint(initial).append(rest).toString();
        }
    }

    static class PlainReferenceNode
    extends ReferenceNode {
        final String id;

        PlainReferenceNode(String resourceName, int lineNumber, String id) {
            super(resourceName, lineNumber);
            this.id = id;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            if (context.varIsDefined(this.id)) {
                return context.getVar(this.id);
            }
            throw this.evaluationException("Undefined reference $" + this.id);
        }

        @Override
        boolean isDefinedAndTrue(EvaluationContext context) {
            if (context.varIsDefined(this.id)) {
                return this.isTrue(context);
            }
            return false;
        }
    }
}

