/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.block;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.BlockImpl;
import org.checkerframework.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.dataflow.cfg.block.SingleSuccessorBlockImpl;
import org.checkerframework.dataflow.cfg.node.Node;

public class ExceptionBlockImpl
extends SingleSuccessorBlockImpl
implements ExceptionBlock {
    protected final Map<TypeMirror, Set<Block>> exceptionalSuccessors = new HashMap<TypeMirror, Set<Block>>();
    protected Node node;

    public ExceptionBlockImpl() {
        super(Block.BlockType.EXCEPTION_BLOCK);
    }

    public void setNode(Node c) {
        this.node = c;
        c.setBlock(this);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public void addExceptionalSuccessor(BlockImpl b, TypeMirror cause) {
        Set<Block> blocks = this.exceptionalSuccessors.get(cause);
        if (blocks == null) {
            blocks = new HashSet<Block>();
            this.exceptionalSuccessors.put(cause, blocks);
        }
        blocks.add(b);
        b.addPredecessor(this);
    }

    @Override
    public Map<TypeMirror, Set<Block>> getExceptionalSuccessors() {
        if (this.exceptionalSuccessors == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.exceptionalSuccessors);
    }

    public String toString() {
        return "ExceptionBlock(" + this.node + ")";
    }
}

