/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.ConstEvaluator;
import com.google.turbine.binder.bound.AnnotationMetadata;
import com.google.turbine.binder.bound.ClassValue;
import com.google.turbine.binder.bound.EnumConstantValue;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineElementType;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public class ConstBinder {
    private final Env<FieldSymbol, Const.Value> constantEnv;
    private final ClassSymbol origin;
    private final SourceTypeBoundClass base;
    private final CompoundEnv<ClassSymbol, TypeBoundClass> env;
    private final ConstEvaluator constEvaluator;

    public ConstBinder(Env<FieldSymbol, Const.Value> constantEnv, ClassSymbol origin, CompoundEnv<ClassSymbol, TypeBoundClass> env, SourceTypeBoundClass base) {
        this.constantEnv = constantEnv;
        this.origin = origin;
        this.base = base;
        this.env = env;
        this.constEvaluator = new ConstEvaluator(origin, origin, base.memberImports(), base.source(), base.scope(), constantEnv, env);
    }

    public SourceTypeBoundClass bind() {
        ImmutableList<AnnoInfo> annos = new ConstEvaluator(this.origin, this.base.owner(), this.base.memberImports(), this.base.source(), this.base.enclosingScope(), this.constantEnv, this.env).evaluateAnnotations(this.base.annotations());
        ImmutableList<TypeBoundClass.FieldInfo> fields = this.fields(this.base.fields());
        ImmutableList<TypeBoundClass.MethodInfo> methods = this.bindMethods(this.base.methods());
        return new SourceTypeBoundClass(this.bindClassTypes(this.base.interfaceTypes()), this.base.superClassType() != null ? this.bindClassType(this.base.superClassType()) : null, this.bindTypeParameters(this.base.typeParameterTypes()), this.base.access(), methods, fields, this.base.owner(), this.base.kind(), this.base.children(), this.base.typeParameters(), this.base.enclosingScope(), this.base.scope(), this.base.memberImports(), ConstBinder.bindAnnotationMetadata(this.base.kind(), annos), annos, this.base.source());
    }

    private ImmutableList<TypeBoundClass.MethodInfo> bindMethods(ImmutableList<TypeBoundClass.MethodInfo> methods) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.MethodInfo f : methods) {
            result.add((Object)this.bindMethod(f));
        }
        return result.build();
    }

    private TypeBoundClass.MethodInfo bindMethod(TypeBoundClass.MethodInfo base) {
        Const value = null;
        if (base.decl() != null && base.decl().defaultValue().isPresent()) {
            value = this.constEvaluator.evalAnnotationValue(base.decl().defaultValue().get(), base.returnType());
        }
        return new TypeBoundClass.MethodInfo(base.sym(), this.bindTypeParameters(base.tyParams()), this.bindType(base.returnType()), this.bindParameters(base.parameters()), this.bindTypes(base.exceptions()), base.access(), value, base.decl(), this.constEvaluator.evaluateAnnotations(base.annotations()), base.receiver() != null ? this.bindParameter(base.receiver()) : null);
    }

    private ImmutableList<TypeBoundClass.ParamInfo> bindParameters(ImmutableList<TypeBoundClass.ParamInfo> formals) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.ParamInfo base : formals) {
            result.add((Object)this.bindParameter(base));
        }
        return result.build();
    }

    private TypeBoundClass.ParamInfo bindParameter(TypeBoundClass.ParamInfo base) {
        ImmutableList<AnnoInfo> annos = this.constEvaluator.evaluateAnnotations(base.annotations());
        return new TypeBoundClass.ParamInfo(this.bindType(base.type()), base.name(), annos, base.access());
    }

    static AnnotationMetadata bindAnnotationMetadata(TurbineTyKind kind, Iterable<AnnoInfo> annotations) {
        if (kind != TurbineTyKind.ANNOTATION) {
            return null;
        }
        RetentionPolicy retention = null;
        ImmutableSet<TurbineElementType> target = null;
        ClassSymbol repeatable = null;
        for (AnnoInfo annotation : annotations) {
            switch (annotation.sym().binaryName()) {
                case "java/lang/annotation/Retention": {
                    retention = ConstBinder.bindRetention(annotation);
                    break;
                }
                case "java/lang/annotation/Target": {
                    target = ConstBinder.bindTarget(annotation);
                    break;
                }
                case "java/lang/annotation/Repeatable": {
                    repeatable = ConstBinder.bindRepeatable(annotation);
                    break;
                }
            }
        }
        return new AnnotationMetadata(retention, target, repeatable);
    }

    private static RetentionPolicy bindRetention(AnnoInfo annotation) {
        Const value = (Const)annotation.values().get((Object)"value");
        if (value.kind() != Const.Kind.ENUM_CONSTANT) {
            return null;
        }
        EnumConstantValue enumValue = (EnumConstantValue)value;
        if (!enumValue.sym().owner().binaryName().equals("java/lang/annotation/RetentionPolicy")) {
            return null;
        }
        return RetentionPolicy.valueOf(enumValue.sym().name());
    }

    private static ImmutableSet<TurbineElementType> bindTarget(AnnoInfo annotation) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        Const val = (Const)annotation.values().get((Object)"value");
        switch (val.kind()) {
            case ARRAY: {
                for (Const element : ((Const.ArrayInitValue)val).elements()) {
                    if (element.kind() != Const.Kind.ENUM_CONSTANT) continue;
                    ConstBinder.bindTargetElement((ImmutableSet.Builder<TurbineElementType>)result, (EnumConstantValue)element);
                }
                break;
            }
            case ENUM_CONSTANT: {
                ConstBinder.bindTargetElement((ImmutableSet.Builder<TurbineElementType>)result, (EnumConstantValue)val);
                break;
            }
        }
        return result.build();
    }

    private static ClassSymbol bindRepeatable(AnnoInfo annotation) {
        Const value = (Const)annotation.values().get((Object)"value");
        if (value.kind() != Const.Kind.CLASS_LITERAL) {
            return null;
        }
        Type type = ((ClassValue)value).type();
        if (type.tyKind() != Type.TyKind.CLASS_TY) {
            return null;
        }
        return ((Type.ClassTy)type).sym();
    }

    private static void bindTargetElement(ImmutableSet.Builder<TurbineElementType> target, EnumConstantValue enumVal) {
        if (enumVal.sym().owner().binaryName().equals("java/lang/annotation/ElementType")) {
            target.add((Object)TurbineElementType.valueOf(enumVal.sym().name()));
        }
    }

    private ImmutableList<TypeBoundClass.FieldInfo> fields(ImmutableList<TypeBoundClass.FieldInfo> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.FieldInfo base : fields) {
            Const.Value value = this.fieldValue(base);
            result.add((Object)new TypeBoundClass.FieldInfo(base.sym(), this.bindType(base.type()), base.access(), this.constEvaluator.evaluateAnnotations(base.annotations()), base.decl(), value));
        }
        return result.build();
    }

    private Const.Value fieldValue(TypeBoundClass.FieldInfo base) {
        if (base.decl() == null || !base.decl().init().isPresent()) {
            return null;
        }
        if ((base.access() & 0x10) == 0) {
            return null;
        }
        switch (base.type().tyKind()) {
            case PRIM_TY: {
                break;
            }
            case CLASS_TY: {
                if (((Type.ClassTy)base.type()).sym().equals(ClassSymbol.STRING)) break;
            }
            default: {
                return null;
            }
        }
        Const.Value value = this.constantEnv.get(base.sym());
        if (value != null) {
            value = (Const.Value)ConstEvaluator.cast(base.type(), value);
        }
        return value;
    }

    private ImmutableList<Type.ClassTy> bindClassTypes(ImmutableList<Type.ClassTy> types) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type.ClassTy t : types) {
            result.add((Object)this.bindClassType(t));
        }
        return result.build();
    }

    private ImmutableList<Type> bindTypes(ImmutableList<Type> types) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type t : types) {
            result.add((Object)this.bindType(t));
        }
        return result.build();
    }

    private ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> bindTypeParameters(ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typarams) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry entry : typarams.entrySet()) {
            TypeBoundClass.TyVarInfo info = (TypeBoundClass.TyVarInfo)entry.getValue();
            result.put(entry.getKey(), (Object)new TypeBoundClass.TyVarInfo(info.superClassBound() != null ? this.bindType(info.superClassBound()) : null, this.bindTypes(info.interfaceBounds()), this.constEvaluator.evaluateAnnotations(info.annotations())));
        }
        return result.build();
    }

    private Type bindType(Type type) {
        switch (type.tyKind()) {
            case TY_VAR: {
                Type.TyVar tyVar = (Type.TyVar)type;
                return new Type.TyVar(tyVar.sym(), this.constEvaluator.evaluateAnnotations(tyVar.annos()));
            }
            case CLASS_TY: {
                return this.bindClassType((Type.ClassTy)type);
            }
            case ARRAY_TY: {
                Type.ArrayTy arrayTy = (Type.ArrayTy)type;
                return new Type.ArrayTy(this.bindType(arrayTy.elementType()), this.constEvaluator.evaluateAnnotations(arrayTy.annos()));
            }
            case WILD_TY: {
                Type.WildTy wildTy = (Type.WildTy)type;
                switch (wildTy.boundKind()) {
                    case NONE: {
                        return new Type.WildUnboundedTy(this.constEvaluator.evaluateAnnotations(wildTy.annotations()));
                    }
                    case UPPER: {
                        return new Type.WildUpperBoundedTy(this.bindType(wildTy.bound()), this.constEvaluator.evaluateAnnotations(wildTy.annotations()));
                    }
                    case LOWER: {
                        return new Type.WildLowerBoundedTy(this.bindType(wildTy.bound()), this.constEvaluator.evaluateAnnotations(wildTy.annotations()));
                    }
                }
                throw new AssertionError((Object)wildTy.boundKind());
            }
            case PRIM_TY: 
            case VOID_TY: {
                return type;
            }
        }
        throw new AssertionError((Object)type.tyKind());
    }

    private Type.ClassTy bindClassType(Type.ClassTy type) {
        Type.ClassTy classTy = type;
        ImmutableList.Builder classes = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy c : classTy.classes) {
            classes.add((Object)new Type.ClassTy.SimpleClassTy(c.sym(), this.bindTypes(c.targs()), this.constEvaluator.evaluateAnnotations(c.annos())));
        }
        return new Type.ClassTy((Iterable<Type.ClassTy.SimpleClassTy>)classes.build());
    }
}

