/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@BugPattern(name="RedundantThrows", summary="Thrown exception is a subtype of another", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class RedundantThrows
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        List<? extends ExpressionTree> thrown = tree.getThrows();
        if (thrown.isEmpty()) {
            return Description.NO_MATCH;
        }
        LinkedHashMultimap exceptionsBySuper = LinkedHashMultimap.create();
        for (ExpressionTree expressionTree : thrown) {
            Object type = ASTHelpers.getType((Tree)expressionTree);
            do {
                type = state.getTypes().supertype((Type)type);
                exceptionsBySuper.put((Object)((Type)type).tsym, (Object)expressionTree);
            } while (!state.getTypes().isSameType((Type)type, state.getSymtab().objectType));
        }
        HashSet toRemove = new HashSet();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ExpressionTree expressionTree : thrown) {
            Symbol sym = ASTHelpers.getSymbol((Tree)expressionTree);
            if (!exceptionsBySuper.containsKey((Object)sym)) continue;
            Set sub = exceptionsBySuper.get((Object)sym);
            arrayList.add(String.format("%s %s of %s", RedundantThrows.oxfordJoin(", ", sub), sub.size() == 1 ? "is a subtype" : "are subtypes", sym.getSimpleName()));
            toRemove.addAll(sub);
        }
        if (toRemove.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableList delete = ImmutableList.copyOf((Iterable)Iterables.filter(tree.getThrows(), (Predicate)Predicates.in(toRemove)));
        return this.buildDescription((Tree)delete.get(0)).setMessage("Redundant throws clause: " + RedundantThrows.oxfordJoin("; ", arrayList)).addFix(SuggestedFixes.deleteExceptions((MethodTree)tree, (VisitorState)state, (List)delete)).build();
    }

    static String oxfordJoin(String on, Iterable<?> pieces) {
        StringBuilder result = new StringBuilder();
        int size = Iterables.size(pieces);
        if (size == 2) {
            return Joiner.on((String)" and ").join(pieces);
        }
        int idx = 0;
        for (Object piece : pieces) {
            if (idx > 0) {
                result.append(on);
                if (idx == size - 1) {
                    result.append("and ");
                }
            }
            result.append(piece);
            ++idx;
        }
        return result.toString();
    }
}

