/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_EqualsIncompatibleType_TypeCompatibilityReport;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

@BugPattern(name="EqualsIncompatibleType", summary="An equality test between objects with incompatible types always returns false", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class EqualsIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> STATIC_EQUALS_INVOCATION_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("android.support.v4.util.ObjectsCompat").named("equals").withParameters(new String[]{"java.lang.Object", "java.lang.Object"}), Matchers.isSameType((Supplier)Suppliers.BOOLEAN_TYPE)}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.util.Objects").named("equals").withParameters(new String[]{"java.lang.Object", "java.lang.Object"}), Matchers.isSameType((Supplier)Suppliers.BOOLEAN_TYPE)}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.base.Objects").named("equal").withParameters(new String[]{"java.lang.Object", "java.lang.Object"}), Matchers.isSameType((Supplier)Suppliers.BOOLEAN_TYPE)})});
    private static final Matcher<MethodInvocationTree> INSTANCE_EQUALS_INVOCATION_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().anyClass().named("equals").withParameters(new String[]{"java.lang.Object"}), Matchers.isSameType((Supplier)Suppliers.BOOLEAN_TYPE)});
    private static final Matcher<Tree> ASSERT_FALSE_MATCHER = Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().anyClass().named("assertFalse"), Matchers.staticMethod().anyClass().named("assertFalse")}));

    public Description matchMethodInvocation(MethodInvocationTree invocationTree, VisitorState state) {
        Type argumentType;
        Type receiverType;
        if (!STATIC_EQUALS_INVOCATION_MATCHER.matches((Tree)invocationTree, state) && !INSTANCE_EQUALS_INVOCATION_MATCHER.matches((Tree)invocationTree, state)) {
            return Description.NO_MATCH;
        }
        if (STATIC_EQUALS_INVOCATION_MATCHER.matches((Tree)invocationTree, state)) {
            receiverType = ASTHelpers.getType((Tree)invocationTree.getArguments().get(0));
            argumentType = ASTHelpers.getType((Tree)invocationTree.getArguments().get(1));
        } else {
            receiverType = ASTHelpers.getReceiverType((ExpressionTree)invocationTree);
            argumentType = ASTHelpers.getType((Tree)invocationTree.getArguments().get(0));
        }
        TypeCompatibilityReport compatibilityReport = EqualsIncompatibleType.compatibilityOfTypes(receiverType, argumentType, state);
        if (compatibilityReport.compatible()) {
            return Description.NO_MATCH;
        }
        if (ASSERT_FALSE_MATCHER.matches(state.getPath().getParentPath().getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(invocationTree).setMessage(EqualsIncompatibleType.getMessage(invocationTree, receiverType, argumentType, compatibilityReport.lhs(), compatibilityReport.rhs(), state)).build();
    }

    public static TypeCompatibilityReport compatibilityOfTypes(Type receiverType, Type argumentType, VisitorState state) {
        return EqualsIncompatibleType.compatibilityOfTypes(receiverType, argumentType, new HashSet<Type>(), new HashSet<Type>(), state);
    }

    public static TypeCompatibilityReport compatibilityOfTypes(Type receiverType, Type argumentType, Set<Type> previousReceiverTypes, Set<Type> previousArgumentTypes, VisitorState state) {
        if (receiverType == null || argumentType == null) {
            return TypeCompatibilityReport.createCompatibleReport();
        }
        if (ASTHelpers.isCastable((Type)argumentType, (Type)receiverType, (VisitorState)state)) {
            return EqualsIncompatibleType.leastUpperBoundGenericMismatch(receiverType, argumentType, previousReceiverTypes, previousArgumentTypes, state);
        }
        Types types = state.getTypes();
        Predicate equalsPredicate = methodSymbol -> !methodSymbol.isStatic() && (methodSymbol.flags() & 0x1000L) == 0L && types.isSameType(methodSymbol.getReturnType(), state.getSymtab().booleanType) && ((List)methodSymbol.getParameters()).size() == 1 && types.isSameType(((Symbol.VarSymbol)((List)methodSymbol.getParameters()).get((int)0)).type, state.getSymtab().objectType);
        Set overridesOfEquals = ASTHelpers.findMatchingMethods((Name)state.getName("equals"), (Predicate)equalsPredicate, (Type)receiverType, (Types)types);
        Symbol.TypeSymbol argumentClass = ASTHelpers.getUpperBound((Type)argumentType, (Types)state.getTypes()).tsym;
        for (Symbol.MethodSymbol method : overridesOfEquals) {
            Symbol.ClassSymbol methodClass = method.enclClass();
            if (!argumentClass.isSubClass(methodClass, types) || methodClass.equals(state.getSymtab().objectType.tsym) || methodClass.equals(state.getSymtab().enumSym)) continue;
            return EqualsIncompatibleType.leastUpperBoundGenericMismatch(receiverType, argumentType, previousReceiverTypes, previousArgumentTypes, state);
        }
        return TypeCompatibilityReport.incompatible(receiverType, argumentType);
    }

    private static TypeCompatibilityReport leastUpperBoundGenericMismatch(Type receiverType, Type argumentType, Set<Type> previousReceiverTypes, Set<Type> previousArgumentTypes, VisitorState state) {
        Type lub = state.getTypes().lub(argumentType, receiverType);
        if (lub.getTag().equals((Object)TypeTag.BOT) || lub.getTag().equals((Object)TypeTag.ERROR)) {
            return TypeCompatibilityReport.createCompatibleReport();
        }
        TypeCompatibilityReport compatibilityReport = EqualsIncompatibleType.matchesSubtypeAndIsGenericMismatch(receiverType, argumentType, lub, previousReceiverTypes, previousArgumentTypes, state);
        if (!compatibilityReport.compatible()) {
            return compatibilityReport;
        }
        Type collectionType = state.getTypeFromString("java.util.Collection");
        if (ASTHelpers.isSameType((Type)lub, (Type)collectionType, (VisitorState)state) && !ASTHelpers.isSameType((Type)receiverType, (Type)collectionType, (VisitorState)state) && !ASTHelpers.isSameType((Type)argumentType, (Type)collectionType, (VisitorState)state)) {
            return TypeCompatibilityReport.incompatible(receiverType, argumentType);
        }
        return compatibilityReport;
    }

    private static TypeCompatibilityReport matchesSubtypeAndIsGenericMismatch(Type receiverType, Type argumentType, Type superType, Set<Type> previousReceiverTypes, Set<Type> previousArgumentTypes, VisitorState state) {
        java.util.List<Type> receiverTypes = EqualsIncompatibleType.typeArgsAsSuper(receiverType, superType, state);
        java.util.List<Type> argumentTypes = EqualsIncompatibleType.typeArgsAsSuper(argumentType, superType, state);
        return Streams.zip(receiverTypes.stream(), argumentTypes.stream(), TypePair::new).filter(tp -> !previousReceiverTypes.contains(tp.receiver) && !tp.receiver.equals(receiverType) && !previousArgumentTypes.contains(tp.argument) && !tp.argument.equals(argumentType)).map(types -> EqualsIncompatibleType.compatibilityOfTypes(types.receiver, types.argument, (Set<Type>)Sets.union((Set)previousReceiverTypes, (Set)ImmutableSet.of((Object)receiverType)), (Set<Type>)Sets.union((Set)previousArgumentTypes, (Set)ImmutableSet.of((Object)argumentType)), state)).filter(tcr -> !tcr.compatible()).findFirst().orElse(TypeCompatibilityReport.createCompatibleReport());
    }

    private static java.util.List<Type> typeArgsAsSuper(Type baseType, Type superType, VisitorState state) {
        Type projectedType = state.getTypes().asSuper(baseType, superType.tsym);
        if (projectedType != null) {
            return projectedType.getTypeArguments();
        }
        return new ArrayList<Type>();
    }

    private static String getMessage(MethodInvocationTree invocationTree, Type receiverType, Type argumentType, Type conflictingReceiverType, Type conflictingArgumentType, VisitorState state) {
        TypeStringPair typeStringPair = new TypeStringPair(receiverType, argumentType);
        String baseMessage = "Calling " + ASTHelpers.getSymbol((MethodInvocationTree)invocationTree).getSimpleName() + " on incompatible types " + typeStringPair.getReceiverTypeString() + " and " + typeStringPair.getArgumentTypeString();
        if (!state.getTypes().isSameType(receiverType, conflictingReceiverType)) {
            TypeStringPair conflictingTypes = new TypeStringPair(conflictingReceiverType, conflictingArgumentType);
            baseMessage = baseMessage + ". They are incompatible because " + conflictingTypes.getReceiverTypeString() + " and " + conflictingTypes.getArgumentTypeString() + " are incompatible.";
        }
        return baseMessage;
    }

    public static class TypeStringPair {
        private String receiverTypeString;
        private String argumentTypeString;

        public TypeStringPair(Type receiverType, Type argumentType) {
            this.receiverTypeString = Signatures.prettyType((Type)receiverType);
            this.argumentTypeString = Signatures.prettyType((Type)argumentType);
            if (this.argumentTypeString.equals(this.receiverTypeString)) {
                this.receiverTypeString = receiverType.toString();
                this.argumentTypeString = argumentType.toString();
            }
        }

        public String getReceiverTypeString() {
            return this.receiverTypeString;
        }

        public String getArgumentTypeString() {
            return this.argumentTypeString;
        }
    }

    @AutoValue
    public static abstract class TypeCompatibilityReport {
        public abstract boolean compatible();

        @Nullable
        public abstract Type lhs();

        @Nullable
        public abstract Type rhs();

        static TypeCompatibilityReport createCompatibleReport() {
            return new AutoValue_EqualsIncompatibleType_TypeCompatibilityReport(true, null, null);
        }

        static TypeCompatibilityReport incompatible(Type lhs, Type rhs) {
            return new AutoValue_EqualsIncompatibleType_TypeCompatibilityReport(false, lhs, rhs);
        }
    }

    private static final class TypePair {
        final Type receiver;
        final Type argument;

        TypePair(Type receiver, Type argument) {
            this.receiver = receiver;
            this.argument = argument;
        }
    }
}

