#!/bin/sh
#!/bin/bash
#testloc ()
#{
#	printf "\n\n\n${ESC}[3A"
#}

_bashish_c64_cbmerror ()
{

## CBM basic error messages, from: http://www.devili.iki.fi/Computers/Commodore/C64/Programmers_Reference/Appendices/page_400.html
##
## This appendix contains a complete list of the error messages generated by the Commodore-64, with a description of causes.
## 
## BAD DATA String data was received from an open file, but the program was expecting numeric data.
## 
## BAD SUBSCRIPT The program was trying to reference an element of an array whose number is outside of the range specified in the DIM statement.
## 
## BREAK Program execution was stopped because you hit the <STOP> key.
## 
## CAN'T CONTINUE The CONT command will not work, either because the program was never RUN, there has been an error, or a line has been edited.
## 
## DEVICE NOT PRESENT The required I/O device was not available for an OPEN, CLOSE, CMD, PRINT#, INPUT#, or GET#.
## 
## DIVISION BY ZERO Division by zero is a mathematical oddity and not allowed.
## 
## EXTRA IGNORED Too many items of data were typed in response to an INPUT statement. Only the first few items were accepted.
## 
## FILE NOT FOUND If you were looking for a file on tape, and END-OF-TAPE marker was found. If you were looking on disk, no file with that name exists.
## 
## FILE NOT OPEN The file specified in a CLOSE, CMD, PRINT#, INPUT#, or GET#, must first be OPENed.
## 
## FILE OPEN An attempt was made to open a file using the number of an already open file.
## 
## FORMULA TOO COMPLEX The string expression being evaluated should be split into at least two parts for the system to work with, or a formula has too many parentheses.
## 
## ILLEGAL DIRECT The INPUT statement can only be used within a program, and not in direct mode.
## 
## ILLEGAL QUANTITY A number used as the argument of a function or statement is out of the allowable range.
## 
## LOAD There is a problem with the program on tape.
## 
## NEXT WITHOUT FOR This is caused by either incorrectly nesting loops or having a variable name in a NEXT statement that doesn't correspond with one in a FOR statement.
## 
## NOT INPUT FILE An attempt was made to INPUT or GET data from a file which was specified to be for output only.
## 
## NOT OUTPUT FILE An attempt was mode to PRINT data to a file which was specified as input only.
## 
## OUT OF DATA A READ statement was executed but there is no data left unREAD in a DATA statement.
## 
## OUT OF MEMORY There is no more RAM available for program or variables. This may also occur when too many FOR loops have been nested, or when there are too many GOSUBs in effect.
## 
## OVERFLOW The result of a computation is larger than the largest number allowed, which is 1.70141884E+38.
## 
## REDIM'D ARRAY An array may only be DIMensioned once. If an array variable is used before that array is DIM'D, an automatic DIM operation is performed on that array setting the number of elements to ten, and any subsequent DIMs will cause this error.
## 
## REDO FROM START Character data was typed in during an INPUT statement when numeric data was expected. Just re-type the entry so that it is correct, and the program will continue by itself.
## 
## RETURN WITHOUT GOSUBA RETURN statement was encountered, and no GOSUB command has been issued.
## 
## STRING TOO LONG A string can contain up to 255 characters.
## 
## ?SYNTAX ERROR A statement is unrecognizable by the Commodore 64. A missing or extra parenthesis, misspelled keywords, etc.
## 
## TYPE MISMATCH This error occurs when a number is used in place of a string, or vice-versa.
## 
## UNDEF'D FUNCTION A user defined function was referenced, but it has never been defined using the DEF FN statement.
## 
## UNDEF'D STATEMENT An attempt was made to GOTO or GOSUB or RUN a line number that doesn't exist.
## 
## VERIFY The program on tape or disk does not match the program currently in memory. 
case "$?" in
127) printf "FILE NOT FOUND

";;
1) printf "FORMULA TOO COMPLEX

";;
0) :;;
*) printf "RETURN WITHOUT GOSUBA RETURN

"
esac
}
_bashish_prompt()
{
eval $(_bashish_prompt_shellvars $SHELLNAME)
PROMPT_COMMAND="_bashish_c64_cbmerror"
TITLE="C= 128"
test "x$PROMPTSTR" = x && local PROMPTSTR=READY.
FILLX=`_bashish_prompt_fillx " "`
PS1="\
${EMBED}${ESC}[r\
${ESC}[3F\
${ESC}[3E\
${ESC}[3E\
${ESC}[3F\
${UNEMBED}\
${ESC}7\
${ESC}[7m\
${ESC}[4;$(($LINES - 3))r\
${ESC}[0;0H\
$FILLX\
$FILLX\
$FILLX\
${ESC}[$(($LINES - 2));0H\
$FILLX$FILLX$FILLX\
${ESC}8\
${ESC}[0m\
${PROMPTSTR}
"
PS2="?SYNTAX ERROR
"
_bashish_prompt_asciilogo xcenter boot

}