## Highlights from the past week

- Atom IDE
  - Console logging started
  - IDE-Java/PHP/TypeScript updates and fixes
- GitHub Package
  - Recent commits view, read-only mode :tm: (@kuychaco, @smashwilson, @simurai) [#1322](https://github.com/atom/github/pull/1322)
  - Recent commits view: show co-authors (@kuychaco, @simurai)
  - Commit interactions research spike: undo most recent, amend (@kuychaco) [#1328](https://github.com/atom/github/pull/1328)
  - Port CommitView and CommitController to React. (@smashwilson) [#1325](https://github.com/atom/github/pull/1325)
  - Begin "Remember me" within the credential dialog [#1327](https://github.com/atom/github/pull/1327)
- Tree-sitter
  - Shifted focus to address some open-source contributions to parsers:
    - Wrote documentation about how to create parsers: http://tree-sitter.github.io/tree-sitter
    - Fixed issues with the Bash parser
  - Fixed a bug found during constant fuzzing by the security team: https://github.com/tree-sitter/tree-sitter/issues/133
- Xray
  - Decided not to run all text through HarfBuzz for performance reasons, and came up with a plan for addressing mandatory text shaping issues in the future.
  - Implemented anchors, selections, and basic selection movement.
  - Partially implemented selection rendering.
  - For more details, see the [detailed update](https://github.com/atom/xray/blob/master/docs/updates/2018_03_05.md) in the Xray repository.
- Engineering Improvements
  - Automated Linux package repository publishing as part of Atom release process
- Reactor Duty
  - Shipped node-keytar update, primary feature being prebuilt node modules ([atom/node-keytar#67](https://github.com/atom/node-keytar/pull/67))
  - Merged community pull requests to atom/atom-select-list, atom/command-palette, and atom/tree-view
  
## Focus for week ahead

- Atom IDE
  - Console logging completion
  - Investigate language server process hanging on deactivation in ide-typescript
  - Investigate using the new native LSP support in omnisharp-roslyn in ide-csharp
- @atom/watcher
  - Diagnose crashes and lockups on Atom launch (@smashwilson)
- GitHub Package
  - Finish "Remember me" within the credential dialog (@smashwilson) [#1327](https://github.com/atom/github/pull/1327)
  - Write up `docs/vision` from meeting notes (@smashwilson)
  - Kick-start our GPG pinentry handling (@smashwilson) [#846](https://github.com/atom/github/pull/846)
  - Build UI for adding co-authors, much like Desktop's UI/UX - desktop.github.com/features/co-authors/
- Teletype
  - Open pull request for the avatar UX enhancements described in ([atom/teletype#268](https://github.com/atom/teletype/issues/268))
- Tree-sitter
  - Carrying over goals from previous weeks:
    - Optimize syntax tree updates in the presence of syntax errors. This will improve performance across the board but also make Tree-sitter usable in edge cases where the wrong language is being used to parse a document.
    - Start work on allowing parsing to take place on a background thread
- Xray
  - Finish selection rendering
  - Wire up enough of the key bindings / commands system to move cursors/selections
  - Start on editing
  - For more details, see [the detailed update](https://github.com/atom/xray/blob/master/docs/updates/2018_03_05.md)
- Engineering Improvements
  - Finish new Atom release publishing automation
