/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.velocity.util.introspection.ConversionHandler;
import org.apache.velocity.util.introspection.IntrospectionUtils;

public class MethodMap {
    private static final int INCOMPARABLE = 0;
    private static final int MORE_SPECIFIC = 1;
    private static final int EQUIVALENT = 2;
    private static final int LESS_SPECIFIC = 3;
    private static final int NOT_CONVERTIBLE = 0;
    private static final int EXPLICITLY_CONVERTIBLE = 1;
    private static final int IMPLCITLY_CONVERTIBLE = 2;
    private static final int STRICTLY_CONVERTIBLE = 3;
    ConversionHandler conversionHandler;
    Map methodByNameMap = new ConcurrentHashMap();

    public MethodMap() {
        this(null);
    }

    public MethodMap(ConversionHandler conversionHandler) {
        this.conversionHandler = conversionHandler;
    }

    public void add(Method method) {
        String string = method.getName();
        ArrayList<Method> arrayList = this.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Method>();
            this.methodByNameMap.put(string, arrayList);
        }
        arrayList.add(method);
    }

    public List get(String string) {
        return (List)this.methodByNameMap.get(string);
    }

    public Method find(String string, Object[] objectArray) throws AmbiguousException {
        List list = this.get(string);
        if (list == null) {
            return null;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            classArray[i] = object == null ? null : object.getClass();
        }
        return this.getBestMatch(list, classArray);
    }

    private static boolean onlyNullOrObjects(Class[] classArray) {
        for (Class clazz : classArray) {
            if (clazz == null || clazz == Object.class) continue;
            return false;
        }
        return classArray.length > 0;
    }

    private Method getBestMatch(List<Method> list, Class[] classArray) {
        LinkedList<Match> linkedList = new LinkedList<Match>();
        Class[] classArray2 = new Class[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray2[i] = IntrospectionUtils.getUnboxedClass(classArray[i]);
        }
        for (Method method : list) {
            int n = this.getApplicability(method, classArray2);
            if (n <= 0) continue;
            Match match = new Match(method, n, classArray2);
            if (linkedList.size() == 0) {
                linkedList.add(match);
                continue;
            }
            boolean bl = true;
            ListIterator listIterator = linkedList.listIterator();
            while (bl && listIterator.hasNext()) {
                Match match2 = (Match)listIterator.next();
                if (match2.specificity == 3 && match.specificity < 2) {
                    bl = false;
                    continue;
                }
                if (match.specificity == 3 && match2.specificity < 2) {
                    listIterator.remove();
                    continue;
                }
                if (match2.applicability > match.applicability) {
                    bl = false;
                    continue;
                }
                if (match2.applicability < match.applicability) {
                    listIterator.remove();
                    continue;
                }
                if (MethodMap.onlyNullOrObjects(classArray)) {
                    if (match.varargs == match2.varargs) continue;
                    if (match.varargs) {
                        bl = false;
                        continue;
                    }
                    if (!match2.varargs) continue;
                    listIterator.remove();
                    continue;
                }
                switch (this.compare(match.methodTypes, match2.methodTypes)) {
                    case 3: {
                        bl = false;
                        break;
                    }
                    case 1: {
                        listIterator.remove();
                        break;
                    }
                }
            }
            if (!bl) continue;
            linkedList.add(match);
        }
        switch (linkedList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return ((Match)linkedList.get((int)0)).method;
            }
        }
        throw new AmbiguousException();
    }

    private int compare(Class[] classArray, Class[] classArray2) {
        boolean bl;
        int n;
        Class<?> clazz;
        int n2;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (classArray.length > classArray2.length) {
            n2 = classArray2.length;
            if (n2 == 0) {
                return 1;
            }
            clazz = (classArray2 = Arrays.copyOf(classArray2, classArray.length))[n2 - 1].getComponentType();
            if (clazz == null) {
                bl2 = true;
                classArray2[classArray.length - 1] = null;
            } else {
                bl3 = true;
                for (n = n2 - 1; n < classArray.length; ++n) {
                    classArray2[n] = clazz;
                }
            }
            bl4 = true;
        } else if (classArray2.length > classArray.length) {
            n2 = classArray.length;
            if (n2 == 0) {
                return 3;
            }
            clazz = (classArray = Arrays.copyOf(classArray, classArray2.length))[n2 - 1].getComponentType();
            if (clazz == null) {
                bl3 = true;
                classArray[classArray2.length - 1] = null;
            } else {
                bl2 = true;
                for (n = n2 - 1; n < classArray2.length; ++n) {
                    classArray[n] = clazz;
                }
            }
            bl4 = true;
        }
        n2 = 3;
        int n3 = 3;
        block12: for (n = 0; n < classArray.length; ++n) {
            boolean bl5 = bl = !bl4 && n == classArray.length - 1;
            if (classArray[n] == classArray2[n]) continue;
            if (classArray[n] == null) {
                n3 = 0;
                if (!classArray2[n].isPrimitive()) continue;
                n2 = 0;
                continue;
            }
            if (classArray2[n] == null) {
                n2 = 0;
                if (!classArray[n].isPrimitive()) continue;
                n3 = 0;
                continue;
            }
            switch (n2) {
                case 3: {
                    if (MethodMap.isStrictConvertible(classArray2[n], classArray[n], bl)) break;
                    n2 = 2;
                }
                case 2: {
                    if (this.isConvertible(classArray2[n], classArray[n], bl)) break;
                    n2 = 1;
                }
                case 1: {
                    if (this.isExplicitlyConvertible(classArray2[n], classArray[n], bl)) break;
                    n2 = 0;
                }
            }
            switch (n3) {
                case 3: {
                    if (MethodMap.isStrictConvertible(classArray[n], classArray2[n], bl)) continue block12;
                    n3 = 2;
                }
                case 2: {
                    if (this.isConvertible(classArray[n], classArray2[n], bl)) continue block12;
                    n3 = 1;
                }
                case 1: {
                    if (this.isExplicitlyConvertible(classArray[n], classArray2[n], bl)) continue block12;
                    n3 = 0;
                }
            }
        }
        if (n2 == 0 && n3 == 0) {
            return 0;
        }
        if (n2 > n3) {
            return 1;
        }
        if (n3 > n2) {
            return 3;
        }
        n = bl2 || !bl4 && classArray[classArray.length - 1].isArray() ? 1 : 0;
        boolean bl6 = bl = bl3 || !bl4 && classArray2[classArray2.length - 1].isArray();
        if (n != 0 && !bl) {
            return 3;
        }
        if (n == 0 && bl) {
            return 1;
        }
        return 2;
    }

    private int getApplicability(Method method, Class[] classArray) {
        Class<?>[] classArray2 = method.getParameterTypes();
        int n = 3;
        if (classArray2.length > classArray.length) {
            if (classArray2.length == classArray.length + 1 && classArray2[classArray2.length - 1].isArray()) {
                for (int i = 0; i < classArray.length; ++i) {
                    if (MethodMap.isStrictConvertible(classArray2[i], classArray[i], false)) continue;
                    if (this.isConvertible(classArray2[i], classArray[i], false)) {
                        n = Math.min(n, 2);
                        continue;
                    }
                    if (this.isExplicitlyConvertible(classArray2[i], classArray[i], false)) {
                        n = Math.min(n, 1);
                        continue;
                    }
                    return 0;
                }
                return n;
            }
            return 0;
        }
        if (classArray2.length == classArray.length) {
            for (int i = 0; i < classArray.length; ++i) {
                if (MethodMap.isStrictConvertible(classArray2[i], classArray[i], i == classArray.length - 1 && classArray2[i].isArray())) continue;
                if (this.isConvertible(classArray2[i], classArray[i], i == classArray.length - 1 && classArray2[i].isArray())) {
                    n = Math.min(n, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(classArray2[i], classArray[i], i == classArray.length - 1 && classArray2[i].isArray())) {
                    n = Math.min(n, 1);
                    continue;
                }
                return 0;
            }
            return n;
        }
        if (classArray2.length > 0) {
            Class<?> clazz = classArray2[classArray2.length - 1];
            if (!clazz.isArray()) {
                return 0;
            }
            for (int i = 0; i < classArray2.length - 1; ++i) {
                if (MethodMap.isStrictConvertible(classArray2[i], classArray[i], false)) continue;
                if (this.isConvertible(classArray2[i], classArray[i], false)) {
                    n = Math.min(n, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(classArray2[i], classArray[i], false)) {
                    n = Math.min(n, 1);
                    continue;
                }
                return 0;
            }
            Class<?> clazz2 = clazz.getComponentType();
            for (int i = classArray2.length - 1; i < classArray.length; ++i) {
                if (MethodMap.isStrictConvertible(clazz2, classArray[i], false)) continue;
                if (this.isConvertible(clazz2, classArray[i], false)) {
                    n = Math.min(n, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(clazz2, classArray[i], false)) {
                    n = Math.min(n, 1);
                    continue;
                }
                return 0;
            }
            return n;
        }
        return 0;
    }

    private boolean isConvertible(Class clazz, Class clazz2, boolean bl) {
        return IntrospectionUtils.isMethodInvocationConvertible(clazz, clazz2, bl);
    }

    private static boolean isStrictConvertible(Class clazz, Class clazz2, boolean bl) {
        return IntrospectionUtils.isStrictMethodInvocationConvertible(clazz, clazz2, bl);
    }

    private boolean isExplicitlyConvertible(Class clazz, Class clazz2, boolean bl) {
        return this.conversionHandler != null && this.conversionHandler.isExplicitlyConvertible(clazz, clazz2, bl);
    }

    public static class AmbiguousException
    extends RuntimeException {
        private static final long serialVersionUID = -2314636505414551663L;
    }

    private class Match {
        Method method;
        Class[] methodTypes;
        int specificity;
        int applicability;
        boolean varargs;

        Match(Method method, int n, Class[] classArray) {
            this.method = method;
            this.applicability = n;
            this.methodTypes = method.getParameterTypes();
            this.specificity = MethodMap.this.compare(this.methodTypes, classArray);
            this.varargs = this.methodTypes.length > 0 && this.methodTypes[this.methodTypes.length - 1].isArray();
        }
    }
}

