/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix;

import org.apache.mahout.math.PersistentObject;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.jet.random.engine.MersenneTwister;
import org.apache.mahout.math.jet.random.sampling.RandomSamplingAssistant;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.RCDoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.SparseDoubleMatrix2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DoubleFactory2D
extends PersistentObject {
    private static final Logger log = LoggerFactory.getLogger(DoubleFactory2D.class);
    public static final DoubleFactory2D dense = new DoubleFactory2D();
    private static final DoubleFactory2D sparse = new DoubleFactory2D();
    private static final DoubleFactory2D rowCompressed = new DoubleFactory2D();

    protected DoubleFactory2D() {
    }

    public DoubleMatrix2D appendColumns(DoubleMatrix2D A, DoubleMatrix2D B) {
        if (B.rows() > A.rows()) {
            B = B.viewPart(0, 0, A.rows(), B.columns());
        } else if (B.rows() < A.rows()) {
            A = A.viewPart(0, 0, B.rows(), A.columns());
        }
        int ac = A.columns();
        int bc = B.columns();
        int r = A.rows();
        DoubleMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewPart(0, ac, r, bc).assign(B);
        return matrix;
    }

    public DoubleMatrix2D appendRows(DoubleMatrix2D A, DoubleMatrix2D B) {
        if (B.columns() > A.columns()) {
            B = B.viewPart(0, 0, B.rows(), A.columns());
        } else if (B.columns() < A.columns()) {
            A = A.viewPart(0, 0, A.rows(), B.columns());
        }
        int ar = A.rows();
        int br = B.rows();
        int c = A.columns();
        DoubleMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewPart(ar, 0, br, c).assign(B);
        return matrix;
    }

    public DoubleMatrix2D ascending(int rows, int columns) {
        return this.descending(rows, columns).assign(Functions.chain(Functions.negate, Functions.minus(columns * rows)));
    }

    protected static void checkRectangularShape(double[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    private static void checkRectangularShape(DoubleMatrix2D[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public DoubleMatrix2D compose(DoubleMatrix2D[][] parts) {
        int row;
        DoubleFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        DoubleMatrix2D empty = this.make(0, 0);
        if (rows == 0 || columns == 0) {
            return empty;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                DoubleMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                DoubleMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        DoubleMatrix2D matrix = this.make(resultRows, resultCols);
        int r = 0;
        for (int row3 = 0; row3 < rows; ++row3) {
            int c = 0;
            for (int column4 = 0; column4 < columns; ++column4) {
                DoubleMatrix2D part = parts[row3][column4];
                if (part != null) {
                    matrix.viewPart(r, c, part.rows(), part.columns()).assign(part);
                }
                c += maxWidths[column4];
            }
            r += maxHeights[row3];
        }
        return matrix;
    }

    public DoubleMatrix2D composeDiagonal(DoubleMatrix2D A, DoubleMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        DoubleMatrix2D sum = this.make(ar + br, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar, ac, br, bc).assign(B);
        return sum;
    }

    public DoubleMatrix2D composeDiagonal(DoubleMatrix2D A, DoubleMatrix2D B, DoubleMatrix2D C) {
        DoubleMatrix2D diag = this.make(A.rows() + B.rows() + C.rows(), A.columns() + B.columns() + C.columns());
        diag.viewPart(0, 0, A.rows(), A.columns()).assign(A);
        diag.viewPart(A.rows(), A.columns(), B.rows(), B.columns()).assign(B);
        diag.viewPart(A.rows() + B.rows(), A.columns() + B.columns(), C.rows(), C.columns()).assign(C);
        return diag;
    }

    public void decompose(DoubleMatrix2D[][] parts, DoubleMatrix2D matrix) {
        int row;
        DoubleFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        if (rows == 0 || columns == 0) {
            return;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                DoubleMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                DoubleMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        if (matrix.rows() < resultRows || matrix.columns() < resultCols) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        int r = 0;
        for (int row3 = 0; row3 < rows; ++row3) {
            int c = 0;
            for (int column4 = 0; column4 < columns; ++column4) {
                DoubleMatrix2D part = parts[row3][column4];
                if (part != null) {
                    part.assign(matrix.viewPart(r, c, part.rows(), part.columns()));
                }
                c += maxWidths[column4];
            }
            r += maxHeights[row3];
        }
    }

    public DoubleMatrix2D descending(int rows, int columns) {
        DoubleMatrix2D matrix = this.make(rows, columns);
        int v = 0;
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                matrix.setQuick(row, column, v++);
            }
        }
        return matrix;
    }

    public DoubleMatrix2D diagonal(DoubleMatrix1D vector) {
        int size = vector.size();
        DoubleMatrix2D diag = this.make(size, size);
        int i = size;
        while (--i >= 0) {
            diag.setQuick(i, i, vector.getQuick(i));
        }
        return diag;
    }

    public DoubleMatrix1D diagonal(DoubleMatrix2D A) {
        int min = Math.min(A.rows(), A.columns());
        DoubleMatrix1D diag = this.make1D(min);
        int i = min;
        while (--i >= 0) {
            diag.setQuick(i, A.getQuick(i, i));
        }
        return diag;
    }

    public DoubleMatrix2D identity(int rowsAndColumns) {
        DoubleMatrix2D matrix = this.make(rowsAndColumns, rowsAndColumns);
        int i = rowsAndColumns;
        while (--i >= 0) {
            matrix.setQuick(i, i, 1.0);
        }
        return matrix;
    }

    public DoubleMatrix2D make(double[][] values) {
        if (this == sparse) {
            return new SparseDoubleMatrix2D(values);
        }
        return new DenseDoubleMatrix2D(values);
    }

    public DoubleMatrix2D make(double[] values, int rows) {
        int columns;
        int n = columns = rows != 0 ? values.length / rows : 0;
        if (rows * columns != values.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        DoubleMatrix2D matrix = this.make(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                matrix.setQuick(row, column, values[row + column * rows]);
            }
        }
        return matrix;
    }

    public DoubleMatrix2D make(int rows, int columns) {
        if (this == sparse) {
            return new SparseDoubleMatrix2D(rows, columns);
        }
        if (this == rowCompressed) {
            return new RCDoubleMatrix2D(rows, columns);
        }
        return new DenseDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrix2D make(int rows, int columns, double initialValue) {
        if (initialValue == 0.0) {
            return this.make(rows, columns);
        }
        return this.make(rows, columns).assign(initialValue);
    }

    protected DoubleMatrix1D make1D(int size) {
        return this.make(0, 0).like1D(size);
    }

    public DoubleMatrix2D random(int rows, int columns) {
        return this.make(rows, columns).assign(Functions.random());
    }

    public DoubleMatrix2D repeat(DoubleMatrix2D A, int rowRepeat, int columnRepeat) {
        int r = A.rows();
        int c = A.columns();
        DoubleMatrix2D matrix = this.make(r * rowRepeat, c * columnRepeat);
        int i = rowRepeat;
        while (--i >= 0) {
            int j = columnRepeat;
            while (--j >= 0) {
                matrix.viewPart(r * i, c * j, r, c).assign(A);
            }
        }
        return matrix;
    }

    public DoubleMatrix2D sample(int rows, int columns, double value, double nonZeroFraction) {
        DoubleMatrix2D matrix = this.make(rows, columns);
        this.sample(matrix, value, nonZeroFraction);
        return matrix;
    }

    public DoubleMatrix2D sample(DoubleMatrix2D matrix, double value, double nonZeroFraction) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        double epsilon = 1.0E-9;
        if (nonZeroFraction < 0.0 - epsilon || nonZeroFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0.0) {
            nonZeroFraction = 0.0;
        }
        if (nonZeroFraction > 1.0) {
            nonZeroFraction = 1.0;
        }
        matrix.assign(0.0);
        int size = rows * columns;
        int n = (int)Math.round((double)size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        RandomSamplingAssistant sampler = new RandomSamplingAssistant(n, size, new MersenneTwister());
        for (int i = 0; i < size; ++i) {
            if (!sampler.sampleNextElement()) continue;
            int row = i / columns;
            int column = i % columns;
            matrix.set(row, column, value);
        }
        return matrix;
    }
}

