/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import org.apache.mahout.math.jet.random.AbstractContinousDistribution;
import org.apache.mahout.math.jet.random.engine.RandomEngine;
import org.apache.mahout.math.jet.stat.Probability;

@Deprecated
public class Normal
extends AbstractContinousDistribution {
    private double mean;
    private double variance;
    private double standardDeviation;
    private double cache;
    private boolean cacheFilled;
    private double SQRT_INV;
    private static final Normal shared = new Normal(0.0, 1.0, Normal.makeDefaultGenerator());

    public Normal(double mean, double standardDeviation, RandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(mean, standardDeviation);
    }

    public double cdf(double x) {
        return Probability.normal(this.mean, this.variance, x);
    }

    public double nextDouble() {
        return this.nextDouble(this.mean, this.standardDeviation);
    }

    public double nextDouble(double mean, double standardDeviation) {
        double y;
        double x;
        double r;
        if (this.cacheFilled && this.mean == mean && this.standardDeviation == standardDeviation) {
            this.cacheFilled = false;
            return this.cache;
        }
        while ((r = (x = 2.0 * this.randomGenerator.raw() - 1.0) * x + (y = 2.0 * this.randomGenerator.raw() - 1.0) * y) >= 1.0) {
        }
        double z = Math.sqrt(-2.0 * Math.log(r) / r);
        this.cache = mean + standardDeviation * x * z;
        this.cacheFilled = true;
        return mean + standardDeviation * y * z;
    }

    public double pdf(double x) {
        double diff = x - this.mean;
        return this.SQRT_INV * Math.exp(-(diff * diff) / (2.0 * this.variance));
    }

    protected void setRandomGenerator(RandomEngine randomGenerator) {
        super.setRandomGenerator(randomGenerator);
        this.cacheFilled = false;
    }

    public void setState(double mean, double standardDeviation) {
        if (mean != this.mean || standardDeviation != this.standardDeviation) {
            this.mean = mean;
            this.standardDeviation = standardDeviation;
            this.variance = standardDeviation * standardDeviation;
            this.cacheFilled = false;
            this.SQRT_INV = 1.0 / Math.sqrt(Math.PI * 2 * this.variance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double mean, double standardDeviation) {
        Normal normal = shared;
        synchronized (normal) {
            return shared.nextDouble(mean, standardDeviation);
        }
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.mean + ',' + this.standardDeviation + ')';
    }
}

